/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.web.servlet.ModelAndView;

public class CollectionControllerServiceImpl
implements CollectionControllerService {
    private ModelAndViewService modelAndViewService;

    @Override
    public ModelAndView addLine(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewLifecycle.getHelper().processCollectionAddLine(form, parameters.selectedCollectionId, parameters.selectedCollectionPath);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView addBlankLine(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewLifecycle.getHelper().processCollectionAddBlankLine(form, parameters.selectedCollectionId, parameters.selectedCollectionPath);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView retrieveEditLineDialog(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewHelperService viewHelperService = ViewLifecycle.getHelper();
                viewHelperService.processCollectionRetrieveEditLineDialog(form, parameters.selectedCollectionId, parameters.selectedCollectionPath, parameters.selectedLineIndex);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView editLine(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewHelperService viewHelperService = ViewLifecycle.getHelper();
                viewHelperService.processCollectionEditLine(form, parameters);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView closeEditLineDialog(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewHelperService viewHelperService = ViewLifecycle.getHelper();
                viewHelperService.processCollectionCloseEditLineDialog(form, parameters.selectedCollectionId, parameters.selectedCollectionPath, parameters.selectedLineIndex);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView saveLine(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewHelperService viewHelperService = ViewLifecycle.getHelper();
                viewHelperService.processCollectionSaveLine(form, parameters);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    @Override
    public ModelAndView deleteLine(final UifFormBase form) {
        final CollectionActionParameters parameters = new CollectionActionParameters(form, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ViewLifecycle.getHelper().processCollectionDeleteLine(form, parameters.selectedCollectionId, parameters.selectedCollectionPath, parameters.selectedLineIndex);
            }
        };
        return this.performHelperLifecycle(form, runnable);
    }

    protected ModelAndView performHelperLifecycle(UifFormBase form, Runnable runnable) {
        ViewLifecycle.encapsulateLifecycle(form.getView(), form, form.getViewPostMetadata(), null, form.getRequest(), runnable);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView retrieveCollectionPage(UifFormBase form) {
        form.setCollectionPagingRequest(true);
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView tableJsonRetrieval(UifFormBase form) {
        form.setCollectionPagingRequest(true);
        form.setRequestJsonTemplate("components/element/dataTablesJson.ftl");
        return this.getModelAndViewService().getModelAndView(form);
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    public static class CollectionActionParameters {
        private final Map<String, String[]> parameters;
        private final String selectedCollectionPath;
        private final String selectedCollectionId;
        private final int selectedLineIndex;

        public CollectionActionParameters(UifFormBase form, boolean requireIndexParam) {
            this.selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
            if (StringUtils.isBlank((String)this.selectedCollectionPath)) {
                throw new RuntimeException("Selected collection path was not set for collection action");
            }
            this.selectedCollectionId = form.getActionParamaterValue("selectedCollectionId");
            String selectedLine = form.getActionParamaterValue("selectedLineIndex");
            this.selectedLineIndex = StringUtils.isNotBlank((String)selectedLine) ? Integer.parseInt(selectedLine) : -1;
            if (requireIndexParam && this.selectedLineIndex == -1) {
                throw new RuntimeException("Selected line index was not set for collection action");
            }
            HttpServletRequest formRequest = form.getRequest();
            this.parameters = formRequest.getParameterMap();
        }

        public Map<String, String[]> getParameters() {
            return this.parameters;
        }

        public String getSelectedCollectionPath() {
            return this.selectedCollectionPath;
        }

        public String getSelectedCollectionId() {
            return this.selectedCollectionId;
        }

        public int getSelectedLineIndex() {
            return this.selectedLineIndex;
        }
    }
}

