/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.impl.coi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.AbstractProjectRetrievalService;
import org.kuali.coeus.coi.framework.PersonType;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.coi.framework.ProjectTypeCode;
import org.springframework.stereotype.Component;

@Component(value="awardProjectRetrievalService")
public class AwardProjectRetrievalServiceImpl
extends AbstractProjectRetrievalService {
    private static final String AWARD_ALL_HIGHEST_SEQUENCE_QUERY = "SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER";
    private static final String AWARD_AMOUNT_INFO_LOWEST_SEQUENCE_QUERY = "SELECT FINAL_EXPIRATION_DATE, MIN(SEQUENCE_NUMBER) minseq, AWARD_NUMBER FROM AWARD_AMOUNT_INFO GROUP BY AWARD_NUMBER, FINAL_EXPIRATION_DATE";
    private static final String AWARD_ALL_PROJECT_QUERY = "SELECT t.TITLE, t.AWARD_ID, t.STATUS_CODE, t.AWARD_EFFECTIVE_DATE, t.SPONSOR_CODE, u.SPONSOR_NAME, t.AWARD_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.SPONSOR_AWARD_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, aai.FINAL_EXPIRATION_DATE FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN (SELECT FINAL_EXPIRATION_DATE, MIN(SEQUENCE_NUMBER) minseq, AWARD_NUMBER FROM AWARD_AMOUNT_INFO GROUP BY AWARD_NUMBER, FINAL_EXPIRATION_DATE) aai ON aai.AWARD_NUMBER = x.AWARD_NUMBER";
    private static final String AWARD_ALL_PROJECT_PERSON_QUERY = "SELECT t.AWARD_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.AWARD_NUMBER, t.SEQUENCE_NUMBER FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD_PERSONS t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq";
    private static final String AWARD_PROJECT_QUERY = "SELECT t.TITLE, t.AWARD_ID, t.STATUS_CODE, t.AWARD_EFFECTIVE_DATE, t.SPONSOR_CODE, u.SPONSOR_NAME, t.AWARD_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.SPONSOR_AWARD_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, aai.FINAL_EXPIRATION_DATE FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN (SELECT FINAL_EXPIRATION_DATE, MIN(SEQUENCE_NUMBER) minseq, AWARD_NUMBER FROM AWARD_AMOUNT_INFO GROUP BY AWARD_NUMBER, FINAL_EXPIRATION_DATE) aai ON aai.AWARD_NUMBER = x.AWARD_NUMBER WHERE t.AWARD_NUMBER = ?";
    private static final String AWARD_PROJECT_PERSON_QUERY = "SELECT t.AWARD_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.AWARD_NUMBER, t.SEQUENCE_NUMBER FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD_PERSONS t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq WHERE t.AWARD_NUMBER = ?";

    @Override
    protected Project toProject(ResultSet rs) throws SQLException {
        Project project = new Project();
        project.setTitle(rs.getString(1));
        project.setTypeCode(ProjectTypeCode.AWARD.getId());
        project.setSourceSystem("KC-AWARD");
        String sourceIdentifier = rs.getString(7);
        project.setSponsorTypeCode(rs.getString(12));
        project.setSponsorTypeDescription(rs.getString(13));
        project.setSourceIdentifier(sourceIdentifier);
        project.setSourceStatus(rs.getString(3));
        project.setStartDate(rs.getDate(4));
        project.setEndDate(rs.getDate(16));
        project.setPrimeSponsorCode(rs.getString(9));
        project.setPrimeSponsorName(rs.getString(10));
        project.setPrimeSponsorTypeCode(rs.getString(14));
        project.setPrimeSponsorTypeDescription(rs.getString(15));
        project.setShortUrl(this.getBaseShortUrl() + "/kc-common/awards/" + sourceIdentifier);
        project.setSponsorProjectId(rs.getString(11));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(2));
        project.setMetadata(metadata);
        this.setSponsorFields(Collections.singletonList(new ProjectSponsor("KC-AWARD", sourceIdentifier, rs.getString(5), rs.getString(6), new HashMap<String, String>(metadata), rs.getString(12), rs.getString(13))), project);
        if (this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Linked_Project_Push_Enabled").booleanValue()) {
            project.setLinkedProjects(this.getLinkedProjects(this.getMedusaService().getMedusaByAward("award", rs.getLong(2)).get(0)));
        }
        return project;
    }

    @Override
    protected ProjectPerson toProjectPerson(ResultSet rs) throws SQLException {
        ProjectPerson person = new ProjectPerson();
        person.setSourceSystem("KC-AWARD");
        person.setSourceIdentifier(rs.getString(5));
        String personId = rs.getString(2);
        String rolodexId = rs.getString(3);
        person.setPersonId(StringUtils.isNotBlank((CharSequence)personId) ? personId : rolodexId);
        person.setSourcePersonType(StringUtils.isNotBlank((CharSequence)personId) ? PersonType.EMPLOYEE.toString() : PersonType.NONEMPLOYEE.toString());
        person.setRoleCode(rs.getString(4));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(1));
        person.setMetadata(metadata);
        return person;
    }

    @Override
    protected String allProjectQuery() {
        return AWARD_ALL_PROJECT_QUERY;
    }

    @Override
    protected String allProjectPersonQuery() {
        return AWARD_ALL_PROJECT_PERSON_QUERY;
    }

    @Override
    protected String projectQuery() {
        return AWARD_PROJECT_QUERY;
    }

    @Override
    protected String projectPersonQuery() {
        return AWARD_PROJECT_PERSON_QUERY;
    }
}

