/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBaseStream;
import org.kuali.kra.printing.schema.AmountInfoType;
import org.kuali.kra.printing.schema.AwardHeaderType;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardTransactionType;
import org.kuali.kra.printing.schema.AwardType;
import org.kuali.kra.printing.schema.MoneyHistoryReportType;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;

public class MoneyAndEndDatesHistoryXmlStream
extends AwardBaseStream {
    @Override
    public Map<String, AwardNoticeDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, AwardNoticeDocument> xmlObjectList = new LinkedHashMap<String, AwardNoticeDocument>();
        AwardNoticeDocument awardNoticeDocument = AwardNoticeDocument.Factory.newInstance();
        this.initialize((Award)printableBusinessObject);
        awardNoticeDocument.setAwardNotice(this.getAwardNotice(reportParameters));
        xmlObjectList.put(AwardPrintType.MONEY_AND_END_DATES_HISTORY.getAwardPrintType(), awardNoticeDocument);
        return xmlObjectList;
    }

    private void initialize(Award award) {
        this.awardDocument = award.getAwardDocument();
        List<AwardAmountInfo> awardAmountInfos = award.getAwardAmountInfos();
        if (awardAmountInfos != null && !awardAmountInfos.isEmpty()) {
            this.awardAmountInfo = awardAmountInfos.get(0);
        }
    }

    @Override
    protected AwardNoticeDocument.AwardNotice getAwardNotice(Map<String, Object> reportParameters) {
        AwardNoticeDocument.AwardNotice awardNotice = AwardNoticeDocument.AwardNotice.Factory.newInstance();
        awardNotice.setSchoolInfo(this.getSchoolInfoType());
        awardNotice.setAward(this.getAward());
        awardNotice.setMoneyHistoryReportArray(this.getMoneyHistoryReports());
        awardNotice.setPrintRequirement(this.getPrintRequirement(reportParameters));
        return awardNotice;
    }

    private MoneyHistoryReportType[] getMoneyHistoryReports() {
        ArrayList<MoneyHistoryReportType> moneyHistoryReportTypes = new ArrayList<MoneyHistoryReportType>();
        ArrayList<AwardTransactionType> awardTransactionTypes = new ArrayList<AwardTransactionType>();
        ArrayList<AmountInfoType> amountInfoTypes = new ArrayList<AmountInfoType>();
        MoneyHistoryReportType moneyHistoryReportType = MoneyHistoryReportType.Factory.newInstance();
        int rowNo = 1;
        int seqNo = 0;
        for (AwardAmountInfo awardAmountInfo : this.awardDocument.getAward().getAwardAmountInfos()) {
            if (seqNo != awardAmountInfo.getSequenceNumber()) {
                this.setMoneyHistoryInfos(amountInfoTypes, awardAmountInfo, rowNo);
                this.setMoneyHistoryTransactionInfos(awardTransactionTypes, awardAmountInfo, rowNo);
                moneyHistoryReportType.setMoneyHistorySeq(awardAmountInfo.getSequenceNumber());
                seqNo = awardAmountInfo.getSequenceNumber();
                continue;
            }
            this.setMoneyHistoryInfos(amountInfoTypes, awardAmountInfo, rowNo++);
            this.setMoneyHistoryTransactionInfos(awardTransactionTypes, awardAmountInfo, rowNo++);
        }
        moneyHistoryReportType.setMoneyHistoryInfoArray(amountInfoTypes.toArray(new AmountInfoType[0]));
        moneyHistoryReportType.setMoneyHistoryTransactionInfoArray(awardTransactionTypes.toArray(new AwardTransactionType[0]));
        moneyHistoryReportTypes.add(moneyHistoryReportType);
        return moneyHistoryReportTypes.toArray(new MoneyHistoryReportType[0]);
    }

    private void setMoneyHistoryTransactionInfos(List<AwardTransactionType> awardTransactionTypes, AwardAmountInfo awardAmountInfo, int rowNo) {
        AwardAmountTransaction awardAmountTransaction = this.getAwardAmountTransaction(awardAmountInfo.getTimeAndMoneyDocumentNumber());
        if (awardAmountTransaction != null) {
            AwardTransactionType awardTransactionType = AwardTransactionType.Factory.newInstance();
            awardTransactionType.setAwardNumber(this.awardDocument.getAward().getAwardNumber());
            awardTransactionType.setTransactionTypeCode(awardAmountTransaction.getTransactionTypeCode());
            awardTransactionType.setComments(awardAmountTransaction.getComments());
            if (awardAmountTransaction.getNoticeDate() != null) {
                awardTransactionType.setNoticeDate(this.dateTimeService.getCalendar((Date)awardAmountTransaction.getNoticeDate()));
            }
            awardTransactionType.setTreeLevel(rowNo);
            awardTransactionTypes.add(awardTransactionType);
        }
    }

    private void setMoneyHistoryInfos(List<AmountInfoType> amountInfoTypes, AwardAmountInfo awardAmountInfo, int rowNo) {
        AmountInfoType amountInfoType = AmountInfoType.Factory.newInstance();
        if (awardAmountInfo.getObligatedChange() != null) {
            amountInfoType.setObligatedChange(awardAmountInfo.getObligatedChange().bigDecimalValue());
        }
        if (awardAmountInfo.getAnticipatedChange() != null) {
            amountInfoType.setAnticipatedChange(awardAmountInfo.getAnticipatedChange().bigDecimalValue());
        }
        if (awardAmountInfo.getAmountObligatedToDate() != null) {
            amountInfoType.setAmtObligatedToDate(awardAmountInfo.getAmountObligatedToDate().bigDecimalValue());
        }
        if (awardAmountInfo.getObliDistributableAmount() != null) {
            amountInfoType.setObligatedDistributableAmt(awardAmountInfo.getObliDistributableAmount().bigDecimalValue());
        }
        if (awardAmountInfo.getAnticipatedTotalAmount() != null) {
            amountInfoType.setAnticipatedTotalAmt(awardAmountInfo.getAnticipatedTotalAmount().bigDecimalValue());
        }
        if (awardAmountInfo.getAntDistributableAmount() != null) {
            amountInfoType.setAnticipatedDistributableAmt(awardAmountInfo.getAntDistributableAmount().bigDecimalValue());
        }
        if (awardAmountInfo.getObligationExpirationDate() != null) {
            amountInfoType.setObligationExpirationDate(this.dateTimeService.getCalendar((Date)awardAmountInfo.getObligationExpirationDate()));
        }
        if (awardAmountInfo.getCurrentFundEffectiveDate() != null) {
            amountInfoType.setCurrentFundEffectiveDate(this.dateTimeService.getCalendar((Date)awardAmountInfo.getCurrentFundEffectiveDate()));
        }
        if (awardAmountInfo.getFinalExpirationDate() != null) {
            amountInfoType.setFinalExpirationDate(this.dateTimeService.getCalendar((Date)awardAmountInfo.getFinalExpirationDate()));
        }
        if (awardAmountInfo.getObligatedChangeDirect() != null) {
            amountInfoType.setObligatedChangeDirect(awardAmountInfo.getObligatedChangeDirect().bigDecimalValue());
        }
        if (awardAmountInfo.getObligatedChangeIndirect() != null) {
            amountInfoType.setObligatedChangeIndirect(awardAmountInfo.getObligatedChangeIndirect().bigDecimalValue());
        }
        if (awardAmountInfo.getAnticipatedChangeDirect() != null) {
            amountInfoType.setAnticipatedChangeDirect(awardAmountInfo.getAnticipatedChangeDirect().bigDecimalValue());
        }
        if (awardAmountInfo.getAnticipatedChangeIndirect() != null) {
            amountInfoType.setAnticipatedChangeIndirect(awardAmountInfo.getAnticipatedChangeIndirect().bigDecimalValue());
        }
        String enableAwdAntOblDirectIndirectCost = this.getAwardParameterValue("ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        amountInfoType.setEnableAwdAntOblDirectIndirectCost(enableAwdAntOblDirectIndirectCost);
        amountInfoType.setTreeLevel(rowNo);
        amountInfoTypes.add(amountInfoType);
    }

    private AwardAmountTransaction getAwardAmountTransaction(String timeAndMoneyDocNumber) {
        TimeAndMoneyDocument timeAndMoneyDocument;
        List<AwardAmountTransaction> awardAmountTransactionList;
        AwardAmountTransaction awardAmountTransaction = null;
        HashMap<String, String> timeAndMoneyMap = new HashMap<String, String>();
        timeAndMoneyMap.put("documentNumber", timeAndMoneyDocNumber);
        List timeAndMoneyDocs = (List)this.businessObjectService.findMatching(TimeAndMoneyDocument.class, timeAndMoneyMap);
        if (timeAndMoneyDocs != null && !timeAndMoneyDocs.isEmpty() && (awardAmountTransactionList = (timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyDocs.get(0)).getAwardAmountTransactions()) != null && !awardAmountTransactionList.isEmpty()) {
            awardAmountTransaction = awardAmountTransactionList.get(0);
        }
        return awardAmountTransaction;
    }

    @Override
    protected AwardNoticeDocument.AwardNotice.PrintRequirement getPrintRequirement(Map<String, Object> reportParameters) {
        AwardNoticeDocument.AwardNotice.PrintRequirement printRequirement = AwardNoticeDocument.AwardNotice.PrintRequirement.Factory.newInstance();
        if (reportParameters != null) {
            printRequirement.setCurrentDate(this.dateTimeService.getCurrentCalendar());
        }
        return printRequirement;
    }

    @Override
    protected AwardType getAward() {
        AwardType awardType = AwardType.Factory.newInstance();
        awardType.setAwardDetails(this.getAwardDetails());
        return awardType;
    }

    @Override
    protected AwardType.AwardDetails getAwardDetails() {
        AwardType.AwardDetails awardDetailsType = AwardType.AwardDetails.Factory.newInstance();
        AwardHeaderType awardHeaderType = this.getAwardHeaderType();
        awardDetailsType.setAwardHeader(awardHeaderType);
        return awardDetailsType;
    }

    @Override
    protected AwardHeaderType getAwardHeaderType() {
        AwardHeaderType awardHeaderType = AwardHeaderType.Factory.newInstance();
        if (this.awardDocument.getAward().getAwardNumber() != null) {
            awardHeaderType.setAwardNumber(this.awardDocument.getAward().getAwardNumber());
        }
        return awardHeaderType;
    }
}

