/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class InstitutionalProposalPerson
extends InstitutionalProposalContact
implements PersonRolodex,
AbstractPersonRoleAware {
    private static final long serialVersionUID = -5406431014745059361L;
    private ScaleTwoDecimal academicYearEffort;
    private ScaleTwoDecimal calendarYearEffort;
    private boolean faculty;
    private ScaleTwoDecimal summerEffort;
    private ScaleTwoDecimal totalEffort;
    private String keyPersonRole;
    private List<InstitutionalProposalPersonUnit> units;
    private transient ParameterService parameterService;
    private List<InstitutionalProposalPersonCreditSplit> creditSplits;
    private Boolean includeInCreditAllocation;
    private transient PropAwardPersonRoleService propAwardPersonRoleService;

    public InstitutionalProposalPerson() {
        this.init();
    }

    public InstitutionalProposalPerson(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        super(rolodex, contactRole);
        this.init();
    }

    public InstitutionalProposalPerson(KcPerson person, ContactRole role) {
        super(person, role);
        this.init();
    }

    public void setIncludeInCreditAllocation(Boolean includeInCreditAllocation) {
        this.includeInCreditAllocation = includeInCreditAllocation;
    }

    public void add(InstitutionalProposalPersonCreditSplit creditSplit) {
        this.creditSplits.add(creditSplit);
        creditSplit.setInstitutionalProposalPerson(this);
    }

    public void add(InstitutionalProposalPersonUnit institutionalProposalPersonUnit) {
        this.units.add(institutionalProposalPersonUnit);
        institutionalProposalPersonUnit.setInstitutionalProposalPerson(this);
    }

    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getUnits());
        return managedLists;
    }

    public ScaleTwoDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public ScaleTwoDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public InstitutionalProposalPersonCreditSplit getCreditSplit(int index) {
        return this.creditSplits.get(index);
    }

    public List<InstitutionalProposalPersonCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public ScaleTwoDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public ScaleTwoDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public InstitutionalProposalPersonUnit getUnit(int index) {
        return this.units.get(index);
    }

    public List<InstitutionalProposalPersonUnit> getUnits() {
        return this.units;
    }

    public InstitutionalProposalPersonUnit getUnit(String unitNumber) {
        InstitutionalProposalPersonUnit ippu = null;
        for (InstitutionalProposalPersonUnit unit : this.units) {
            if (!unit.getUnitNumber().equalsIgnoreCase(unitNumber)) continue;
            ippu = unit;
        }
        return ippu;
    }

    public boolean isCoInvestigator() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"COI");
    }

    public boolean isFaculty() {
        return this.faculty;
    }

    public boolean isKeyPerson() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"KP");
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"PI");
    }

    @Override
    public boolean isMultiplePi() {
        return StringUtils.equals((CharSequence)this.getContactRoleCode(), (CharSequence)"MPI");
    }

    public void setAcademicYearEffort(ScaleTwoDecimal academicYearEffort) {
        this.academicYearEffort = academicYearEffort;
    }

    public void setCalendarYearEffort(ScaleTwoDecimal calendarYearEffort) {
        this.calendarYearEffort = calendarYearEffort;
    }

    public void setCreditSplits(List<InstitutionalProposalPersonCreditSplit> creditSplits) {
        this.creditSplits = creditSplits;
    }

    public void initializeDefaultCreditSplits() {
        List creditTypes = (List)this.getBusinessObjectService().findAll(InvestigatorCreditType.class);
        for (InvestigatorCreditType creditType : creditTypes) {
            InstitutionalProposalPersonCreditSplit creditSplit = new InstitutionalProposalPersonCreditSplit(creditType, ScaleTwoDecimal.ZERO);
            this.add(creditSplit);
        }
    }

    public void setFaculty(boolean faculty) {
        this.faculty = faculty;
    }

    public void setSummerEffort(ScaleTwoDecimal summerEffort) {
        this.summerEffort = summerEffort;
    }

    public void setTotalEffort(ScaleTwoDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public void setUnits(List<InstitutionalProposalPersonUnit> units) {
        this.units = units;
    }

    @Override
    public String toString() {
        StringBuilder id = new StringBuilder();
        if (this.getContact() != null && this.getContact().getIdentifier() != null) {
            id.append(this.getContact().getIdentifier().toString());
        }
        StringBuilder name = new StringBuilder();
        if (this.getContact() != null && this.getContact().getFullName() != null) {
            name.append(this.getContact().getFullName());
        }
        return String.format("%s:%s", id.toString(), name.toString());
    }

    protected Class<PropAwardPersonRole> getContactRoleType() {
        return PropAwardPersonRole.class;
    }

    @Override
    protected Map<String, Object> getContactRoleIdentifierMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", this.getRoleCode());
        map.put("sponsorHierarchyName", this.getPropAwardPersonRoleService().getSponsorHierarchy(this.getInstitutionalProposal().getSponsorCode()));
        return map;
    }

    protected void init() {
        this.units = new ArrayList<InstitutionalProposalPersonUnit>();
        this.creditSplits = new ArrayList<InstitutionalProposalPersonCreditSplit>();
    }

    @Override
    public String getProjectRole() {
        return this.getContactRole().getRoleDescription();
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return false;
    }

    public String getKeyPersonRole() {
        return this.keyPersonRole;
    }

    public void setKeyPersonRole(String keyPersonRole) {
        this.keyPersonRole = keyPersonRole;
    }

    @Override
    public void resetPersistenceState() {
        this.setInstitutionalProposalContactId(null);
    }

    @Override
    public InstitutionalProposal getParent() {
        return this.getInstitutionalProposal();
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return this.getContactRole().getRoleDescription();
    }

    @Override
    public ContactRole refreshContactRole() {
        this.contactRole = StringUtils.isNotBlank((CharSequence)this.getRoleCode()) && this.getParent() != null && StringUtils.isNotBlank((CharSequence)this.getParent().getSponsorCode()) ? this.getPropAwardPersonRoleService().getRole(this.getRoleCode(), this.getParent().getSponsorCode()) : null;
        return this.contactRole;
    }

    @Override
    protected PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    @Override
    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }

    @Override
    public Integer getOrdinalPosition() {
        return 0;
    }

    @Override
    public boolean isInvestigator() {
        return this.isPrincipalInvestigator() || this.isMultiplePi() || this.isCoInvestigator();
    }

    @Override
    public String getLastName() {
        String lastName = null;
        if (this.getPerson() != null) {
            lastName = this.getPerson().getLastName();
        } else if (this.getRolodex() != null) {
            lastName = this.getRolodex().getLastName();
        }
        return lastName;
    }

    public Boolean getIncludeInCreditAllocation() {
        if (this.includeInCreditAllocation == null) {
            this.includeInCreditAllocation = this.defaultIncludeInCreditAllocation(this.roleCode);
        }
        return this.includeInCreditAllocation;
    }

    public Boolean defaultIncludeInCreditAllocation(String proposalPersonRoleId) {
        Collection roles = this.getParameterService().getParameterValuesAsString("KC-PD", "All", "CREDIT_SPLIT_OPT_IN_DEFAULT_ROLES");
        return StringUtils.isNotBlank((CharSequence)proposalPersonRoleId) && roles.contains(proposalPersonRoleId);
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

