/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.reporting.printing.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAttachments;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardPrintAgreement;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF294Print;
import org.kuali.kra.subaward.reporting.printing.print.SubAwardSF295Print;
import org.kuali.kra.subaward.reporting.printing.service.SubAwardPrintingService;
import org.kuali.kra.subawardReporting.printing.print.SubAwardFDPAgreement;
import org.kuali.kra.subawardReporting.printing.print.SubAwardFDPModification;
import org.kuali.kra.subawardReporting.printing.print.SubawardFdp;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubAwardPrintingServiceImpl
implements SubAwardPrintingService {
    private static final String SF_295_REPORT = "SF295";
    private static final String SF_294_REPORT = "SF294";
    private static final String SUB_AWARD_FDP_TEMPLATE = "fdpAgreement";
    private static final String SUB_AWARD_FDP_MODIFICATION = "fdpModification";
    private static final String FDP_FROM_PARENT_AWARD = "FDP_FROM_PARENT_AWARD";
    private SubAwardSF294Print subAwardSF294Print;
    private SubAwardSF295Print subAwardSF295Print;
    private PrintingService printingService;
    private SubAwardFDPModification subAwardFDPModification;
    private SubAwardFDPAgreement subAwardFDPAgreement;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private AwardVersionService awardVersionService;
    private AwardHierarchyService awardHierarchyService;

    public SubAwardFDPModification getSubAwardFDPModification() {
        return this.subAwardFDPModification;
    }

    public void setSubAwardFDPModification(SubAwardFDPModification subAwardFDPModification) {
        this.subAwardFDPModification = subAwardFDPModification;
    }

    public SubAwardFDPAgreement getSubAwardFDPAgreement() {
        return this.subAwardFDPAgreement;
    }

    public void setSubAwardFDPAgreement(SubAwardFDPAgreement subAwardFDPAgreement) {
        this.subAwardFDPAgreement = subAwardFDPAgreement;
    }

    @Override
    public AttachmentDataSource printSubAwardReport(KcPersistableBusinessObjectBase awardDocument, SubAwardPrintType subAwardPrintType, Map<String, Object> reportParameters) throws PrintingException {
        AbstractPrint printable = null;
        if (reportParameters.get("printType") != null) {
            printable = reportParameters.get("printType").equals(SF_295_REPORT) ? this.getSubAwardSF295Print() : this.getSubAwardSF294Print();
        }
        printable.setPrintableBusinessObject(awardDocument);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.getPrintingService().print(printable);
        source.setType("application/pdf");
        if (reportParameters.get("printType").equals(SF_295_REPORT)) {
            source.setName("SF295.pdf");
        } else {
            source.setName("SF294.pdf");
        }
        return source;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public SubAwardSF294Print getSubAwardSF294Print() {
        return this.subAwardSF294Print;
    }

    public void setSubAwardSF294Print(SubAwardSF294Print subAwardSF294Print) {
        this.subAwardSF294Print = subAwardSF294Print;
    }

    public SubAwardSF295Print getSubAwardSF295Print() {
        return this.subAwardSF295Print;
    }

    public void setSubAwardSF295Print(SubAwardSF295Print subAwardSF295Print) {
        this.subAwardSF295Print = subAwardSF295Print;
    }

    protected AttachmentDataSource printSubAwardFDPReport(KcPersistableBusinessObjectBase subAwardDoc, Map<String, Object> reportParameters) throws PrintingException {
        SubawardFdp printable = null;
        if (reportParameters.get("fdpType") != null) {
            printable = reportParameters.get("fdpType").equals(SUB_AWARD_FDP_TEMPLATE) ? this.getSubAwardFDPAgreement() : this.getSubAwardFDPModification();
        }
        SubAward subAward = (SubAward)subAwardDoc;
        Map formAttachments = subAward.getSubAwardAttachmentsForPrint().stream().filter(SubAwardAttachments::getSelectToPrint).map(attach -> CollectionUtils.entry(attach.getAttachmentId().toString(), attach.getAttachmentContent())).collect(CollectionUtils.entriesToMap(LinkedHashMap::new));
        this.resetSelectedFormList(subAward.getSubAwardAttachments());
        printable.setAttachments(formAttachments);
        printable.setPrintableBusinessObject(subAwardDoc);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.getPrintingService().print(printable);
        source.setType("application/pdf");
        if (reportParameters.get("fdpType").equals(SUB_AWARD_FDP_TEMPLATE)) {
            source.setName("fdpAgreement.pdf");
        } else {
            source.setName("fdpModification.pdf");
        }
        return source;
    }

    @Override
    public AttachmentDataSource printSubAwardFDPReport(SubAwardPrintAgreement agreement, SubAward subAward) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        List<SubAwardForms> printFormTemplates = this.getSponsorFormTemplates(agreement, subAward.getSubAwardForms());
        if (agreement.getFundingSource() != null) {
            for (SubAwardFundingSource subAwardFunding : subAward.getSubAwardFundingSourceList()) {
                if (!agreement.getFundingSource().equals(subAwardFunding.getSubAwardFundingSourceId().toString())) continue;
                Award workingAward = this.getAwardVersionService().getWorkingAwardVersion(subAwardFunding.getAward().getAwardNumber());
                Award award = workingAward != null ? workingAward : subAwardFunding.getAward();
                reportParameters.put("awardNumber", award.getAwardNumber());
                reportParameters.put("awardTitle", award.getParentTitle());
                reportParameters.put("sponsorAwardNumber", award.getSponsorAwardNumber());
                if (award.getSponsor() != null) {
                    reportParameters.put("sponsorName", award.getSponsor().getSponsorName());
                }
                reportParameters.put("cfdaNumber", award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).collect(Collectors.joining(",")));
                reportParameters.put("awardID", award.getAwardId());
                if (this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", FDP_FROM_PARENT_AWARD).booleanValue()) {
                    AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(subAwardFunding.getAward().getAwardNumber());
                    if (hierarchy != null) {
                        reportParameters.put("fain", hierarchy.getRoot().getAward().getFainId());
                        if (hierarchy.getRoot().getAward().getObligatedTotal() != null) {
                            reportParameters.put("obligatedTotal", hierarchy.getRoot().getAward().getObligatedTotal().bigDecimalValue());
                        }
                        if (hierarchy.getRoot().getAward().getAnticipatedTotal() != null) {
                            reportParameters.put("anticipatedTotal", hierarchy.getRoot().getAward().getAnticipatedTotal().bigDecimalValue());
                        }
                    }
                } else {
                    reportParameters.put("fain", award.getFainId());
                    if (award.getObligatedTotal() != null) {
                        reportParameters.put("obligatedTotal", award.getObligatedTotal().bigDecimalValue());
                    }
                    if (award.getAnticipatedTotal() != null) {
                        reportParameters.put("anticipatedTotal", award.getAnticipatedTotal().bigDecimalValue());
                    }
                }
                if (award.getPrimeSponsor() != null) {
                    reportParameters.put("primeSponsorName", award.getPrimeSponsor().getSponsorName());
                } else {
                    reportParameters.put("primeSponsorName", award.getSponsor().getSponsorName());
                }
                if (award.getNoticeDate() != null) {
                    Calendar noticeDate = Calendar.getInstance();
                    noticeDate.setTime(award.getNoticeDate());
                    reportParameters.put("noticeDate", noticeDate);
                }
                if (award.getFedAwardDate() == null) break;
                Calendar fedAwardDate = Calendar.getInstance();
                fedAwardDate.setTime(award.getFedAwardDate());
                reportParameters.put("fedAwardDate", fedAwardDate);
                break;
            }
        }
        if (!subAward.getSubAwardAmountInfoList().isEmpty()) {
            int index = subAward.getSubAwardAmountInfoList().size() - 1;
            String modificationTypeCode = subAward.getSubAwardAmountInfoList().get(index).getModificationTypeCode();
            if (StringUtils.isNotEmpty((CharSequence)modificationTypeCode)) {
                reportParameters.put("modificationType", modificationTypeCode);
            }
        }
        if (!subAward.getSubAwardTemplateInfo().isEmpty()) {
            reportParameters.put("fcoi", subAward.getSubAwardTemplateInfo().get(0).getFcio());
            reportParameters.put("invoicesEmailed", subAward.getSubAwardTemplateInfo().get(0).getInvoicesEmailed());
            reportParameters.put("invoiceAddressDifferent", subAward.getSubAwardTemplateInfo().get(0).getInvoiceAddressDifferent());
            reportParameters.put("invoiceEmailDifferent", subAward.getSubAwardTemplateInfo().get(0).getInvoiceEmailDifferent());
        }
        reportParameters.put("ffata", subAward.getFfataRequired());
        reportParameters.put("Selected Templates", printFormTemplates);
        reportParameters.put("fdpType", agreement.getFdpType());
        return this.printSubAwardFDPReport(subAward, reportParameters);
    }

    protected void resetsubAwardFormList(List<SubAwardForms> subAwardFormList) {
        for (SubAwardForms subAwardFormValues : subAwardFormList) {
            subAwardFormValues.setSelectToPrint(false);
        }
    }

    public boolean isCostSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_DC_IDC");
    }

    protected List<SubAwardForms> getSponsorFormTemplates(SubAwardPrintAgreement subAwardPrint, List<SubAwardForms> subAwardFormList) {
        ArrayList<SubAwardForms> printFormTemplates = new ArrayList<SubAwardForms>();
        if (subAwardPrint.getFdpType().equals(SUB_AWARD_FDP_TEMPLATE)) {
            printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP Template"));
        } else if (subAwardPrint.getFdpType().equals(SUB_AWARD_FDP_MODIFICATION)) {
            if (this.isCostSplitEnabled()) {
                printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP Modification Unilateral"));
            } else {
                printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP Modification"));
            }
        }
        if (subAwardPrint.getAttachment3A().booleanValue()) {
            printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP_ATT_3A"));
        }
        if (subAwardPrint.getAttachment3B().booleanValue()) {
            printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP_ATT_3B"));
        }
        if (subAwardPrint.getAttachment3BPage2().booleanValue()) {
            printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP_ATT_3B_2"));
        }
        if (subAwardPrint.getAttachment4().booleanValue()) {
            printFormTemplates.add((SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)"FDP_ATT_4"));
        }
        if (subAwardFormList != null) {
            for (SubAwardForms subAwardFormValues : subAwardFormList) {
                if (!subAwardFormValues.getSelectToPrint().booleanValue()) continue;
                String description = subAwardFormValues.getDescription();
                String[] token = description.split("\\s");
                SubAwardForms forms = (SubAwardForms)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardForms.class, (Object)("FDP_" + token[0]));
                if (forms == null) continue;
                printFormTemplates.add(forms);
            }
            this.resetsubAwardFormList(subAwardFormList);
        }
        return printFormTemplates;
    }

    protected void resetSelectedFormList(List<SubAwardAttachments> subAwardFormList) {
        for (SubAwardAttachments subAwardFormValues : subAwardFormList) {
            subAwardFormValues.setSelectToPrint(false);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardVersionService getAwardVersionService() {
        return this.awardVersionService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }
}

