/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.ClassHelper;

public class ClobWrapper {
    protected Object m_clob;
    protected static Field durationSession;
    protected static Field durationCall;
    protected static Field modeReadOnly;
    protected static Field modeReadWrite;
    protected static Method createTemporary;
    protected static Method freeTemporary;
    protected static Method open;
    protected static Method isOpen;
    protected static Method getCharacterStream;
    protected static Method getCharacterOutputStream;
    protected static Method getBufferSize;
    protected static Method close;
    protected static Method trim;

    public Object getClob() {
        return this.m_clob;
    }

    public void setClob(Object object) {
        this.m_clob = object;
    }

    protected static int staticIntFieldValue(Field field) {
        int n = 0;
        try {
            n = field.getInt(null);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public static int getDurationSessionValue() {
        return ClobWrapper.staticIntFieldValue(durationSession);
    }

    public static int getDurationCallValue() {
        return ClobWrapper.staticIntFieldValue(durationCall);
    }

    public static int getModeReadOnlyValue() {
        return ClobWrapper.staticIntFieldValue(modeReadOnly);
    }

    public static int getModeReadWriteValue() {
        return ClobWrapper.staticIntFieldValue(modeReadWrite);
    }

    public static ClobWrapper createTemporary(Connection connection, boolean bl, int n) throws Exception {
        ClobWrapper clobWrapper = new ClobWrapper();
        clobWrapper.setClob(createTemporary.invoke(null, connection, BooleanUtils.toBooleanObject((boolean)bl), new Integer(n)));
        return clobWrapper;
    }

    public void open(int n) throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            open.invoke(this.m_clob, new Integer(n));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public boolean isOpen() throws SQLException {
        if (this.m_clob == null) {
            return false;
        }
        boolean bl = false;
        try {
            Boolean bl2 = (Boolean)isOpen.invoke(this.m_clob, null);
            if (bl2 != null) {
                bl = bl2;
            }
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return bl;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.m_clob == null) {
            return null;
        }
        Reader reader = null;
        try {
            reader = (Reader)getCharacterStream.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return reader;
    }

    public Writer getCharacterOutputStream() throws SQLException {
        if (this.m_clob == null) {
            return null;
        }
        Writer writer = null;
        try {
            writer = (Writer)getCharacterOutputStream.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return writer;
    }

    public int getBufferSize() throws SQLException {
        if (this.m_clob == null) {
            return 0;
        }
        Integer n = null;
        try {
            n = (Integer)getBufferSize.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
        return n;
    }

    public void close() throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            close.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void trim(long l) throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            trim.invoke(this.m_clob, new Long(l));
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    public void freeTemporary() throws SQLException {
        if (this.m_clob == null) {
            return;
        }
        try {
            freeTemporary.invoke(this.m_clob, null);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    static {
        try {
            Class clazz = ClassHelper.getClass("oracle.sql.CLOB", false);
            createTemporary = clazz.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            freeTemporary = clazz.getMethod("freeTemporary", null);
            open = clazz.getMethod("open", Integer.TYPE);
            isOpen = clazz.getMethod("isOpen", null);
            getCharacterStream = clazz.getMethod("getCharacterStream", null);
            getCharacterOutputStream = clazz.getMethod("getCharacterOutputStream", null);
            getBufferSize = clazz.getMethod("getBufferSize", null);
            close = clazz.getMethod("close", null);
            trim = clazz.getMethod("trim", Long.TYPE);
            durationSession = ClassHelper.getField(clazz, "DURATION_SESSION");
            durationCall = ClassHelper.getField(clazz, "DURATION_CALL");
            modeReadOnly = ClassHelper.getField(clazz, "MODE_READONLY");
            modeReadWrite = ClassHelper.getField(clazz, "MODE_READWRITE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

