/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.resourceloader;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.messaging.resourceloader.ServiceBusResourceLoader;

public class KSBResourceLoaderFactory {
    private static final String KSB_ROOT_RESOURCE_LOACER_NAME = "KSB_ROOT_RESOURCE_LOADER";
    private static final String KSB_REMOTE_RESOURCE_LOADER_LOCAL_NAME = "KSB_REMOTE_RESOURCE_LOADER";

    private static void initialize() {
        String applicationId = CoreConfigHelper.getApplicationId();
        if (KSBResourceLoaderFactory.getRootResourceLoaderName() == null) {
            KSBResourceLoaderFactory.setRootResourceLoaderName(new QName(applicationId, KSB_ROOT_RESOURCE_LOACER_NAME));
        }
        if (KSBResourceLoaderFactory.getRemoteResourceLoaderName() == null) {
            KSBResourceLoaderFactory.setRemoteResourceLoaderName(new QName(applicationId, KSB_REMOTE_RESOURCE_LOADER_LOCAL_NAME));
        }
    }

    public static ResourceLoader createRootKSBRemoteResourceLoader() {
        KSBResourceLoaderFactory.initialize();
        BaseResourceLoader rootResourceLoader = new BaseResourceLoader(KSBResourceLoaderFactory.getRootResourceLoaderName());
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        if (serviceBus == null) {
            throw new IllegalStateException("Failed to locate the ServiceBus");
        }
        rootResourceLoader.addResourceLoader((ResourceLoader)new ServiceBusResourceLoader(KSBResourceLoaderFactory.getRemoteResourceLoaderName(), serviceBus));
        return rootResourceLoader;
    }

    public static QName getRootResourceLoaderName() {
        return (QName)ConfigContext.getCurrentContextConfig().getObject(KSB_ROOT_RESOURCE_LOACER_NAME);
    }

    public static void setRootResourceLoaderName(QName name) {
        ConfigContext.getCurrentContextConfig().putObject(KSB_ROOT_RESOURCE_LOACER_NAME, (Object)name);
    }

    public static QName getRemoteResourceLoaderName() {
        return (QName)ConfigContext.getCurrentContextConfig().getObject(KSB_REMOTE_RESOURCE_LOADER_LOCAL_NAME);
    }

    public static void setRemoteResourceLoaderName(QName remoteResourceLoaderName) {
        ConfigContext.getCurrentContextConfig().putObject(KSB_REMOTE_RESOURCE_LOADER_LOCAL_NAME, (Object)remoteResourceLoaderName);
    }
}

