/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Element;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.xml.DocumentTypeXmlParser;
import org.kuali.rice.kew.xml.export.DocumentTypeXmlExporter;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Required;

public class DocumentTypeServiceImpl
implements DocumentTypeService {
    private static final Logger LOG = LogManager.getLogger(DocumentTypeServiceImpl.class);
    protected static final String XML_FILE_PARSE_ERROR = "general.error.parsexml";
    private DocumentTypeDAO documentTypeDAO;
    private DataObjectService dataObjectService;

    @Override
    public Collection<DocumentType> find(DocumentType documentType, String docTypeParentName, boolean climbHierarchy) {
        DocumentType docTypeParent = this.findByName(docTypeParentName);
        return this.getDocumentTypeDAO().find(documentType, docTypeParent, climbHierarchy);
    }

    @Override
    public DocumentType findById(String documentTypeId) {
        if (documentTypeId == null) {
            return null;
        }
        return (DocumentType)this.getDataObjectService().find(DocumentType.class, (Object)documentTypeId);
    }

    @Override
    public DocumentType findByDocumentId(String documentId) {
        if (documentId == null) {
            return null;
        }
        return this.documentTypeDAO.findDocumentTypeByDocumentId(documentId);
    }

    @Override
    public DocumentType findByName(String name) {
        return this.findByName(name, true);
    }

    @Override
    public DocumentType findByNameCaseInsensitive(String name) {
        return this.findByName(name, false);
    }

    private DocumentType findByName(String name, boolean caseSensitive) {
        if (name == null) {
            return null;
        }
        return this.documentTypeDAO.findByName(name, caseSensitive);
    }

    @Override
    public DocumentType versionAndSave(DocumentType documentType) {
        if (documentType.getDocumentTypeId() != null && documentType.getVersionNumber() != null) {
            throw new RuntimeException("DocumentType configured for update and not versioning which we support");
        }
        DocumentType oldDocumentType = this.findByName(documentType.getName());
        String existingDocTypeId = null;
        if (oldDocumentType != null) {
            existingDocTypeId = oldDocumentType.getDocumentTypeId();
            Integer maxVersionNumber = this.documentTypeDAO.getMaxVersionNumber(documentType.getName());
            documentType.setVersion(maxVersionNumber != null ? new Integer(maxVersionNumber + 1) : new Integer(0));
            oldDocumentType.setCurrentInd(Boolean.FALSE);
            if (LOG.isInfoEnabled()) {
                LOG.info("Saving old document type Id " + oldDocumentType.getDocumentTypeId() + " name '" + oldDocumentType.getName() + "' (current = " + oldDocumentType.getCurrentInd() + ")");
            }
            oldDocumentType = this.save(oldDocumentType);
        }
        if (!CollectionUtils.isEmpty((Collection)this.documentTypeDAO.findAllCurrentByName(documentType.getName()))) {
            String errorMsg = "Found invalid 'current' document with name '" + documentType.getName() + "'.  None should exist.";
            LOG.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        documentType.setPreviousVersionId(existingDocTypeId);
        documentType.setCurrentInd(Boolean.TRUE);
        documentType = this.save(documentType);
        if (LOG.isInfoEnabled()) {
            LOG.info("Saved current document type Id " + documentType.getDocumentTypeId() + " name '" + documentType.getName() + "' (current = " + documentType.getCurrentInd() + ")");
        }
        if (existingDocTypeId != null) {
            for (DocumentType child : this.getChildDocumentTypes(existingDocTypeId)) {
                child.setDocTypeParentId(documentType.getDocumentTypeId());
                this.save(child);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Saved child document type Id " + child.getDocumentTypeId() + " name '" + child.getName() + "' (parent = " + child.getDocTypeParentId() + ", current = " + child.getCurrentInd() + ")");
            }
        }
        if (documentType.getDocTypeParentId() != null) {
            DocumentType parent = (DocumentType)this.getDataObjectService().find(DocumentType.class, (Object)documentType.getDocTypeParentId());
            this.save(parent);
            if (LOG.isInfoEnabled()) {
                LOG.info("Saved parent document type Id " + parent.getDocumentTypeId() + " name '" + parent.getName() + "' (current = " + parent.getCurrentInd() + ")");
            }
        }
        return documentType;
    }

    @Override
    public DocumentType save(DocumentType documentType) {
        if (documentType.getParentId() != null) {
            this.getDocumentTypeDAO().incrementOptimisticLock(documentType.getParentId());
        }
        return (DocumentType)this.getDataObjectService().save((Object)documentType, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    public DocumentTypeDAO getDocumentTypeDAO() {
        return this.documentTypeDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public synchronized List findAllCurrentRootDocuments() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.isNull((String)"docTypeParentId"), PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    public List findAllCurrent() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"currentInd", (Object)Boolean.TRUE)});
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    @Override
    public List<DocumentType> findPreviousInstances(String documentTypeName) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)documentTypeName), PredicateFactory.equal((String)"currentInd", (Object)Boolean.FALSE)});
        QueryResults results = this.getDataObjectService().findMatching(DocumentType.class, builder.build());
        return results.getResults();
    }

    @Override
    public DocumentType findRootDocumentType(DocumentType docType) {
        if (docType.getParentDocType() != null) {
            return this.findRootDocumentType(docType.getParentDocType());
        }
        return docType;
    }

    public void loadXml(InputStream inputStream, String principalId) {
        DocumentTypeXmlParser parser = new DocumentTypeXmlParser();
        try {
            parser.parseDocumentTypes(inputStream);
        }
        catch (Exception e) {
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error parsing documentType XML file", new WorkflowServiceErrorImpl("Error parsing documentType XML file", XML_FILE_PARSE_ERROR));
            wsee.initCause(e);
            throw wsee;
        }
    }

    public Element export(ExportDataSet dataSet) {
        DocumentTypeXmlExporter exporter = new DocumentTypeXmlExporter();
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    public List getChildDocumentTypes(String documentTypeId) {
        ArrayList<DocumentType> childDocumentTypes = new ArrayList<DocumentType>();
        List<String> childIds = this.getDocumentTypeDAO().getChildDocumentTypeIds(documentTypeId);
        for (String childDocumentTypeId : childIds) {
            childDocumentTypes.add(this.findById(childDocumentTypeId));
        }
        return childDocumentTypes;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

