/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import javax.mail.MessagingException;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.krad.exception.InvalidAddressException;
import org.kuali.rice.krad.service.MailService;

public class MailServiceImpl
implements MailService {
    private String batchMailingList;
    private Mailer mailer;
    private String nonProductionNotificationMailingList;
    private boolean realNotificationsEnabled = true;

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    public void setBatchMailingList(String batchMailingList) {
        this.batchMailingList = batchMailingList;
    }

    public String getBatchMailingList() {
        return this.batchMailingList;
    }

    public void sendMessage(MailMessage message) throws InvalidAddressException, MessagingException {
        this.mailer.sendEmail(this.composeMessage(message));
    }

    protected MailMessage composeMessage(MailMessage message) {
        MailMessage mm = new MailMessage();
        if (!this.isRealNotificationsEnabled()) {
            this.getNonProductionMessage(message);
        }
        String app = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.id");
        String env = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment");
        mm.setToAddresses(message.getToAddresses());
        mm.setBccAddresses(message.getBccAddresses());
        mm.setCcAddresses(message.getCcAddresses());
        mm.setSubject(app + " " + env + ": " + message.getSubject());
        mm.setMessage(message.getMessage());
        mm.setFromAddress(message.getFromAddress());
        return mm;
    }

    public String getNonProductionNotificationMailingList() {
        return this.nonProductionNotificationMailingList;
    }

    public void setNonProductionNotificationMailingList(String nonProductionNotificationMailingList) {
        this.nonProductionNotificationMailingList = nonProductionNotificationMailingList;
    }

    public boolean isRealNotificationsEnabled() {
        return this.realNotificationsEnabled;
    }

    public void setRealNotificationsEnabled(boolean realNotificationsEnabled) {
        this.realNotificationsEnabled = realNotificationsEnabled;
    }

    protected MailMessage getNonProductionMessage(MailMessage message) {
        StringBuilder buf = new StringBuilder();
        buf.append("Email To: ").append(message.getToAddresses()).append("\n");
        buf.append("Email CC: ").append(message.getCcAddresses()).append("\n");
        buf.append("Email BCC: ").append(message.getBccAddresses()).append("\n\n");
        buf.append(message.getMessage());
        message.getToAddresses().clear();
        message.addToAddress(this.getNonProductionNotificationMailingList());
        message.getBccAddresses().clear();
        message.getCcAddresses().clear();
        message.setMessage(buf.toString());
        return message;
    }
}

