/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.ControllerService;
import org.kuali.rice.krad.web.service.FileControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.kuali.rice.krad.web.service.QueryControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.kuali.rice.krad.web.service.SaveControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

public abstract class UifControllerBase {
    @Autowired
    private ControllerService controllerService;
    @Autowired
    private NavigationControllerService navigationControllerService;
    @Autowired
    private CollectionControllerService collectionControllerService;
    @Autowired
    private SaveControllerService saveControllerService;
    @Autowired
    private RefreshControllerService refreshControllerService;
    @Autowired
    private QueryControllerService queryControllerService;
    @Autowired
    private FileControllerService fileControllerService;
    @Autowired
    private ModelAndViewService modelAndViewService;

    @ModelAttribute(value="KualiForm")
    protected UifFormBase initForm() {
        return this.createInitialForm();
    }

    protected abstract UifFormBase createInitialForm();

    @RequestMapping
    public ModelAndView defaultMapping(UifFormBase form) {
        return this.start(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=start"})
    public ModelAndView start(UifFormBase form) {
        return this.getControllerService().start(form);
    }

    @RequestMapping(params={"methodToCall=sessionTimeout"})
    public ModelAndView sessionTimeout(UifFormBase form) {
        return this.getControllerService().sessionTimeout(form);
    }

    @RequestMapping(params={"methodToCall=cancel"})
    public ModelAndView cancel(UifFormBase form) {
        return this.getControllerService().cancel(form);
    }

    @RequestMapping(params={"methodToCall=back"})
    public ModelAndView back(UifFormBase form) {
        return this.getNavigationControllerService().back(form);
    }

    @RequestMapping(params={"methodToCall=returnToPrevious"})
    public ModelAndView returnToPrevious(UifFormBase form) {
        return this.getNavigationControllerService().returnToPrevious(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=save"})
    public ModelAndView save(UifFormBase form) throws Exception {
        return this.getSaveControllerService().save(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=saveField"})
    public ModelAndView saveField(UifFormBase form) throws Exception {
        return this.getSaveControllerService().saveField(form);
    }

    @RequestMapping(params={"methodToCall=returnToHub"})
    public ModelAndView returnToHub(UifFormBase form) {
        return this.getNavigationControllerService().returnToHub(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addFileUploadLine"})
    public ModelAndView addFileUploadLine(UifFormBase form) {
        return this.getFileControllerService().addFileUploadLine(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteFileUploadLine"})
    public ModelAndView deleteFileUploadLine(UifFormBase form) {
        return this.getFileControllerService().deleteFileUploadLine(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=getFileFromLine"})
    public void getFileFromLine(UifFormBase form, HttpServletResponse response) {
        this.getFileControllerService().getFileFromLine(form, response);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=navigate"})
    public ModelAndView navigate(UifFormBase form) {
        return this.getNavigationControllerService().navigate(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addLine"})
    public ModelAndView addLine(UifFormBase form) {
        return this.getCollectionControllerService().addLine(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addBlankLine"})
    public ModelAndView addBlankLine(UifFormBase form) {
        return this.getCollectionControllerService().addBlankLine(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=retrieveEditLineDialog"})
    public ModelAndView retrieveEditLineDialog(UifFormBase form) {
        return this.getCollectionControllerService().retrieveEditLineDialog(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=editLine"})
    public ModelAndView editLine(UifFormBase form) {
        return this.getCollectionControllerService().editLine(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=closeEditLineDialog"})
    public ModelAndView closeEditLineDialog(UifFormBase form) {
        return this.getCollectionControllerService().closeEditLineDialog(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=saveLine"})
    public ModelAndView saveLine(UifFormBase form) {
        return this.getCollectionControllerService().saveLine(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteLine"})
    public ModelAndView deleteLine(UifFormBase form) {
        return this.getCollectionControllerService().deleteLine(form);
    }

    @RequestMapping(params={"methodToCall=retrieveCollectionPage"})
    public ModelAndView retrieveCollectionPage(UifFormBase form) {
        return this.getCollectionControllerService().retrieveCollectionPage(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=tableJsonRetrieval"})
    public ModelAndView tableJsonRetrieval(UifFormBase form) {
        return this.getCollectionControllerService().tableJsonRetrieval(form);
    }

    @MethodAccessible
    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(UifFormBase form) {
        return this.getRefreshControllerService().refresh(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=performLookup"})
    public ModelAndView performLookup(UifFormBase form) {
        return this.getQueryControllerService().performLookup(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldSuggest"})
    @ResponseBody
    public AttributeQueryResult performFieldSuggest(UifFormBase form) {
        return this.getQueryControllerService().performFieldSuggest(form);
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=performFieldQuery"})
    @ResponseBody
    public AttributeQueryResult performFieldQuery(UifFormBase form) {
        return this.getQueryControllerService().performFieldQuery(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=checkForm"})
    public ModelAndView checkForm(UifFormBase form) {
        return this.getModelAndViewService().checkForm(form);
    }

    protected ModelAndView showDialog(String dialogId, boolean confirmation, UifFormBase form) {
        return this.getModelAndViewService().showDialog(dialogId, confirmation, form);
    }

    protected ModelAndView performRedirect(UifFormBase form, String baseUrl, Properties urlParameters) {
        return this.getModelAndViewService().performRedirect(form, baseUrl, urlParameters);
    }

    protected ModelAndView performRedirect(UifFormBase form, String redirectUrl) {
        return this.getModelAndViewService().performRedirect(form, redirectUrl);
    }

    protected ModelAndView getMessageView(UifFormBase form, String headerText, String messageText) {
        return this.getModelAndViewService().getMessageView(form, headerText, messageText);
    }

    protected ModelAndView getModelAndView(UifFormBase form) {
        return this.getModelAndViewService().getModelAndView(form);
    }

    protected ModelAndView getModelAndView(UifFormBase form, String pageId) {
        return this.getModelAndViewService().getModelAndView(form, pageId);
    }

    protected ModelAndView getModelAndView(UifFormBase form, Map<String, Object> additionalViewAttributes) {
        return this.getModelAndViewService().getModelAndView(form, additionalViewAttributes);
    }

    protected ModelAndView getModelAndViewWithInit(UifFormBase form, String viewId) {
        return this.getModelAndViewService().getModelAndViewWithInit(form, viewId);
    }

    protected ModelAndView getModelAndViewWithInit(UifFormBase form, String viewId, String pageId) {
        return this.getModelAndViewService().getModelAndViewWithInit(form, viewId, pageId);
    }

    protected ControllerService getControllerService() {
        return this.controllerService;
    }

    public void setControllerService(ControllerService controllerService) {
        this.controllerService = controllerService;
    }

    protected NavigationControllerService getNavigationControllerService() {
        return this.navigationControllerService;
    }

    public void setNavigationControllerService(NavigationControllerService navigationControllerService) {
        this.navigationControllerService = navigationControllerService;
    }

    protected CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    protected RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public SaveControllerService getSaveControllerService() {
        return this.saveControllerService;
    }

    public void setSaveControllerService(SaveControllerService saveControllerService) {
        this.saveControllerService = saveControllerService;
    }

    protected QueryControllerService getQueryControllerService() {
        return this.queryControllerService;
    }

    public void setQueryControllerService(QueryControllerService queryControllerService) {
        this.queryControllerService = queryControllerService;
    }

    protected FileControllerService getFileControllerService() {
        return this.fileControllerService;
    }

    public void setFileControllerService(FileControllerService fileControllerService) {
        this.fileControllerService = fileControllerService;
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

