/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krms.api.repository.NaturalLanguageTree;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.TranslateBusinessMethods;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBinding;
import org.kuali.rice.krms.api.repository.reference.ReferenceObjectBindingContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.ActionBoService;
import org.kuali.rice.krms.impl.repository.ActionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaBoServiceImpl;
import org.kuali.rice.krms.impl.repository.CompoundPropositionComparator;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoService;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoService;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoServiceImpl;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionBoServiceImpl;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBo;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoService;
import org.kuali.rice.krms.impl.repository.ReferenceObjectBindingBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.RuleBoServiceImpl;
import org.kuali.rice.krms.impl.repository.RuleRepositoryServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TranslationUtility;
import org.kuali.rice.krms.impl.repository.language.SimpleNaturalLanguageTemplater;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class RuleManagementServiceImpl
extends RuleRepositoryServiceImpl
implements RuleManagementService {
    private ReferenceObjectBindingBoService referenceObjectBindingBoService = new ReferenceObjectBindingBoServiceImpl();
    private AgendaBoService agendaBoService = new AgendaBoServiceImpl();
    private RuleBoService ruleBoService = new RuleBoServiceImpl();
    private ActionBoService actionBoService = new ActionBoServiceImpl();
    private PropositionBoService propositionBoService = new PropositionBoServiceImpl();
    private NaturalLanguageUsageBoService naturalLanguageUsageBoService = new NaturalLanguageUsageBoServiceImpl();
    private NaturalLanguageTemplateBoService naturalLanguageTemplateBoService = new NaturalLanguageTemplateBoServiceImpl();
    private ContextBoService contextBoService = new ContextBoServiceImpl();
    private NaturalLanguageTemplaterContract templater = new SimpleNaturalLanguageTemplater();
    private TermRepositoryService termRepositoryService = new TermBoServiceImpl();
    private TranslateBusinessMethods translationBusinessMethods = null;
    private DataSource dataSource;
    private DataFieldMaxValueIncrementer ruleSequenceIncrementer;
    private DataFieldMaxValueIncrementer referenceObjectBindingSequenceIncrementer;
    private static final String RULE_SEQ_NAME = "KRMS_RULE_S";
    private static final String REF_OBJ_SEQ_NAME = "KRMS_REF_OBJ_KRMS_OBJ_S";
    private static final List<String> isSameIgnoreFields = Arrays.asList("id", "versionNumber", "_futureElements");

    public ReferenceObjectBindingBoService getReferenceObjectBindingBoService() {
        return this.referenceObjectBindingBoService;
    }

    public void setReferenceObjectBindingBoService(ReferenceObjectBindingBoService referenceObjectBindingBoService) {
        this.referenceObjectBindingBoService = referenceObjectBindingBoService;
    }

    public AgendaBoService getAgendaBoService() {
        return this.agendaBoService;
    }

    public void setAgendaBoService(AgendaBoService agendaBoService) {
        this.agendaBoService = agendaBoService;
    }

    public RuleBoService getRuleBoService() {
        return this.ruleBoService;
    }

    public void setRuleBoService(RuleBoService ruleBoService) {
        this.ruleBoService = ruleBoService;
    }

    public PropositionBoService getPropositionBoService() {
        return this.propositionBoService;
    }

    public void setPropositionBoService(PropositionBoService propositionBoService) {
        this.propositionBoService = propositionBoService;
    }

    public NaturalLanguageUsageBoService getNaturalLanguageUsageBoService() {
        return this.naturalLanguageUsageBoService;
    }

    public void setNaturalLanguageUsageBoService(NaturalLanguageUsageBoService naturalLanguageUsageBoService) {
        this.naturalLanguageUsageBoService = naturalLanguageUsageBoService;
    }

    public NaturalLanguageTemplateBoService getNaturalLanguageTemplateBoService() {
        return this.naturalLanguageTemplateBoService;
    }

    public void setNaturalLanguageTemplateBoService(NaturalLanguageTemplateBoService naturalLanguageTemplateBoService) {
        this.naturalLanguageTemplateBoService = naturalLanguageTemplateBoService;
    }

    public ContextBoService getContextBoService() {
        return this.contextBoService;
    }

    public void setContextBoService(ContextBoService contextBoService) {
        this.contextBoService = contextBoService;
    }

    public ActionBoService getActionBoService() {
        return this.actionBoService;
    }

    public void setActionBoService(ActionBoService actionBoService) {
        this.actionBoService = actionBoService;
    }

    public NaturalLanguageTemplaterContract getTemplater() {
        return this.templater;
    }

    public void setTemplater(NaturalLanguageTemplaterContract templater) {
        this.templater = templater;
    }

    public TermRepositoryService getTermRepositoryService() {
        return this.termRepositoryService;
    }

    public void setTermRepositoryService(TermRepositoryService termRepositoryService) {
        this.termRepositoryService = termRepositoryService;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private DataFieldMaxValueIncrementer getRuleSequenceIncrementer() {
        if (this.ruleSequenceIncrementer == null) {
            this.ruleSequenceIncrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.dataSource, (String)RULE_SEQ_NAME);
        }
        return this.ruleSequenceIncrementer;
    }

    private DataFieldMaxValueIncrementer getReferenceObjectBindingSequenceIncrementer() {
        if (this.referenceObjectBindingSequenceIncrementer == null) {
            this.referenceObjectBindingSequenceIncrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.dataSource, (String)REF_OBJ_SEQ_NAME);
        }
        return this.referenceObjectBindingSequenceIncrementer;
    }

    public TranslateBusinessMethods getTranslateBusinessMethods() {
        if (this.translationBusinessMethods == null) {
            this.translationBusinessMethods = new TranslationUtility(this, this.getTermRepositoryService(), this.templater);
        }
        return this.translationBusinessMethods;
    }

    public void setTranslationBusinessMethods(TranslateBusinessMethods translationBusinessMethods) {
        this.translationBusinessMethods = translationBusinessMethods;
    }

    public ReferenceObjectBinding createReferenceObjectBinding(ReferenceObjectBinding referenceObjectDefinition) throws RiceIllegalArgumentException {
        if (referenceObjectDefinition.getId() == null) {
            String referenceObjectBindingId = this.getReferenceObjectBindingSequenceIncrementer().nextStringValue();
            ReferenceObjectBinding.Builder refBldr = ReferenceObjectBinding.Builder.create((ReferenceObjectBindingContract)referenceObjectDefinition);
            refBldr.setId(referenceObjectBindingId);
            referenceObjectDefinition = refBldr.build();
        }
        return this.referenceObjectBindingBoService.createReferenceObjectBinding(referenceObjectDefinition);
    }

    public ReferenceObjectBinding getReferenceObjectBinding(String id) throws RiceIllegalArgumentException {
        return this.referenceObjectBindingBoService.getReferenceObjectBinding(id);
    }

    public List<ReferenceObjectBinding> getReferenceObjectBindings(List<String> ids) throws RiceIllegalArgumentException {
        if (ids == null) {
            throw new IllegalArgumentException("reference binding object ids must not be null");
        }
        List bos = null;
        if (ids.size() == 0) {
            bos = Collections.emptyList();
        } else {
            QueryByCriteria.Builder qBuilder = QueryByCriteria.Builder.create();
            ArrayList pList = new ArrayList();
            qBuilder.setPredicates(new Predicate[]{PredicateFactory.in((String)"id", (Object[])ids.toArray())});
            QueryResults results = this.getDataObjectService().findMatching(ReferenceObjectBindingBo.class, qBuilder.build());
            bos = results.getResults();
        }
        LinkedList<ReferenceObjectBinding> bindings = new LinkedList<ReferenceObjectBinding>();
        for (ReferenceObjectBindingBo bo : bos) {
            ReferenceObjectBinding binding = ReferenceObjectBindingBo.to(bo);
            bindings.add(binding);
        }
        return Collections.unmodifiableList(bindings);
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceObject(String referenceObjectReferenceDiscriminatorType, String referenceObjectId) throws RiceIllegalArgumentException {
        if (referenceObjectReferenceDiscriminatorType == null) {
            throw new RiceIllegalArgumentException("reference binding object discriminator type must not be null");
        }
        if (referenceObjectId == null) {
            throw new RiceIllegalArgumentException("reference object id must not be null");
        }
        ArrayList<ReferenceObjectBinding> list = new ArrayList<ReferenceObjectBinding>();
        for (ReferenceObjectBinding binding : this.referenceObjectBindingBoService.findReferenceObjectBindingsByReferenceObject(referenceObjectId)) {
            if (!binding.getReferenceDiscriminatorType().equals(referenceObjectReferenceDiscriminatorType)) continue;
            list.add(binding);
        }
        return list;
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByReferenceDiscriminatorType(String referenceObjectReferenceDiscriminatorType) throws RiceIllegalArgumentException {
        return this.referenceObjectBindingBoService.findReferenceObjectBindingsByReferenceDiscriminatorType(referenceObjectReferenceDiscriminatorType);
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsDiscriminatorType(String referenceObjectKrmsDiscriminatorType) throws RiceIllegalArgumentException {
        return this.referenceObjectBindingBoService.findReferenceObjectBindingsByKrmsDiscriminatorType(referenceObjectKrmsDiscriminatorType);
    }

    public List<ReferenceObjectBinding> findReferenceObjectBindingsByKrmsObject(String krmsObjectId) throws RiceIllegalArgumentException {
        return this.referenceObjectBindingBoService.findReferenceObjectBindingsByKrmsObject(krmsObjectId);
    }

    public void updateReferenceObjectBinding(ReferenceObjectBinding referenceObjectBindingDefinition) throws RiceIllegalArgumentException {
        this.referenceObjectBindingBoService.updateReferenceObjectBinding(referenceObjectBindingDefinition);
    }

    public void deleteReferenceObjectBinding(String id) throws RiceIllegalArgumentException {
        this.referenceObjectBindingBoService.deleteReferenceObjectBinding(id);
    }

    public List<String> findReferenceObjectBindingIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        return this.referenceObjectBindingBoService.findReferenceObjectBindingIds(queryByCriteria);
    }

    public AgendaDefinition createAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        return this.agendaBoService.createAgenda(agendaDefinition);
    }

    public AgendaDefinition getAgendaByNameAndContextId(String name, String contextId) {
        return this.agendaBoService.getAgendaByNameAndContextId(name, contextId);
    }

    public AgendaDefinition findCreateAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        AgendaDefinition existing = this.getAgendaByNameAndContextId(agendaDefinition.getName(), agendaDefinition.getContextId());
        if (existing != null) {
            existing = this.updateAgendaIfNeeded(agendaDefinition, existing);
            return existing;
        }
        return this.createAgenda(agendaDefinition);
    }

    private AgendaDefinition updateAgendaIfNeeded(AgendaDefinition agenda, AgendaDefinition existing) {
        if (this.isSame(agenda, existing)) {
            return existing;
        }
        AgendaDefinition.Builder bldr = AgendaDefinition.Builder.create((AgendaDefinitionContract)existing);
        bldr.setActive(agenda.isActive());
        bldr.setAttributes(agenda.getAttributes());
        bldr.setContextId(agenda.getContextId());
        if (agenda.getFirstItemId() != null) {
            bldr.setFirstItemId(agenda.getFirstItemId());
        }
        bldr.setTypeId(agenda.getTypeId());
        this.updateAgenda(bldr.build());
        return this.getAgenda(existing.getId());
    }

    private boolean isSame(AgendaDefinition agenda, AgendaDefinition existing) {
        return EqualsBuilder.reflectionEquals((Object)agenda, (Object)existing, isSameIgnoreFields);
    }

    public AgendaDefinition getAgenda(String id) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendaByAgendaId(id);
    }

    public List<AgendaDefinition> getAgendasByContext(String contextId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendasByContextId(contextId);
    }

    public void updateAgenda(AgendaDefinition agendaDefinition) throws RiceIllegalArgumentException {
        this.agendaBoService.updateAgenda(agendaDefinition);
    }

    public void deleteAgenda(String id) throws RiceIllegalArgumentException {
        this.agendaBoService.deleteAgenda(id);
    }

    public List<AgendaDefinition> getAgendasByType(String typeId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendasByType(typeId);
    }

    public List<AgendaDefinition> getAgendasByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendasByTypeAndContext(typeId, contextId);
    }

    public AgendaItemDefinition createAgendaItem(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        return this.createUpdateAgendaItemIfNeeded(agendaItemDefinition);
    }

    private AgendaItemDefinition createUpdateAgendaItemIfNeeded(AgendaItemDefinition agendaItemDefinition) {
        this.crossCheckRuleId(agendaItemDefinition);
        this.crossCheckWhenTrueId(agendaItemDefinition);
        this.crossCheckWhenFalseId(agendaItemDefinition);
        this.crossCheckAlwaysId(agendaItemDefinition);
        this.crossCheckSubAgendaId(agendaItemDefinition);
        agendaItemDefinition = this.createUpdateRuleIfNeeded(agendaItemDefinition);
        agendaItemDefinition = this.createWhenTrueAgendaItemIfNeeded(agendaItemDefinition);
        agendaItemDefinition = this.createWhenFalseAgendaItemIfNeeded(agendaItemDefinition);
        agendaItemDefinition = this.createAlwaysAgendaItemIfNeeded(agendaItemDefinition);
        agendaItemDefinition = this.createSubAgendaIfNeeded(agendaItemDefinition);
        boolean update = false;
        if (agendaItemDefinition.getId() != null && this.agendaBoService.getAgendaItemById(agendaItemDefinition.getId()) != null) {
            this.agendaBoService.updateAgendaItem(agendaItemDefinition);
        } else {
            agendaItemDefinition = this.agendaBoService.createAgendaItem(agendaItemDefinition);
        }
        return agendaItemDefinition;
    }

    private void crossCheckRuleId(AgendaItemDefinition agendItemDefinition) throws RiceIllegalArgumentException {
        if (agendItemDefinition.getRuleId() != null && agendItemDefinition.getRule() != null && !agendItemDefinition.getRuleId().equals(agendItemDefinition.getRule().getId())) {
            throw new RiceIllegalArgumentException("ruleId does not rule.getId" + agendItemDefinition.getRuleId() + " " + agendItemDefinition.getRule().getId());
        }
    }

    private void crossCheckWhenTrueId(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        if (agendaItemDefinition.getWhenTrueId() != null && agendaItemDefinition.getWhenTrue() != null && !agendaItemDefinition.getWhenTrueId().equals(agendaItemDefinition.getWhenTrue().getId())) {
            throw new RiceIllegalArgumentException("when true id does not match " + agendaItemDefinition.getWhenTrueId() + " " + agendaItemDefinition.getWhenTrue().getId());
        }
    }

    private void crossCheckWhenFalseId(AgendaItemDefinition agendItemDefinition) throws RiceIllegalArgumentException {
        if (agendItemDefinition.getWhenFalseId() != null && agendItemDefinition.getWhenFalse() != null && !agendItemDefinition.getWhenFalseId().equals(agendItemDefinition.getWhenFalse().getId())) {
            throw new RiceIllegalArgumentException("when false id does not match " + agendItemDefinition.getWhenFalseId() + " " + agendItemDefinition.getWhenFalse().getId());
        }
    }

    private void crossCheckAlwaysId(AgendaItemDefinition agendItemDefinition) throws RiceIllegalArgumentException {
        if (agendItemDefinition.getAlwaysId() != null && agendItemDefinition.getAlways() != null && !agendItemDefinition.getAlwaysId().equals(agendItemDefinition.getAlways().getId())) {
            throw new RiceIllegalArgumentException("Always id does not match " + agendItemDefinition.getAlwaysId() + " " + agendItemDefinition.getAlways().getId());
        }
    }

    private void crossCheckSubAgendaId(AgendaItemDefinition agendItemDefinition) throws RiceIllegalArgumentException {
        if (agendItemDefinition.getSubAgendaId() != null && agendItemDefinition.getSubAgenda() != null && !agendItemDefinition.getSubAgendaId().equals(agendItemDefinition.getSubAgenda().getId())) {
            throw new RiceIllegalArgumentException("SubAgenda id does not match " + agendItemDefinition.getSubAgendaId() + " " + agendItemDefinition.getSubAgenda().getId());
        }
    }

    private AgendaItemDefinition createUpdateRuleIfNeeded(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        if (agendaItemDefinition.getRule() == null) {
            return agendaItemDefinition;
        }
        RuleDefinition rule = null;
        if (agendaItemDefinition.getRule().getId() != null) {
            this.updateRule(agendaItemDefinition.getRule());
            rule = this.getRule(agendaItemDefinition.getRule().getId());
        } else {
            rule = this.createRule(agendaItemDefinition.getRule());
        }
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        RuleDefinition.Builder ruleBuilder = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
        agendaItemBuilder.setRule(ruleBuilder);
        agendaItemBuilder.setRuleId(ruleBuilder.getId());
        return agendaItemBuilder.build();
    }

    private AgendaItemDefinition createWhenTrueAgendaItemIfNeeded(AgendaItemDefinition agendaItemDefinition) {
        if (agendaItemDefinition.getWhenTrue() == null) {
            return agendaItemDefinition;
        }
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        AgendaItemDefinition subAgendaItem = this.createUpdateAgendaItemIfNeeded(agendaItemDefinition.getWhenTrue());
        agendaItemBuilder.setWhenTrue(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)subAgendaItem));
        return agendaItemBuilder.build();
    }

    private AgendaItemDefinition createWhenFalseAgendaItemIfNeeded(AgendaItemDefinition agendaItemDefinition) {
        if (agendaItemDefinition.getWhenFalse() == null) {
            return agendaItemDefinition;
        }
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        AgendaItemDefinition subAgendaItem = this.createUpdateAgendaItemIfNeeded(agendaItemDefinition.getWhenFalse());
        agendaItemBuilder.setWhenFalse(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)subAgendaItem));
        return agendaItemBuilder.build();
    }

    private AgendaItemDefinition createAlwaysAgendaItemIfNeeded(AgendaItemDefinition agendaItemDefinition) {
        if (agendaItemDefinition.getAlways() == null) {
            return agendaItemDefinition;
        }
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        AgendaItemDefinition subAgendaItem = this.createUpdateAgendaItemIfNeeded(agendaItemDefinition.getAlways());
        agendaItemBuilder.setAlways(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)subAgendaItem));
        return agendaItemBuilder.build();
    }

    private AgendaItemDefinition createSubAgendaIfNeeded(AgendaItemDefinition agendaItemDefinition) {
        if (agendaItemDefinition.getSubAgenda() == null) {
            return agendaItemDefinition;
        }
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefinition);
        AgendaDefinition subAgenda = this.createAgenda(agendaItemDefinition.getSubAgenda());
        agendaItemBuilder.setSubAgenda(AgendaDefinition.Builder.create((AgendaDefinitionContract)subAgenda));
        agendaItemBuilder.setSubAgendaId(subAgenda.getId());
        return agendaItemBuilder.build();
    }

    public AgendaItemDefinition getAgendaItem(String id) throws RiceIllegalArgumentException {
        AgendaItemDefinition agendaItem = this.agendaBoService.getAgendaItemById(id);
        if (agendaItem != null) {
            return this.setTermValuesForAgendaItem(agendaItem).build();
        }
        return agendaItem;
    }

    private AgendaItemDefinition.Builder setTermValuesForAgendaItem(AgendaItemDefinition agendaItem) {
        PropositionDefinition proposition;
        if (agendaItem == null) {
            return null;
        }
        AgendaItemDefinition.Builder itemBuiler = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
        if (itemBuiler.getRule() != null && (proposition = agendaItem.getRule().getProposition()) != null) {
            proposition = this.orderCompoundPropositionsIfNeeded(proposition);
            itemBuiler.getRule().setProposition(this.replaceTermValues(proposition));
        }
        itemBuiler.setWhenTrue(this.setTermValuesForAgendaItem(agendaItem.getWhenTrue()));
        itemBuiler.setWhenFalse(this.setTermValuesForAgendaItem(agendaItem.getWhenFalse()));
        itemBuiler.setAlways(this.setTermValuesForAgendaItem(agendaItem.getAlways()));
        return itemBuiler;
    }

    public List<AgendaItemDefinition> getAgendaItemsByType(String typeId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendaItemsByType(typeId);
    }

    public List<AgendaItemDefinition> getAgendaItemsByContext(String contextId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendaItemsByContext(contextId);
    }

    public List<AgendaItemDefinition> getAgendaItemsByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        return this.agendaBoService.getAgendaItemsByTypeAndContext(typeId, contextId);
    }

    public void deleteAgendaItem(String id) throws RiceIllegalArgumentException {
        this.agendaBoService.deleteAgendaItem(id);
    }

    public void updateAgendaItem(AgendaItemDefinition agendaItemDefinition) throws RiceIllegalArgumentException {
        this.createUpdateAgendaItemIfNeeded(agendaItemDefinition);
    }

    private void crossCheckPropId(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        if (ruleDefinition.getPropId() != null && ruleDefinition.getProposition() != null && !ruleDefinition.getPropId().equals(ruleDefinition.getProposition().getId())) {
            throw new RiceIllegalArgumentException("propId does not match proposition.getId" + ruleDefinition.getPropId() + " " + ruleDefinition.getProposition().getId());
        }
    }

    public RuleDefinition getRuleByNameAndNamespace(String name, String namespace) {
        return this.ruleBoService.getRuleByNameAndNamespace(name, namespace);
    }

    public RuleDefinition createRule(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        if (ruleDefinition.getId() != null) {
            RuleDefinition orig = this.getRule(ruleDefinition.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(ruleDefinition.getId());
            }
        } else {
            String ruleId = this.getRuleSequenceIncrementer().nextStringValue();
            RuleDefinition.Builder ruleBldr = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDefinition);
            ruleBldr.setId(ruleId);
            ruleDefinition = ruleBldr.build();
        }
        this.crossCheckPropId(ruleDefinition);
        ruleDefinition = this.createUpdatePropositionIfNeeded(ruleDefinition);
        ruleDefinition = this.ruleBoService.createRule(ruleDefinition);
        return ruleDefinition;
    }

    private RuleDefinition createRuleIfNeeded(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        if (ruleDefinition == null) {
            return null;
        }
        if (ruleDefinition.getId() == null) {
            String ruleId = this.getRuleSequenceIncrementer().nextStringValue();
            RuleDefinition.Builder ruleBldr = RuleDefinition.Builder.create((RuleDefinitionContract)ruleDefinition);
            ruleBldr.setId(ruleId);
            ruleDefinition = ruleBldr.build();
        }
        this.crossCheckPropId(ruleDefinition);
        ruleDefinition = this.createUpdatePropositionIfNeeded(ruleDefinition);
        return ruleDefinition;
    }

    private RuleDefinition createUpdatePropositionIfNeeded(RuleDefinition rule) {
        if (rule.getProposition() == null) {
            return rule;
        }
        if (rule.getProposition().getId() != null) {
            this.updateProposition(rule.getProposition());
            PropositionDefinition prop = this.getProposition(rule.getProposition().getId());
            RuleDefinition.Builder ruleBldr = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
            ruleBldr.setProposition(PropositionDefinition.Builder.create((PropositionDefinitionContract)prop));
            ruleBldr.setPropId(prop.getId());
            return ruleBldr.build();
        }
        RuleDefinition.Builder ruleBldr = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
        PropositionDefinition propositionDefinition = null;
        PropositionDefinition.Builder propBldr = ruleBldr.getProposition();
        if (rule.getProposition().getId() != null) {
            this.crossCheckPropositionParameters(rule.getProposition());
            propBldr = this.setSequenceOnCompoundPropositionsIfNeeded(propBldr);
            propBldr = this.maintainTermValuesAndChildPropositions(propBldr);
        } else {
            propBldr.setRule(ruleBldr);
            propositionDefinition = this.createProposition(propBldr.build());
            propBldr = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        }
        ruleBldr.setProposition(propBldr);
        return ruleBldr.build();
    }

    public void updateRule(RuleDefinition ruleDefinition) throws RiceIllegalArgumentException {
        this.crossCheckPropId(ruleDefinition);
        ruleDefinition = this.createUpdatePropositionIfNeeded(ruleDefinition);
        this.ruleBoService.updateRule(ruleDefinition);
    }

    public void deleteRule(String id) throws RiceIllegalArgumentException {
        this.ruleBoService.deleteRule(id);
    }

    public ActionDefinition createAction(ActionDefinition actionDefinition) throws RiceIllegalArgumentException {
        return this.actionBoService.createAction(actionDefinition);
    }

    public void updateAction(ActionDefinition actionDefinition) throws RiceIllegalArgumentException {
        this.actionBoService.updateAction(actionDefinition);
    }

    public void deleteAction(String id) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("not implemented yet because not supported by the bo service");
    }

    public ActionDefinition getAction(String actionId) {
        return this.actionBoService.getActionByActionId(actionId);
    }

    public List<ActionDefinition> getActions(List<String> actionIds) {
        ArrayList<ActionDefinition> list = new ArrayList<ActionDefinition>();
        for (String id : actionIds) {
            list.add(this.getAction(id));
        }
        return list;
    }

    private void crossCheckPropositionParameters(PropositionDefinition propositionDefinition) {
        for (PropositionParameter param : propositionDefinition.getParameters()) {
            if (param.getValue() == null || param.getTermValue() == null || param.getValue().equals(param.getTermValue().getId())) continue;
            throw new RiceIllegalArgumentException("value does not match termValue.id on param " + param.getSequenceNumber() + " " + param.getValue() + " " + param.getTermValue().getId());
        }
    }

    public PropositionDefinition createProposition(PropositionDefinition propositionDefinition) throws RiceIllegalArgumentException {
        PropositionDefinition orig;
        if (propositionDefinition.getId() != null && (orig = this.getProposition(propositionDefinition.getId())) != null) {
            throw new RiceIllegalArgumentException(propositionDefinition.getId());
        }
        this.crossCheckPropositionParameters(propositionDefinition);
        PropositionDefinition.Builder propBldr = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        propBldr = this.setSequenceOnCompoundPropositionsIfNeeded(propBldr);
        propBldr = this.maintainTermValuesAndChildPropositions(propBldr);
        PropositionDefinition prop = this.propositionBoService.createProposition(propBldr.build());
        return prop;
    }

    private PropositionDefinition.Builder maintainTermValuesAndChildPropositions(PropositionDefinition.Builder propBldr) {
        if (PropositionType.SIMPLE.getCode().equalsIgnoreCase(propBldr.getPropositionTypeCode())) {
            return this.maintainTermValues(propBldr);
        }
        return this.createChildPropsIfNeeded(propBldr);
    }

    private PropositionDefinition.Builder maintainTermValues(PropositionDefinition.Builder propBldr) {
        if (propBldr.getParameters() == null) {
            return propBldr;
        }
        if (propBldr.getParameters().isEmpty()) {
            return propBldr;
        }
        boolean updated = false;
        ArrayList<PropositionParameter.Builder> paramBldrs = new ArrayList<PropositionParameter.Builder>();
        for (PropositionParameter.Builder paramBldr : propBldr.getParameters()) {
            paramBldrs.add(paramBldr);
            if (paramBldr.getPropId() == null) {
                paramBldr.setPropId(propBldr.getId());
                updated = true;
            }
            if (paramBldr.getTermValue() == null) continue;
            TermDefinition termValue = paramBldr.getTermValue();
            if (termValue.getId() == null) {
                termValue = this.termRepositoryService.createTerm(termValue);
                paramBldr.setTermValue(termValue);
                updated = true;
            } else {
                this.termRepositoryService.updateTerm(termValue);
            }
            if (paramBldr.getValue() != null && paramBldr.getValue().equals(termValue.getId())) continue;
            paramBldr.setValue(termValue.getId());
            updated = true;
        }
        if (!updated) {
            return propBldr;
        }
        propBldr.setParameters(paramBldrs);
        return propBldr;
    }

    private PropositionDefinition.Builder createChildPropsIfNeeded(PropositionDefinition.Builder propBldr) {
        if (propBldr.getCompoundComponents() == null) {
            return propBldr;
        }
        if (propBldr.getCompoundComponents().isEmpty()) {
            return propBldr;
        }
        ArrayList<PropositionDefinition.Builder> childPropBldrs = new ArrayList<PropositionDefinition.Builder>();
        for (PropositionDefinition.Builder compPropBldr : propBldr.getCompoundComponents()) {
            compPropBldr.setRuleId(propBldr.getRuleId());
            propBldr = this.setSequenceOnCompoundPropositionsIfNeeded(propBldr);
            compPropBldr = this.maintainTermValuesAndChildPropositions(compPropBldr);
            childPropBldrs.add(compPropBldr);
        }
        propBldr.setCompoundComponents(childPropBldrs);
        return propBldr;
    }

    public PropositionDefinition getProposition(String id) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("Proposition id must not be null or blank");
        }
        PropositionDefinition proposition = this.propositionBoService.getPropositionById(id);
        if (proposition == null) {
            return null;
        }
        proposition = this.replaceTermValues(proposition).build();
        proposition = this.orderCompoundPropositionsIfNeeded(proposition);
        return proposition;
    }

    private PropositionDefinition orderCompoundPropositionsIfNeeded(PropositionDefinition prop) {
        if (!prop.getPropositionTypeCode().equals(PropositionType.COMPOUND.getCode())) {
            return prop;
        }
        if (prop.getCompoundComponents() == null) {
            return prop;
        }
        if (prop.getCompoundComponents().size() <= 1) {
            return prop;
        }
        PropositionDefinition.Builder propBldr = PropositionDefinition.Builder.create((PropositionDefinitionContract)prop);
        ArrayList childProps = new ArrayList(prop.getCompoundComponents());
        Collections.sort(childProps, new CompoundPropositionComparator());
        ArrayList<PropositionDefinition.Builder> childPropBldrs = new ArrayList<PropositionDefinition.Builder>(childProps.size());
        for (PropositionDefinition chidProp : childProps) {
            PropositionDefinition.Builder childPropBlder = PropositionDefinition.Builder.create((PropositionDefinitionContract)chidProp);
            childPropBldrs.add(childPropBlder);
        }
        propBldr.setCompoundComponents(childPropBldrs);
        return propBldr.build();
    }

    private PropositionDefinition.Builder replaceTermValues(PropositionDefinition proposition) {
        PropositionDefinition.Builder bldr = PropositionDefinition.Builder.create((PropositionDefinitionContract)proposition);
        if (!PropositionType.SIMPLE.getCode().equalsIgnoreCase(proposition.getPropositionTypeCode())) {
            ArrayList<PropositionDefinition.Builder> cmpdProps = new ArrayList<PropositionDefinition.Builder>();
            for (PropositionDefinition cmpdProp : proposition.getCompoundComponents()) {
                cmpdProps.add(this.replaceTermValues(cmpdProp));
            }
            bldr.setCompoundComponents(cmpdProps);
            return bldr;
        }
        if (proposition.getParameters() == null) {
            return bldr;
        }
        if (proposition.getParameters().isEmpty()) {
            return bldr;
        }
        boolean found = false;
        ArrayList<PropositionParameter.Builder> params = new ArrayList<PropositionParameter.Builder>(proposition.getParameters().size());
        for (PropositionParameter param : proposition.getParameters()) {
            if (!PropositionParameterType.TERM.getCode().equalsIgnoreCase(param.getParameterType())) {
                params.add(PropositionParameter.Builder.create((PropositionParameter)param));
                continue;
            }
            found = true;
            TermDefinition termValue = this.termRepositoryService.getTerm(param.getValue());
            PropositionParameter.Builder parmbldr = PropositionParameter.Builder.create((PropositionParameter)param);
            parmbldr.setTermValue(termValue);
            params.add(parmbldr);
        }
        if (!found) {
            return bldr;
        }
        bldr.setParameters(params);
        return bldr;
    }

    private Set<PropositionDefinition> replaceTermValuesInSet(Set<PropositionDefinition> propositions) {
        if (propositions == null) {
            return null;
        }
        if (propositions.isEmpty()) {
            return propositions;
        }
        LinkedHashSet<PropositionDefinition> set = new LinkedHashSet<PropositionDefinition>(propositions.size());
        for (PropositionDefinition proposition : propositions) {
            proposition = this.replaceTermValues(proposition).build();
            set.add(proposition);
        }
        return set;
    }

    public Set<PropositionDefinition> getPropositionsByType(String typeId) throws RiceIllegalArgumentException {
        return this.replaceTermValuesInSet(this.propositionBoService.getPropositionsByType(typeId));
    }

    public Set<PropositionDefinition> getPropositionsByRule(String ruleId) throws RiceIllegalArgumentException {
        return this.replaceTermValuesInSet(this.propositionBoService.getPropositionsByRule(ruleId));
    }

    public void updateProposition(PropositionDefinition propositionDefinition) throws RiceIllegalArgumentException {
        this.crossCheckPropositionParameters(propositionDefinition);
        PropositionDefinition.Builder propBldr = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        propBldr = this.setSequenceOnCompoundPropositionsIfNeeded(propBldr);
        propBldr = this.maintainTermValuesAndChildPropositions(propBldr);
        this.propositionBoService.updateProposition(propBldr.build());
    }

    private PropositionDefinition.Builder setSequenceOnCompoundPropositionsIfNeeded(PropositionDefinition.Builder propBldr) {
        if (propBldr.getCompoundComponents() == null) {
            return propBldr;
        }
        if (propBldr.getCompoundComponents().size() <= 1) {
            return propBldr;
        }
        ArrayList<PropositionDefinition.Builder> childList = new ArrayList<PropositionDefinition.Builder>(propBldr.getCompoundComponents().size());
        int i = 1;
        for (PropositionDefinition.Builder childPropBldr : propBldr.getCompoundComponents()) {
            childPropBldr.setCompoundSequenceNumber(Integer.valueOf(i));
            ++i;
            childList.add(childPropBldr);
        }
        propBldr.setCompoundComponents(childList);
        return propBldr;
    }

    public void deleteProposition(String id) throws RiceIllegalArgumentException {
        this.propositionBoService.deleteProposition(id);
    }

    public NaturalLanguageUsage createNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) throws RiceIllegalArgumentException {
        return this.naturalLanguageUsageBoService.createNaturalLanguageUsage(naturalLanguageUsage);
    }

    public NaturalLanguageUsage getNaturalLanguageUsage(String id) throws RiceIllegalArgumentException {
        return this.naturalLanguageUsageBoService.getNaturalLanguageUsage(id);
    }

    public void updateNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) throws RiceIllegalArgumentException {
        this.naturalLanguageUsageBoService.updateNaturalLanguageUsage(naturalLanguageUsage);
    }

    public void deleteNaturalLanguageUsage(String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        this.naturalLanguageUsageBoService.deleteNaturalLanguageUsage(naturalLanguageUsageId);
    }

    public List<NaturalLanguageUsage> getNaturalLanguageUsagesByNamespace(String namespace) throws RiceIllegalArgumentException {
        return this.naturalLanguageUsageBoService.findNaturalLanguageUsagesByNamespace(namespace);
    }

    public NaturalLanguageUsage getNaturalLanguageUsageByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        return this.naturalLanguageUsageBoService.getNaturalLanguageUsageByName(namespace, name);
    }

    public String translateNaturalLanguageForObject(String naturalLanguageUsageId, String typeId, String krmsObjectId, String languageCode) throws RiceIllegalArgumentException {
        return this.getTranslateBusinessMethods().translateNaturalLanguageForObject(naturalLanguageUsageId, typeId, krmsObjectId, languageCode);
    }

    public String translateNaturalLanguageForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) throws RiceIllegalArgumentException {
        return this.getTranslateBusinessMethods().translateNaturalLanguageForProposition(naturalLanguageUsageId, proposition, languageCode);
    }

    public NaturalLanguageTree translateNaturalLanguageTreeForProposition(String naturalLanguageUsageId, PropositionDefinition propositionDefinintion, String languageCode) throws RiceIllegalArgumentException {
        return this.getTranslateBusinessMethods().translateNaturalLanguageTreeForProposition(naturalLanguageUsageId, propositionDefinintion, languageCode);
    }

    public ContextDefinition createContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        return this.contextBoService.createContext(contextDefinition);
    }

    public ContextDefinition findCreateContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        ContextDefinition orig = this.contextBoService.getContextByNameAndNamespace(contextDefinition.getName(), contextDefinition.getNamespace());
        if (orig != null) {
            return orig;
        }
        return this.contextBoService.createContext(contextDefinition);
    }

    public void updateContext(ContextDefinition contextDefinition) throws RiceIllegalArgumentException {
        this.contextBoService.updateContext(contextDefinition);
    }

    public void deleteContext(String id) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("not implemented yet");
    }

    public ContextDefinition getContext(String id) throws RiceIllegalArgumentException {
        return this.contextBoService.getContextByContextId(id);
    }

    public ContextDefinition getContextByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        return this.contextBoService.getContextByNameAndNamespace(name, namespace);
    }

    public NaturalLanguageTemplate createNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.createNaturalLanguageTemplate(naturalLanguageTemplate);
    }

    public NaturalLanguageTemplate getNaturalLanguageTemplate(String naturalLanguageTemplateId) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.getNaturalLanguageTemplate(naturalLanguageTemplateId);
    }

    public void updateNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) throws RiceIllegalArgumentException {
        this.naturalLanguageTemplateBoService.updateNaturalLanguageTemplate(naturalLanguageTemplate);
    }

    public void deleteNaturalLanguageTemplate(String naturalLanguageTemplateId) throws RiceIllegalArgumentException {
        this.naturalLanguageTemplateBoService.deleteNaturalLanguageTemplate(naturalLanguageTemplateId);
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByLanguageCode(String languageCode) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.findNaturalLanguageTemplatesByLanguageCode(languageCode);
    }

    public NaturalLanguageTemplate findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(String languageCode, String typeId, String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(languageCode, typeId, naturalLanguageUsageId);
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByNaturalLanguageUsage(String naturalLanguageUsageId) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.findNaturalLanguageTemplatesByNaturalLanguageUsage(naturalLanguageUsageId);
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByType(String typeId) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.findNaturalLanguageTemplatesByType(typeId);
    }

    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByTemplate(String template) throws RiceIllegalArgumentException {
        return this.naturalLanguageTemplateBoService.findNaturalLanguageTemplatesByTemplate(template);
    }

    public List<String> findContextIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        if (queryByCriteria == null) {
            throw new RiceIllegalArgumentException("queryByCriteria must not be null");
        }
        QueryResults results = this.getDataObjectService().findMatching(ContextBo.class, queryByCriteria);
        ArrayList<String> list = new ArrayList<String>();
        for (ContextBo bo : results.getResults()) {
            list.add(bo.getId());
        }
        return list;
    }

    public List<String> findAgendaIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        QueryResults results = this.getDataObjectService().findMatching(AgendaBo.class, queryByCriteria);
        ArrayList<String> list = new ArrayList<String>();
        for (AgendaBo bo : results.getResults()) {
            list.add(bo.getId());
        }
        return list;
    }

    public List<String> findRuleIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        QueryResults results = this.getDataObjectService().findMatching(RuleBo.class, queryByCriteria);
        ArrayList<String> list = new ArrayList<String>();
        for (RuleBo bo : results.getResults()) {
            list.add(bo.getId());
        }
        return list;
    }

    public List<String> findPropositionIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        QueryResults results = this.getDataObjectService().findMatching(PropositionBo.class, queryByCriteria);
        ArrayList<String> list = new ArrayList<String>();
        for (PropositionBo bo : results.getResults()) {
            list.add(bo.getId());
        }
        return list;
    }

    public List<String> findActionIds(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        QueryResults results = this.getDataObjectService().findMatching(ActionBo.class, queryByCriteria);
        ArrayList<String> list = new ArrayList<String>();
        for (ActionBo bo : results.getResults()) {
            list.add(bo.getId());
        }
        return list;
    }

    @Override
    public void setDataObjectService(DataObjectService dataObjectService) {
        super.setDataObjectService(dataObjectService);
        if (this.agendaBoService instanceof AgendaBoServiceImpl) {
            ((AgendaBoServiceImpl)this.agendaBoService).setDataObjectService(dataObjectService);
        }
        if (this.ruleBoService instanceof RuleBoServiceImpl) {
            ((RuleBoServiceImpl)this.ruleBoService).setDataObjectService(dataObjectService);
        }
        if (this.actionBoService instanceof ActionBoServiceImpl) {
            ((ActionBoServiceImpl)this.actionBoService).setDataObjectService(dataObjectService);
        }
        if (this.propositionBoService instanceof PropositionBoServiceImpl) {
            ((PropositionBoServiceImpl)this.propositionBoService).setDataObjectService(dataObjectService);
        }
        if (this.contextBoService instanceof ContextBoServiceImpl) {
            ((ContextBoServiceImpl)this.contextBoService).setDataObjectService(dataObjectService);
        }
        if (this.referenceObjectBindingBoService instanceof ReferenceObjectBindingBoServiceImpl) {
            ((ReferenceObjectBindingBoServiceImpl)this.referenceObjectBindingBoService).setDataObjectService(dataObjectService);
        }
        if (this.naturalLanguageUsageBoService instanceof NaturalLanguageUsageBoServiceImpl) {
            ((NaturalLanguageUsageBoServiceImpl)this.naturalLanguageUsageBoService).setDataObjectService(dataObjectService);
        }
        if (this.naturalLanguageTemplateBoService instanceof NaturalLanguageTemplateBoServiceImpl) {
            ((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoService).setDataObjectService(dataObjectService);
        }
        if (this.termRepositoryService instanceof TermBoServiceImpl) {
            ((TermBoServiceImpl)this.termRepositoryService).setDataObjectService(dataObjectService);
        }
    }
}

