/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.period;

import java.sql.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.AddBudgetPeriodAndTotalEvent;
import org.kuali.coeus.common.budget.framework.period.AddBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.period.BudgetSummaryErrorConstants;
import org.kuali.coeus.common.budget.framework.period.DeleteBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.period.GenerateBudgetPeriodEvent;
import org.kuali.coeus.common.budget.framework.period.SaveBudgetPeriodAndTotalEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.MessageMap;

@KcBusinessRule(value="budgetPeriodRule")
public class BudgetPeriodRule {
    private static final String NEW_BUDGET_PERIOD = "newBudgetPeriod";
    private static final String DEFAULT_ERROR_PATH_PREFIX = "document.budgetPeriods";
    private static final String DEFAULT_COST_LIMIT_ERROR_PATH_PREFIX = "document.budget.budgetPeriods";
    private static final String DEFAULT_NEW_BUDGET_PERIOD_ERROR_PATH_PREFIX = "newBudgetPeriod.error";
    private static final String BUDGET_PERIOD_ERROR_PATH_PREFIX = "budget.budgetPeriods";
    private ParameterService parameterService;
    private GlobalVariableService globalVariableService;

    @KcEventMethod
    public boolean processAddBudgetPeriodBusinessRules(AddBudgetPeriodEvent event) {
        Budget budget = event.getBudget();
        BudgetPeriod newBudgetPeriod = event.getBudgetPeriod();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, DEFAULT_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        }
        if (rulePassed && newBudgetPeriod != null) {
            rulePassed = this.isValidNewBudgetPeriod(budget, newBudgetPeriod, NEW_BUDGET_PERIOD);
        }
        if (rulePassed) {
            rulePassed = this.isValidToInsert(budget, newBudgetPeriod, DEFAULT_NEW_BUDGET_PERIOD_ERROR_PATH_PREFIX);
        }
        return rulePassed;
    }

    @KcEventMethod
    public boolean processAddBudgetPeriodBusinessRules(AddBudgetPeriodAndTotalEvent event) {
        BudgetPeriod newBudgetPeriod;
        Budget budget = event.getBudget();
        boolean rulePassed = this.isValidNewBudgetPeriod(budget, newBudgetPeriod = event.getBudgetPeriod(), event.getErrorPath());
        if (rulePassed) {
            rulePassed = this.isValidToInsert(budget, newBudgetPeriod, event.getErrorPath().concat("startDate"));
        }
        return rulePassed;
    }

    @KcEventMethod
    public boolean processSaveBudgetPeriodBusinessRules(AwardBudgetSaveEvent event) {
        Budget budget = event.getBudget();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, DEFAULT_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(budget, DEFAULT_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        }
        if (!budget.isProposalBudget()) {
            rulePassed &= this.isValidBudgetPeriodCostLimit(budget, DEFAULT_COST_LIMIT_ERROR_PATH_PREFIX);
        }
        return rulePassed;
    }

    @KcEventMethod
    public boolean processSaveBudgetPeriodBusinessRules(SaveBudgetPeriodAndTotalEvent event) {
        Budget budget = event.getBudget();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, event.getErrorPath())) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(budget, event.getErrorPath())) {
            rulePassed = false;
        }
        if (!budget.isProposalBudget()) {
            rulePassed &= this.isValidBudgetPeriodCostLimit(budget, event.getErrorPath());
        }
        return rulePassed;
    }

    @KcEventMethod
    public boolean processSaveBudgetPeriodBusinessRules(BudgetSaveEvent event) {
        Budget budget = event.getBudget();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, BUDGET_PERIOD_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(budget, BUDGET_PERIOD_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        }
        rulePassed = !budget.isProposalBudget() ? (rulePassed &= this.isValidBudgetPeriodCostLimit(budget, event.getErrorPath())) : (rulePassed &= this.doBudgetPeriodsCoverProposal(budget));
        return rulePassed;
    }

    @KcEventMethod
    public boolean processGenerateBudgetPeriodBusinessRules(GenerateBudgetPeriodEvent event) {
        Budget document = event.getBudget();
        BudgetPeriod newBudgetPeriod = event.getBudgetPeriod();
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        boolean rulePassed = true;
        int budgetPeriodNumber = 0;
        if (!this.isValidBudgetPeriod(document, DEFAULT_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        } else if (newBudgetPeriod != null && !this.isValidNewBudgetPeriod(document, newBudgetPeriod, NEW_BUDGET_PERIOD)) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(document, DEFAULT_ERROR_PATH_PREFIX)) {
            rulePassed = false;
        } else if (!this.getBudgetSummaryService().budgetLineItemExists(document, budgetPeriodNumber)) {
            errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
            rulePassed = false;
            this.saveErrors("ERROR_PERIOD_LINE_ITEM_DOESNOT_EXIST", errorMap, new String[0]);
        } else if (document.getBudgetPeriods().size() <= budgetPeriodNumber + 1) {
            errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
            rulePassed = false;
            this.saveErrors("ERROR_NO_FUTURE_PERIOD_TO_GENERATE", errorMap, new String[0]);
        } else {
            Object errorParam = "";
            for (int i = budgetPeriodNumber + 1; i < document.getBudgetPeriods().size(); ++i) {
                if (!this.getBudgetSummaryService().budgetLineItemExists(document, i)) continue;
                errorParam = (String)errorParam + (i + 1) + ", ";
            }
            if (((String)errorParam).length() > 0) {
                errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
                rulePassed = false;
                errorParam = ((String)errorParam).substring(0, ((String)errorParam).length() - 2);
                this.saveErrors("ERROR_GENERATE_PERIOD", errorMap, new String[]{errorParam});
            }
        }
        errorMap.removeFromErrorPath(NEW_BUDGET_PERIOD);
        return rulePassed;
    }

    @KcEventMethod
    public boolean processDeleteBudgetPeriodBusinessRules(DeleteBudgetPeriodEvent event) {
        Budget budget = event.getBudget();
        int budgetPeriodNumber = event.getBudgetPeriodNumber();
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        boolean rulePassed = true;
        if (this.getBudgetSummaryService().budgetLineItemExists(budget, budgetPeriodNumber)) {
            errorMap.addToErrorPath("document.budgetPeriods[" + budgetPeriodNumber + "]");
            rulePassed = false;
            this.saveErrors("ERROR_LINE_ITEM_EXISTS", errorMap, new String[0]);
            errorMap.removeFromErrorPath("document.budgetPeriods[" + budgetPeriodNumber + "]");
        }
        return rulePassed;
    }

    private Interval createIntervalFromPeriod(BudgetPeriod budgetPeriod) {
        DateTime startDate = new DateTime(budgetPeriod.getStartDate().getTime());
        DateTime endDate = new DateTime(budgetPeriod.getEndDate().getTime()).plusDays(1);
        return new Interval((ReadableInstant)startDate, (ReadableInstant)endDate);
    }

    protected boolean doBudgetPeriodsCoverProposal(Budget budget) {
        if (CollectionUtils.isEmpty(budget.getBudgetPeriods())) {
            return false;
        }
        List sortedBudgetPeriods = budget.getBudgetPeriods().stream().sorted((period1, period2) -> period1.getStartDate().compareTo(period2.getStartDate())).collect(Collectors.toList());
        int nextIndex = 1;
        for (BudgetPeriod currentBudgetPeriod : sortedBudgetPeriods) {
            if (nextIndex < budget.getBudgetPeriods().size()) {
                Interval nextPeriodInterval;
                BudgetPeriod nextBudgetPeriod = (BudgetPeriod)sortedBudgetPeriods.get(nextIndex);
                Interval currentPeriodInterval = this.createIntervalFromPeriod(currentBudgetPeriod);
                if (!currentPeriodInterval.abuts((ReadableInterval)(nextPeriodInterval = this.createIntervalFromPeriod(nextBudgetPeriod)))) {
                    this.saveErrors("ERROR_PERIOD_GAPS", this.getGlobalVariableService().getMessageMap(), new String[0]);
                    return false;
                }
            }
            ++nextIndex;
        }
        return true;
    }

    private boolean isValidBudgetPeriodBoundaries(Budget budget, String errorPathPrefix) {
        boolean validBoundaries = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            String[] dateParams = new String[]{"" + budgetPeriod.getBudgetPeriod()};
            Integer budgetPeriodNumber = budgetPeriod.getBudgetPeriod();
            int index = budgetPeriodNumber - 1;
            errorMap.addToErrorPath(errorPathPrefix + "[" + index + "]");
            List<BudgetLineItem> periodLineItems = budgetPeriod.getBudgetLineItems();
            block1: for (BudgetLineItem periodLineItem : periodLineItems) {
                if (budgetPeriod.getBudgetPeriod() == periodLineItem.getBudgetPeriod() && (periodLineItem.getStartDate().before(budgetPeriod.getStartDate()) || periodLineItem.getStartDate().after(budgetPeriod.getEndDate()) || periodLineItem.getEndDate().after(budgetPeriod.getEndDate()) || periodLineItem.getEndDate().before(budgetPeriod.getStartDate()))) {
                    this.saveErrors("ERROR_LINE_ITEM_DATE_DOESNOTMATCH", errorMap, dateParams);
                    validBoundaries = false;
                    break;
                }
                List<BudgetPersonnelDetails> periodPersonnelDetails = periodLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails periodPersonnelDetail : periodPersonnelDetails) {
                    if (budgetPeriod.getBudgetPeriod() != periodPersonnelDetail.getBudgetPeriod() || !periodPersonnelDetail.getStartDate().before(budgetPeriod.getStartDate()) && !periodPersonnelDetail.getStartDate().after(budgetPeriod.getEndDate()) && !periodPersonnelDetail.getEndDate().after(budgetPeriod.getEndDate()) && !periodPersonnelDetail.getEndDate().before(budgetPeriod.getStartDate())) continue;
                    this.saveErrors("ERROR_LINE_ITEM_DATE_DOESNOTMATCH", errorMap, dateParams);
                    validBoundaries = false;
                    break block1;
                }
            }
            errorMap.removeFromErrorPath(errorPathPrefix + "[" + index + "]");
        }
        return validBoundaries;
    }

    private boolean isValidBudgetPeriodCostLimit(Budget budget, String errorPathPrefix) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        int i = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (((AwardBudgetExt)budget).getObligatedTotal().isPositive() && budgetPeriod.getTotalCostLimit().isGreaterThan((AbstractDecimal)((AwardBudgetExt)budget).getObligatedTotal())) {
                this.getGlobalVariableService().getMessageMap().putError(errorPathPrefix + "[" + i + "].totalCostLimit", "error.period.costlimit.exceed.obligatedtotal", new String[0]);
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private boolean isValidNewBudgetPeriod(Budget budget, BudgetPeriod newBudgetPeriod, String errorPathPrefix) {
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        boolean validNewBudgetPeriod = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        Date previousPeriodStartDate = null;
        java.util.Date previousPeriodEndDate = null;
        Date periodStartDate = null;
        Date periodEndDate = null;
        Date newPeriodStartDate = null;
        Date newPeriodEndDate = null;
        int index = 0;
        newPeriodStartDate = newBudgetPeriod.getStartDate();
        newPeriodEndDate = newBudgetPeriod.getEndDate();
        errorMap.addToErrorPath(errorPathPrefix);
        if (newPeriodStartDate == null) {
            this.saveErrors("ERROR_PERIOD_START_REQUIRED", errorMap, new String[0]);
            validNewBudgetPeriod = false;
        }
        if (newPeriodEndDate == null) {
            this.saveErrors("ERROR_PERIOD_END_REQUIRED", errorMap, new String[0]);
            validNewBudgetPeriod = false;
        }
        errorMap.removeFromErrorPath(errorPathPrefix);
        if (CollectionUtils.isEmpty(budgetPeriods)) {
            newBudgetPeriod.setBudgetPeriod(1);
        }
        if (validNewBudgetPeriod) {
            int totalBudgetPeriods = budgetPeriods.size() - 1;
            errorMap.addToErrorPath(errorPathPrefix);
            for (BudgetPeriod budgetPeriod : budgetPeriods) {
                periodStartDate = budgetPeriod.getStartDate();
                periodEndDate = budgetPeriod.getEndDate();
                String dateCompareValue = null;
                java.util.Date validDateBefore = previousPeriodStartDate == null ? budget.getStartDate() : previousPeriodEndDate;
                int periodNum = index;
                String[] newPeriodDateParams = new String[]{"" + periodNum, "" + (periodNum + 1)};
                String invalidErrorMessage = null;
                invalidErrorMessage = index == 0 || index == totalBudgetPeriods ? "ERROR_NEW_PERIOD_INVALID" : "ERROR_NEW_PERIOD_VALID";
                if (newPeriodStartDate.compareTo(periodStartDate) == 0 || newPeriodEndDate.compareTo(periodEndDate) == 0) {
                    this.saveErrors(invalidErrorMessage, errorMap, newPeriodDateParams);
                    validNewBudgetPeriod = false;
                    break;
                }
                if (newPeriodStartDate.before(periodStartDate) || index == totalBudgetPeriods && newPeriodStartDate.after(periodEndDate)) {
                    boolean lastRecord = false;
                    if (index == totalBudgetPeriods) {
                        lastRecord = true;
                        if (newPeriodStartDate.after(periodEndDate)) {
                            periodNum = index + 1;
                        }
                    }
                    if (newPeriodStartDate.before(budget.getStartDate())) {
                        dateCompareValue = "ERROR_PERIOD_START_BEFORE_PROJECT_START";
                    } else if (newPeriodStartDate.after(budget.getEndDate())) {
                        dateCompareValue = "ERROR_NEW_PERIOD_START_AFTER_PROJECT_END";
                    } else if (newPeriodEndDate.after(budget.getEndDate())) {
                        dateCompareValue = "ERROR_NEW_PERIOD_END_DATE";
                    } else if (newPeriodStartDate.before(validDateBefore)) {
                        dateCompareValue = invalidErrorMessage;
                    } else if (index < totalBudgetPeriods && newPeriodEndDate.after(periodStartDate)) {
                        dateCompareValue = !lastRecord ? invalidErrorMessage : "ERROR_NEW_PERIOD_PROJECT_END";
                    }
                    if (dateCompareValue != null) {
                        this.saveErrors(dateCompareValue, errorMap, newPeriodDateParams);
                        validNewBudgetPeriod = false;
                        break;
                    }
                    newBudgetPeriod.setBudgetPeriod(periodNum + 1);
                    break;
                }
                if (newPeriodStartDate.compareTo(periodEndDate) <= 0) {
                    dateCompareValue = "ERROR_NEW_PERIOD_START_BEFORE_PREVIOUS_END";
                    this.saveErrors(dateCompareValue, errorMap, newPeriodDateParams);
                    validNewBudgetPeriod = false;
                    break;
                }
                previousPeriodStartDate = budgetPeriod.getStartDate();
                previousPeriodEndDate = budgetPeriod.getEndDate();
                ++index;
            }
            errorMap.removeFromErrorPath(errorPathPrefix);
        }
        return validNewBudgetPeriod;
    }

    private boolean isValidBudgetPeriod(Budget budget, String errorPathPrefix) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        boolean validBudgetPeriod = true;
        Date previousPeriodStartDate = null;
        java.util.Date previousPeriodEndDate = null;
        Date periodStartDate = null;
        Date periodEndDate = null;
        int index = 0;
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            errorMap.addToErrorPath(errorPathPrefix + "[" + index + "]");
            periodStartDate = budgetPeriod.getStartDate();
            periodEndDate = budgetPeriod.getEndDate();
            boolean isDateNull = false;
            String[] dateParams = new String[]{"" + (index + 1)};
            if (periodStartDate == null) {
                this.saveErrors("ERROR_PERIOD_START_REQUIRED", errorMap, dateParams);
                validBudgetPeriod = false;
                isDateNull = true;
            }
            if (periodEndDate == null) {
                this.saveErrors("ERROR_PERIOD_END_REQUIRED", errorMap, dateParams);
                validBudgetPeriod = false;
                isDateNull = true;
            }
            if (!isDateNull) {
                java.util.Date validDateBefore = previousPeriodStartDate == null ? budget.getStartDate() : previousPeriodEndDate;
                String dateCompareValue = this.compareDate(budget, periodStartDate, periodEndDate, (Date)previousPeriodEndDate);
                if (dateCompareValue != null) {
                    this.saveErrors(dateCompareValue, errorMap, dateParams);
                    validBudgetPeriod = false;
                }
                errorMap.removeFromErrorPath(errorPathPrefix + "[" + index + "]");
            }
            previousPeriodStartDate = budgetPeriod.getStartDate();
            previousPeriodEndDate = budgetPeriod.getEndDate();
            ++index;
        }
        return validBudgetPeriod;
    }

    private void saveErrors(String errorValue, MessageMap errorMap, String ... parameters) {
        BudgetSummaryErrorConstants budgetSummaryErrorConstants = BudgetSummaryErrorConstants.valueOf(errorValue);
        String errorKey = budgetSummaryErrorConstants.errorKey();
        String errorProperty = budgetSummaryErrorConstants.errorProperty();
        errorMap.putError(errorProperty, errorKey, parameters);
    }

    private String compareDate(Budget budget, Date periodStartDate, Date periodEndDate, Date previousPeriodEndDate) {
        String returnErrorValue = null;
        Date budgetEndDate = new Date(budget.getBudgetEndDate().getTime());
        Date budgetStartDate = new Date(budget.getBudgetStartDate().getTime());
        if (periodStartDate.after(budgetEndDate)) {
            returnErrorValue = "ERROR_PERIOD_START_AFTER_PROJECT_END";
        } else if (periodStartDate.before(budgetStartDate)) {
            returnErrorValue = "ERROR_PERIOD_START_BEFORE_PROJECT_START";
        } else if (periodEndDate.before(budget.getStartDate())) {
            returnErrorValue = "ERROR_PERIOD_END_BEFORE_PROJECT_START";
        } else if (periodEndDate.after(budgetEndDate)) {
            returnErrorValue = "ERROR_PERIOD_END_AFTER_PROJECT_END";
        } else if (periodStartDate.after(periodEndDate)) {
            returnErrorValue = "ERROR_PERIOD_START_AFTER_PERIOD_END";
        } else if (previousPeriodEndDate != null && !periodStartDate.after(previousPeriodEndDate)) {
            returnErrorValue = "ERROR_PERIOD_START_BEFORE_PREVIOUS_END";
        } else if (previousPeriodEndDate != null && !periodEndDate.after(previousPeriodEndDate)) {
            returnErrorValue = "ERROR_PERIOD_END_BEFORE_PREVIOUS_END";
        }
        return returnErrorValue;
    }

    private BudgetSummaryService getBudgetSummaryService() {
        return KcServiceLocator.getService(BudgetSummaryService.class);
    }

    private boolean isValidToInsert(Budget budget, BudgetPeriod newBudgetPeriod, String errorPathPrefix) {
        int expenseExistStatus = this.checkExpenseInBudget(budget);
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        if (CollectionUtils.isNotEmpty(budget.getBudgetPeriods())) {
            if (newBudgetPeriod.getEndDate().before(budget.getBudgetPeriod(0).getStartDate())) {
                if (expenseExistStatus >= 1) {
                    errorMap.putError(errorPathPrefix, "error.insert.budget.period", new String[0]);
                    return false;
                }
            } else if (newBudgetPeriod.getEndDate().before(budget.getBudgetPeriod(budget.getBudgetPeriods().size() - 1).getStartDate()) && expenseExistStatus > 1) {
                errorMap.putError(errorPathPrefix, "error.insert.budget.period", new String[0]);
                return false;
            }
        }
        return true;
    }

    private int checkExpenseInBudget(Budget budget) {
        int retVal = 0;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!CollectionUtils.isNotEmpty(budgetPeriod.getBudgetLineItems())) continue;
            retVal = budgetPeriod.getBudgetPeriod();
        }
        return retVal;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

