/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.proposal.impl.report;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.CurrentReportBean;
import org.kuali.coeus.common.framework.print.PendingReportBean;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.PrintingService;
import org.kuali.coeus.common.proposal.framework.report.CurrentAndPendingReportService;
import org.kuali.coeus.common.proposal.impl.report.CurrentProposalPrint;
import org.kuali.coeus.common.proposal.impl.report.CurrentReportDao;
import org.kuali.coeus.common.proposal.impl.report.PendingProposalPrint;
import org.kuali.coeus.common.proposal.impl.report.PendingReportDao;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component(value="currentAndPendingReportService")
@Scope(value="prototype")
public class CurrentAndPendingReportServiceImpl
implements CurrentAndPendingReportService {
    @Autowired
    @Qualifier(value="currentReportDao")
    private CurrentReportDao currentReportDao;
    @Autowired
    @Qualifier(value="pendingReportDao")
    private PendingReportDao pendingReportDao;
    @Autowired
    @Qualifier(value="printingService")
    private PrintingService printingService;
    @Autowired
    @Qualifier(value="currentProposalPrint")
    private CurrentProposalPrint currentProposalPrint;
    @Autowired
    @Qualifier(value="pendingProposalPrint")
    private PendingProposalPrint pendingProposalPrint;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public void setCurrentReportDao(CurrentReportDao currentReportDao) {
        this.currentReportDao = currentReportDao;
    }

    public void setPendingReportDao(PendingReportDao pendingReportDao) {
        this.pendingReportDao = pendingReportDao;
    }

    public void setCurrentProposalPrint(CurrentProposalPrint currentProposalPrint) {
        this.currentProposalPrint = currentProposalPrint;
    }

    public void setPendingProposalPrint(PendingProposalPrint pendingProposalPrint) {
        this.pendingProposalPrint = pendingProposalPrint;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    @Override
    public List<CurrentReportBean> loadCurrentReportData(String personId) {
        List<CurrentReportBean> data;
        try {
            data = this.currentReportDao.queryForCurrentSupport(personId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public List<PendingReportBean> loadPendingReportData(String personId) {
        List<PendingReportBean> data;
        try {
            Collection excludedProposalTypes = this.getParameterService().getParameterValuesAsString(InstitutionalProposalDocument.class, "Excluded_Codes_CP_Report");
            Collection excludedProposalStatuses = this.getParameterService().getParameterValuesAsString(InstitutionalProposalDocument.class, "Excluded_IPStatuses_CP_Pending");
            data = this.pendingReportDao.queryForPendingSupport(personId, excludedProposalTypes, excludedProposalStatuses);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public AttachmentDataSource printCurrentReport(Map<String, Object> reportParameters) throws PrintingException {
        reportParameters.put("Current Report Beans", this.loadCurrentReportData((String)reportParameters.get("personId")));
        CurrentProposalPrint printable = this.currentProposalPrint;
        printable.setPrintableBusinessObject(null);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.printingService.print(printable);
        source.setName("Current Report".replace(' ', '_') + ".pdf");
        return source;
    }

    @Override
    public AttachmentDataSource printPendingReport(Map<String, Object> reportParameters) throws PrintingException {
        reportParameters.put("Pending Report Beans", this.loadPendingReportData((String)reportParameters.get("personId")));
        PendingProposalPrint printable = this.pendingProposalPrint;
        printable.setPrintableBusinessObject(null);
        printable.setReportParameters(reportParameters);
        AttachmentDataSource source = this.printingService.print(printable);
        source.setName("Pending Report".replace(' ', '_') + ".pdf");
        return source;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }
}

