/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.attachment;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.propdev.api.person.attachment.ProposalPersonBiographyContract;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentAttachment;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.attachment.PropPerDocType;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyAttachment;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.file.FileMeta;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="EPS_PROP_PERSON_BIO")
@IdClass(value=ProposalPersonBiographyId.class)
public class ProposalPersonBiography
extends KcPersistableBusinessObjectBase
implements ProposalPersonBiographyContract,
KcFile,
FileMeta,
ProposalDevelopmentAttachment {
    @Id
    @Column(name="PROP_PERSON_NUMBER")
    private Integer proposalPersonNumber;
    @Column(name="PERSON_ID")
    private String personId;
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @Id
    @Column(name="BIO_NUMBER")
    private Integer biographyNumber;
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="DOCUMENT_TYPE_CODE")
    private String documentTypeCode;
    @Column(name="FILE_NAME")
    private String name;
    @Column(name="CONTENT_TYPE")
    private String type;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="DOCUMENT_TYPE_CODE", referencedColumnName="DOCUMENT_TYPE_CODE", insertable=false, updatable=false)
    private PropPerDocType propPerDocType;
    @OneToOne(mappedBy="proposalPersonBiography", cascade={CascadeType.ALL})
    private ProposalPersonBiographyAttachment personnelAttachment;
    @Transient
    private String proposalPersonNumberString;
    @Transient
    private String uploadUserFullName;
    @Transient
    private transient int positionNumber;
    @Transient
    private String id;
    @Transient
    private Long size;
    @Transient
    private Date dateUploaded;
    @Transient
    private String url;
    @Transient
    private transient DateTimeService dateTimeService;
    @Transient
    private transient KcAttachmentService kcAttachmentService;
    @Transient
    private transient MultipartFile multipartFile;

    public void init(MultipartFile multipartFile) throws Exception {
        this.name = multipartFile.getOriginalFilename();
        this.size = multipartFile.getSize();
        ProposalPersonBiographyAttachment attachment = new ProposalPersonBiographyAttachment();
        attachment.setType(multipartFile.getContentType());
        attachment.setData(multipartFile.getBytes());
        attachment.setName(multipartFile.getOriginalFilename());
        this.setPersonnelAttachment(attachment);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContentType() {
        if (this.personnelAttachment != null) {
            return this.getPersonnelAttachment().getType();
        }
        return null;
    }

    public void setContentType(String contentType) {
        if (this.personnelAttachment != null) {
            this.getPersonnelAttachment().setType(contentType);
        }
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getDateUploaded() {
        return this.dateUploaded;
    }

    public void setDateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSizeFormatted() {
        return this.getKcAttachmentService().formatFileSizeString(this.size);
    }

    public String getDateUploadedFormatted() {
        if (this.getUpdateTimestamp() != null) {
            return this.getDateTimeService().toString(new Date(this.getUpdateTimestamp().getTime()), "MM/dd/yyyy hh:mm a");
        }
        return "";
    }

    @Override
    public MultipartFile getMultipartFile() {
        return this.multipartFile;
    }

    @Override
    public void setMultipartFile(MultipartFile multipartFile) {
        this.multipartFile = multipartFile;
    }

    public Integer getProposalPersonNumber() {
        return this.proposalPersonNumber;
    }

    public void setProposalPersonNumber(Integer proposalPersonNumber) {
        this.proposalPersonNumber = proposalPersonNumber;
        this.proposalPersonNumberString = proposalPersonNumber != null ? proposalPersonNumber.toString() : null;
    }

    public String getProposalPersonNumberString() {
        if (this.proposalPersonNumberString == null && this.proposalPersonNumber != null) {
            return this.proposalPersonNumber.toString();
        }
        return this.proposalPersonNumberString;
    }

    public void setProposalPersonNumberString(String proposalPersonNumberString) {
        this.proposalPersonNumberString = proposalPersonNumberString;
        this.proposalPersonNumber = proposalPersonNumberString != null ? Integer.valueOf(Integer.parseInt(proposalPersonNumberString)) : null;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    public void setProposalNumber(String proposalNumber) {
        this.getDevelopmentProposal().setProposalNumber(proposalNumber);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocumentTypeCode() {
        return this.documentTypeCode;
    }

    public void setDocumentTypeCode(String documentTypeCode) {
        this.documentTypeCode = documentTypeCode;
    }

    public ProposalPersonBiographyAttachment getPersonnelAttachment() {
        return this.personnelAttachment;
    }

    public void setPersonnelAttachment(ProposalPersonBiographyAttachment personnelAttachment) {
        this.personnelAttachment = personnelAttachment;
        if (personnelAttachment != null) {
            this.personnelAttachment.setProposalPersonBiography(this);
        }
    }

    public PropPerDocType getPropPerDocType() {
        return this.propPerDocType;
    }

    public void setPropPerDocType(PropPerDocType propPerDocType) {
        this.propPerDocType = propPerDocType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Integer getBiographyNumber() {
        return this.biographyNumber;
    }

    public void setBiographyNumber(Integer biographyNumber) {
        this.biographyNumber = biographyNumber;
    }

    public Timestamp getTimestampDisplay() {
        if (this.getPersonnelAttachment() == null || this.getPersonnelAttachment().getUploadTimestamp() == null) {
            return this.getDateTimeService().getCurrentTimestamp();
        }
        return this.getPersonnelAttachment().getUploadTimestamp();
    }

    @Override
    public String getUploadUserDisplay() {
        if (this.getPersonnelAttachment() == null || StringUtils.isBlank((CharSequence)this.getPersonnelAttachment().getUploadUser())) {
            return this.getUpdateUser();
        }
        return this.getPersonnelAttachment().getUploadUser();
    }

    public String getUploadUserFullName() {
        return this.uploadUserFullName;
    }

    public void setUploadUserFullName(String uploadUserFullName) {
        this.uploadUserFullName = uploadUserFullName;
    }

    public String getType() {
        return this.getContentType();
    }

    public void setType(String type) {
        this.type = type;
    }

    public byte[] getData() {
        if (this.getPersonnelAttachment() == null) {
            return null;
        }
        return this.getPersonnelAttachment().getData();
    }

    public int getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(int positionNumber) {
        this.positionNumber = positionNumber;
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }

    @PostRemove
    public void removeData() {
        if (this.getPersonnelAttachment() != null && this.getPersonnelAttachment().getFileDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getPersonnelAttachment().getFileDataId());
        }
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    public static final class ProposalPersonBiographyId
    implements Serializable,
    Comparable<ProposalPersonBiographyId> {
        private Integer proposalPersonNumber;
        private Integer biographyNumber;
        private String developmentProposal;

        public ProposalPersonBiographyId(Integer proposalPersonNumber, Integer biographyNumber, String developmentProposal) {
            this.proposalPersonNumber = proposalPersonNumber;
            this.biographyNumber = biographyNumber;
            this.developmentProposal = developmentProposal;
        }

        public Integer getProposalPersonNumber() {
            return this.proposalPersonNumber;
        }

        public void setProposalPersonNumber(Integer proposalPersonNumber) {
            this.proposalPersonNumber = proposalPersonNumber;
        }

        public Integer getBiographyNumber() {
            return this.biographyNumber;
        }

        public void setBiographyNumber(Integer biographyNumber) {
            this.biographyNumber = biographyNumber;
        }

        public String getDevelopmentProposal() {
            return this.developmentProposal;
        }

        public void setDevelopmentProposal(String developmentProposal) {
            this.developmentProposal = developmentProposal;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPersonNumber", (Object)this.proposalPersonNumber).append("biographyNumber", (Object)this.biographyNumber).append("developmentProposal", (Object)this.developmentProposal).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonBiographyId rhs = (ProposalPersonBiographyId)other;
            return new EqualsBuilder().append((Object)this.proposalPersonNumber, (Object)rhs.proposalPersonNumber).append((Object)this.biographyNumber, (Object)rhs.biographyNumber).append((Object)this.developmentProposal, (Object)rhs.developmentProposal).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPersonNumber).append((Object)this.biographyNumber).append((Object)this.developmentProposal).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonBiographyId other) {
            return new CompareToBuilder().append((Object)this.proposalPersonNumber, (Object)other.proposalPersonNumber).append((Object)this.biographyNumber, (Object)other.biographyNumber).append((Object)this.developmentProposal, (Object)other.developmentProposal).toComparison();
        }
    }
}

