/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.api.messaging.AsynchronousCallback;
import org.kuali.rice.ksb.messaging.GlobalCallbackRegistry;
import org.kuali.rice.ksb.messaging.MessageProcessingException;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class MessageServiceInvoker
implements Runnable {
    protected static final Logger LOG = LogManager.getLogger(MessageServiceInvoker.class);
    private PersistedMessageBO message;
    private Object service;
    private AsynchronousCall methodCall;

    public MessageServiceInvoker(PersistedMessageBO message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PersistedMessagePayload messageFromDB;
        LOG.debug("calling service from persisted message " + this.getMessage().getRouteQueueId());
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("message.persistence").booleanValue() && (messageFromDB = KSBServiceLocator.getMessageQueueService().findByPersistedMessageByRouteQueueId(this.getMessage().getRouteQueueId())) == null) {
            return;
        }
        Object result = null;
        try {
            result = KSBServiceLocator.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    AsynchronousCall methodCall = MessageServiceInvoker.this.getMessage().getPayload().getMethodCall();
                    Object result = null;
                    try {
                        result = MessageServiceInvoker.this.invokeService(methodCall);
                        KSBServiceLocator.getMessageQueueService().delete(MessageServiceInvoker.this.getMessage());
                    }
                    catch (Throwable t) {
                        LOG.warn("Caught throwable making async service call " + methodCall, t);
                        throw new MessageProcessingException(t);
                    }
                    return result;
                }
            });
        }
        catch (Throwable t) {
            boolean allowSyncExceptionRouting = new Boolean(ConfigContext.getCurrentContextConfig().getProperty("rice.ksb.allowSyncExceptionRouting"));
            if (!allowSyncExceptionRouting && "synchronous".equals(ConfigContext.getCurrentContextConfig().getProperty("message.delivery"))) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RiceRuntimeException(t);
            }
            this.placeInExceptionRouting(t, this.getMethodCall(), this.getService());
        }
        finally {
            try {
                this.notifyOnCallback(this.methodCall, result);
            }
            catch (Exception e) {
                LOG.warn("Exception caught notifying callback", (Throwable)e);
            }
            try {
                this.notifyGlobalCallbacks(this.methodCall, result);
            }
            catch (Exception e) {
                LOG.warn("Exception caught notifying callback", (Throwable)e);
            }
        }
    }

    protected void placeInExceptionRouting(Throwable t, AsynchronousCall call, Object service) {
        LOG.error("Error processing message: " + this.message, t);
        Throwable throwable = t instanceof MessageProcessingException ? t.getCause() : t;
        try {
            try {
                KSBServiceLocator.getExceptionRoutingService().placeInExceptionRouting(throwable, this.message, service);
            }
            catch (Throwable t1) {
                KSBServiceLocator.getExceptionRoutingService().placeInExceptionRoutingLastDitchEffort(throwable, this.message, service);
            }
        }
        catch (Throwable t2) {
            LOG.error("An error was encountered when invoking exception handler for message. Attempting to change message status to EXCEPTION.", t2);
            this.message.setQueueStatus("E");
            this.message.setQueueDate(new Timestamp(System.currentTimeMillis()));
            try {
                this.message = KSBServiceLocator.getMessageQueueService().save(this.message);
            }
            catch (Throwable t3) {
                LOG.fatal("Failed to flip status of message to EXCEPTION!!!", t3);
            }
        }
    }

    protected Object invokeService(AsynchronousCall methodCall) throws Exception {
        Object service;
        this.methodCall = methodCall;
        ServiceConfiguration serviceConfiguration = methodCall.getServiceConfiguration();
        QName serviceName = serviceConfiguration.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to call service " + serviceName);
        }
        if ((service = this.getService(serviceConfiguration)) == null) {
            throw new RiceRuntimeException("Failed to locate service endpoint for message: " + serviceConfiguration);
        }
        Method method = service.getClass().getMethod(methodCall.getMethodName(), methodCall.getParamTypes());
        return method.invoke(service, methodCall.getArguments());
    }

    protected Object getService(ServiceConfiguration serviceConfiguration) {
        Object service = serviceConfiguration.isQueue() ? this.getQueueService(serviceConfiguration) : this.getTopicService(serviceConfiguration);
        return service;
    }

    protected Object getTopicService(ServiceConfiguration serviceConfiguration) {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        Endpoint endpoint = serviceBus.getConfiguredEndpoint(serviceConfiguration);
        if (endpoint == null) {
            return null;
        }
        return endpoint.getService();
    }

    protected Object getQueueService(ServiceConfiguration serviceConfiguration) {
        ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
        return serviceBus.getService(serviceConfiguration.getServiceName(), serviceConfiguration.getApplicationId());
    }

    protected void notifyOnCallback(AsynchronousCall methodCall, Object callResult) {
        AsynchronousCallback callback = methodCall.getCallback();
        this.notifyOnCallback(methodCall, callback, callResult);
    }

    protected void notifyGlobalCallbacks(AsynchronousCall methodCall, Object callResult) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notifying global callbacks");
        }
        for (AsynchronousCallback globalCallBack : GlobalCallbackRegistry.getCallbacks()) {
            this.notifyOnCallback(methodCall, globalCallBack, callResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOnCallback(AsynchronousCall methodCall, AsynchronousCallback callback, Object callResult) {
        if (callback != null) {
            try {
                AsynchronousCallback asynchronousCallback = callback;
                synchronized (asynchronousCallback) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Notifying callback " + callback + " with callResult " + callResult);
                    }
                    callback.notifyAll();
                    if (callResult instanceof Serializable || callResult == null) {
                        callback.callback((Serializable)callResult, methodCall);
                    } else {
                        LOG.warn("Attempted to call callback with non-serializable object.");
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Caught throwable from callback object " + callback.getClass(), t);
            }
        }
    }

    public PersistedMessageBO getMessage() {
        return this.message;
    }

    public void setMessage(PersistedMessageBO message) {
        this.message = message;
    }

    public Object getService() {
        return this.service;
    }

    public AsynchronousCall getMethodCall() {
        return this.methodCall;
    }

    public void setMethodCall(AsynchronousCall methodCall) {
        this.methodCall = methodCall;
    }

    public void setService(Object service) {
        this.service = service;
    }
}

