/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.impex.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.impex.xml.XmlExporterService;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.core.framework.impex.xml.XmlImpexRegistry;
import org.kuali.rice.kew.api.WorkflowRuntimeException;

public class XmlExporterServiceImpl
implements XmlExporterService {
    private XmlImpexRegistry xmlImpexRegistry;

    public byte[] export(ExportDataSet dataSet) {
        Format f;
        if (dataSet == null) {
            throw new IllegalArgumentException("Xml Exporter cannot handle NULL data.");
        }
        Element rootElement = new Element("data", XmlConstants.WORKFLOW_NAMESPACE);
        rootElement.addNamespaceDeclaration(XmlConstants.SCHEMA_NAMESPACE);
        rootElement.setAttribute("schemaLocation", "ns:workflow resource:WorkflowData", XmlConstants.SCHEMA_NAMESPACE);
        Document document = new Document(rootElement);
        boolean shouldPrettyPrint = true;
        for (XmlExporter exporter : this.xmlImpexRegistry.getExporters()) {
            Element exportedElement = exporter.export(dataSet);
            if (exportedElement == null) continue;
            if (!exporter.supportPrettyPrint()) {
                shouldPrettyPrint = false;
            }
            this.appendIfNotEmpty(rootElement, exportedElement);
        }
        if (!shouldPrettyPrint) {
            f = Format.getRawFormat();
            f.setExpandEmptyElements(false);
            f.setTextMode(Format.TextMode.PRESERVE);
        } else {
            f = Format.getPrettyFormat();
        }
        XMLOutputter outputer = new XMLOutputter(f);
        StringWriter writer = new StringWriter();
        try {
            outputer.output(document, (Writer)writer);
        }
        catch (IOException e) {
            throw new WorkflowRuntimeException("Could not write XML data export.", (Throwable)e);
        }
        return writer.toString().getBytes();
    }

    private void appendIfNotEmpty(Element parent, Element child) {
        if (child != null) {
            parent.addContent((Content)child);
        }
    }

    public void setXmlImpexRegistry(XmlImpexRegistry xmlImpexRegistry) {
        this.xmlImpexRegistry = xmlImpexRegistry;
    }
}

