/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;
import org.springframework.util.StringUtils;

public class ShadowingInstrumentableClassLoader
extends DecoratingClassLoader {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"java.", "javax.", "sun.", "oracle.", "com.sun.", "com.ibm.", "COM.ibm.", "org.w3c.", "org.xml.", "org.dom4j.", "org.eclipse", "org.aspectj.", "net.sf.cglib", "org.springframework.cglib", "org.apache.xerces.", "org.apache.commons.logging."};
    private final ClassLoader enclosingClassLoader;
    private final WeavingTransformer weavingTransformer;
    private final Map<String, Class<?>> classCache = new HashMap();
    private final Set<String> attempted = new HashSet<String>();

    public ShadowingInstrumentableClassLoader(ClassLoader enclosingClassLoader) {
        this(enclosingClassLoader, null);
    }

    public ShadowingInstrumentableClassLoader(ClassLoader enclosingClassLoader, String[] excludedPackages) {
        if (enclosingClassLoader == null) {
            throw new IllegalArgumentException("Enclosing ClassLoader must not be null");
        }
        this.weavingTransformer = new WeavingTransformer((ClassLoader)((Object)this));
        this.enclosingClassLoader = enclosingClassLoader;
        for (String defaultExcludedPackage : DEFAULT_EXCLUDES) {
            this.excludePackage(defaultExcludedPackage);
        }
        if (excludedPackages != null) {
            for (String excludedPackage : excludedPackages) {
                this.excludePackage(excludedPackage);
            }
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.classCache.get(name);
        if (cls != null) {
            return cls;
        }
        if (!this.attempted.contains(name) && this.shouldInstrument(name)) {
            return this.loadAndInstrumentClass(name);
        }
        return this.enclosingClassLoader.loadClass(name);
    }

    private boolean shouldInstrument(String className) {
        return !className.equals(((Object)((Object)this)).getClass().getName()) && !this.isExcluded(className);
    }

    private Class<?> loadAndInstrumentClass(String name) throws ClassNotFoundException {
        int packageSeparator;
        byte[] bytes;
        String internalName = StringUtils.replace((String)name, (String)".", (String)"/") + ".class";
        this.attempted.add(name);
        this.attempted.add(internalName);
        InputStream is = this.enclosingClassLoader.getResourceAsStream(internalName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            bytes = ByteStreams.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", e);
        }
        finally {
            Closeables.closeQuietly((InputStream)is);
        }
        bytes = this.weavingTransformer.transformIfNecessary(name, bytes);
        Class cls = this.defineClass(name, bytes, 0, bytes.length);
        if (cls.getPackage() == null && (packageSeparator = name.lastIndexOf(46)) != -1) {
            String packageName = name.substring(0, packageSeparator);
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        this.classCache.put(name, cls);
        return cls;
    }

    public URL getResource(String name) {
        return this.enclosingClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.enclosingClassLoader.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.enclosingClassLoader.getResources(name);
    }
}

