/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.elasticsearch.common.geo.parsers.GeoWKTParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoExecType;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;

public class GeoBoundingBoxQueryBuilder
extends AbstractQueryBuilder<GeoBoundingBoxQueryBuilder> {
    public static final String NAME = "geo_bounding_box";
    public static final GeoExecType DEFAULT_TYPE = GeoExecType.MEMORY;
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(GeoBoundingBoxQueryBuilder.class));
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField TOP_FIELD = new ParseField("top", new String[0]);
    private static final ParseField BOTTOM_FIELD = new ParseField("bottom", new String[0]);
    private static final ParseField LEFT_FIELD = new ParseField("left", new String[0]);
    private static final ParseField RIGHT_FIELD = new ParseField("right", new String[0]);
    private static final ParseField TOP_LEFT_FIELD = new ParseField("top_left", new String[0]);
    private static final ParseField BOTTOM_RIGHT_FIELD = new ParseField("bottom_right", new String[0]);
    private static final ParseField TOP_RIGHT_FIELD = new ParseField("top_right", new String[0]);
    private static final ParseField BOTTOM_LEFT_FIELD = new ParseField("bottom_left", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private static final ParseField WKT_FIELD = new ParseField("wkt", new String[0]);
    private final String fieldName;
    private GeoPoint topLeft = new GeoPoint(Double.NaN, Double.NaN);
    private GeoPoint bottomRight = new GeoPoint(Double.NaN, Double.NaN);
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private GeoExecType type = DEFAULT_TYPE;
    private boolean ignoreUnmapped = false;

    public GeoBoundingBoxQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoBoundingBoxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.topLeft = in.readGeoPoint();
        this.bottomRight = in.readGeoPoint();
        this.type = GeoExecType.readFromStream(in);
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGeoPoint(this.topLeft);
        out.writeGeoPoint(this.bottomRight);
        this.type.writeTo(out);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoBoundingBoxQueryBuilder setCorners(double top, double left, double bottom, double right) {
        if (!GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            if (!Numbers.isValidDouble(top)) {
                throw new IllegalArgumentException("top latitude is invalid: " + top);
            }
            if (!Numbers.isValidDouble(left)) {
                throw new IllegalArgumentException("left longitude is invalid: " + left);
            }
            if (!Numbers.isValidDouble(bottom)) {
                throw new IllegalArgumentException("bottom latitude is invalid: " + bottom);
            }
            if (!Numbers.isValidDouble(right)) {
                throw new IllegalArgumentException("right longitude is invalid: " + right);
            }
            if (top < bottom) {
                throw new IllegalArgumentException("top is below bottom corner: " + top + " vs. " + bottom);
            }
            if (top == bottom) {
                throw new IllegalArgumentException("top cannot be the same as bottom: " + top + " == " + bottom);
            }
            if (left == right) {
                throw new IllegalArgumentException("left cannot be the same as right: " + left + " == " + right);
            }
        }
        this.topLeft.reset(top, left);
        this.bottomRight.reset(bottom, right);
        return this;
    }

    public GeoBoundingBoxQueryBuilder setCorners(GeoPoint topLeft, GeoPoint bottomRight) {
        return this.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCorners(String geohash) {
        Rectangle ghBBox = GeoHashUtils.bbox(geohash);
        return this.setCorners(new GeoPoint(ghBBox.maxLat, ghBBox.minLon), new GeoPoint(ghBBox.minLat, ghBBox.maxLon));
    }

    public GeoBoundingBoxQueryBuilder setCorners(String topLeft, String bottomRight) {
        return this.setCorners(GeoPoint.fromGeohash(topLeft), GeoPoint.fromGeohash(bottomRight));
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(GeoPoint bottomLeft, GeoPoint topRight) {
        return this.setCorners(topRight.getLat(), bottomLeft.getLon(), bottomLeft.getLat(), topRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(String bottomLeft, String topRight) {
        return this.setCornersOGC(GeoPoint.fromGeohash(bottomLeft), GeoPoint.fromGeohash(topRight));
    }

    public GeoBoundingBoxQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoBoundingBoxQueryBuilder type(GeoExecType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type is not allowed to be null.");
        }
        this.type = type;
        return this;
    }

    public GeoBoundingBoxQueryBuilder type(String type) {
        this.type = GeoExecType.fromString(type);
        return this;
    }

    public GeoExecType type() {
        return this.type;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoBoundingBoxQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            return null;
        }
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(this.topLeft.getLat())) {
            validationException = this.addValidationError("top latitude is invalid: " + this.topLeft.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.topLeft.getLon())) {
            validationException = this.addValidationError("left longitude is invalid: " + this.topLeft.getLon(), validationException);
        }
        if (!GeoUtils.isValidLatitude(this.bottomRight.getLat())) {
            validationException = this.addValidationError("bottom latitude is invalid: " + this.bottomRight.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.bottomRight.getLon())) {
            validationException = this.addValidationError("right longitude is invalid: " + this.bottomRight.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public Query doToQuery(QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(context, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException(context, "couldn't validate latitude/ longitude values", (Throwable)exception, new Object[0]);
        }
        GeoPoint luceneTopLeft = new GeoPoint(this.topLeft);
        GeoPoint luceneBottomRight = new GeoPoint(this.bottomRight);
        if (GeoValidationMethod.isCoerce(this.validationMethod)) {
            double left;
            double right = luceneBottomRight.getLon();
            boolean completeLonRange = (right - (left = luceneTopLeft.getLon())) % 360.0 == 0.0 && right > left;
            GeoUtils.normalizePoint(luceneTopLeft, true, !completeLonRange);
            GeoUtils.normalizePoint(luceneBottomRight, true, !completeLonRange);
            if (completeLonRange) {
                luceneTopLeft.resetLon(-180.0);
                luceneBottomRight.resetLon(180.0);
            }
        }
        Query query = LatLonPoint.newBoxQuery((String)fieldType.name(), (double)luceneBottomRight.getLat(), (double)luceneTopLeft.getLat(), (double)luceneTopLeft.getLon(), (double)luceneBottomRight.getLon());
        if (fieldType.hasDocValues()) {
            Query dvQuery = LatLonDocValuesField.newSlowBoxQuery((String)fieldType.name(), (double)luceneBottomRight.getLat(), (double)luceneTopLeft.getLat(), (double)luceneTopLeft.getLon(), (double)luceneBottomRight.getLon());
            query = new IndexOrDocValuesQuery(query, dvQuery);
        }
        return query;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.array(TOP_LEFT_FIELD.getPreferredName(), new Object[]{this.topLeft.getLon(), this.topLeft.getLat()});
        builder.array(BOTTOM_RIGHT_FIELD.getPreferredName(), new Object[]{this.bottomRight.getLon(), this.bottomRight.getLat()});
        builder.endObject();
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), (Object)this.validationMethod);
        builder.field(TYPE_FIELD.getPreferredName(), (Object)this.type);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoBoundingBoxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        double[] bbox = null;
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                try {
                    bbox = GeoBoundingBoxQueryBuilder.parseBoundingBox(parser);
                    fieldName = currentFieldName;
                    continue;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse [{}] query. [{}]", NAME, e.getMessage());
                }
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                type = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
        }
        if (bbox == null) {
            throw new ElasticsearchParseException("failed to parse [{}] query. bounding box not provided", NAME);
        }
        GeoPoint topLeft = new GeoPoint((double)bbox[1], bbox[2]);
        GeoPoint bottomRight = new GeoPoint(bbox[0], bbox[3]);
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(topLeft, bottomRight);
        builder.queryName(queryName);
        builder.boost(boost);
        builder.type(GeoExecType.fromString(type));
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        return builder;
    }

    @Override
    protected boolean doEquals(GeoBoundingBoxQueryBuilder other) {
        return Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.bottomRight, other.bottomRight) && Objects.equals(this.type, other.type) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.topLeft, this.bottomRight, this.type, this.validationMethod, this.fieldName, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static double[] parseBoundingBox(XContentParser parser) throws IOException, ElasticsearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse bounding box. Expected start object but found [{}]", token);
        }
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        GeoPoint sparse = new GeoPoint();
        EnvelopeBuilder envelope = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (WKT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    envelope = (EnvelopeBuilder)GeoWKTParser.parseExpectedType(parser, GeoShapeType.ENVELOPE);
                    continue;
                }
                if (FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    DEPRECATION_LOGGER.deprecated("[{}] field is deprecated and no longer used", FIELD_FIELD.getPreferredName());
                    continue;
                }
                if (TOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    top = parser.doubleValue();
                    continue;
                }
                if (BOTTOM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    bottom = parser.doubleValue();
                    continue;
                }
                if (LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    left = parser.doubleValue();
                    continue;
                }
                if (RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    right = parser.doubleValue();
                    continue;
                }
                if (TOP_LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse);
                    top = sparse.getLat();
                    left = sparse.getLon();
                    continue;
                }
                if (BOTTOM_RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse);
                    bottom = sparse.getLat();
                    right = sparse.getLon();
                    continue;
                }
                if (TOP_RIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse);
                    top = sparse.getLat();
                    right = sparse.getLon();
                    continue;
                }
                if (BOTTOM_LEFT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    GeoUtils.parseGeoPoint(parser, sparse);
                    bottom = sparse.getLat();
                    left = sparse.getLon();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse bounding box. unexpected field [{}]", currentFieldName);
            }
            throw new ElasticsearchParseException("failed to parse bounding box. field name expected but [{}] found", token);
        }
        if (envelope != null) {
            if (!(Double.isNaN(top) || Double.isNaN(bottom) || Double.isNaN(left) || Double.isNaN(right))) {
                throw new ElasticsearchParseException("failed to parse bounding box. Conflicting definition found using well-known text and explicit corners.", new Object[0]);
            }
            org.locationtech.spatial4j.shape.Rectangle r = envelope.buildS4J();
            return new double[]{r.getMinY(), r.getMaxY(), r.getMinX(), r.getMaxX()};
        }
        return new double[]{bottom, top, left, right};
    }
}

