/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.web.struts.action;

import java.util.Collection;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeTaskBase;
import org.kuali.coeus.common.committee.impl.rules.CommitteeDocumentRuleBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.common.committee.impl.web.struts.action.CommitteeActionBase;
import org.kuali.coeus.common.committee.impl.web.struts.form.CommitteeFormBase;
import org.kuali.coeus.sys.framework.controller.DocHandlerService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class CommitteeCommitteeActionBase
extends CommitteeActionBase {
    private static final String COMMITTEE_ID = "committeeId";
    private static final String COMMITTEE_DOCUMENT = "CommitteeDocument";
    private static final Logger LOG = LogManager.getLogger(CommitteeCommitteeActionBase.class);

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((CharSequence)request.getParameter(COMMITTEE_ID))) {
            Object committee = this.getCommitteeService().getLightVersion(request.getParameter(COMMITTEE_ID));
            CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
            committeeDocument.setCommittee(committee);
            ((CommitteeBase)committee).setCommitteeDocument((CommitteeDocumentBase)committeeDocument);
        }
        committeeForm.getCommitteeHelper().prepareView();
        return actionForward;
    }

    @Override
    protected void processMultipleLookupResults(CommitteeFormBase committeeForm, Class lookupResultsBOClass, Collection<PersistableBusinessObject> selectedBOs) {
        if (lookupResultsBOClass.isAssignableFrom(this.getResearchAreaBOClassHook())) {
            Object committee = committeeForm.getCommitteeDocument().getCommittee();
            this.getCommitteeService().addResearchAreas(committee, selectedBOs);
            this.getNewCommitteeDocumentRuleInstanceHook().validateCommitteeResearchAreas((CommitteeBase)committee);
        }
    }

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBOClassHook();

    protected abstract CommitteeDocumentRuleBase getNewCommitteeDocumentRuleInstanceHook();

    public ActionForward deleteResearchArea(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeForm = (CommitteeFormBase)form;
        CommitteeDocumentBase committeeDocument = committeeForm.getCommitteeDocument();
        Object committee = committeeDocument.getCommittee();
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook("modifyCommittee", (CommitteeBase)committee);
        if (this.isAuthorized(task)) {
            ((CommitteeBase)committee).getCommitteeResearchAreas().remove(this.getLineToDelete(request));
        }
        this.getNewCommitteeDocumentRuleInstanceHook().validateCommitteeResearchAreas((CommitteeBase)committee);
        return mapping.findForward("basic");
    }

    @Override
    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    private CommitteeServiceBase getCommitteeService() {
        return KcServiceLocator.getService(this.getCommitteeServiceBOClassHook());
    }

    protected abstract Class<? extends CommitteeServiceBase> getCommitteeServiceBOClassHook();

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CommitteeFormBase committeeFormBase = (CommitteeFormBase)form;
        if (committeeFormBase.getWorkflowDocument().isFinal()) {
            response.sendRedirect(this.makeMaintenaceUrl(committeeFormBase.getDocId(), committeeFormBase.getCommitteeDocument().getCommitteeId()));
            return null;
        }
        response.sendRedirect(this.buildForwardUrl(committeeFormBase.getDocId()));
        return null;
    }

    protected String makeMaintenaceUrl(String docId, String committeeId) {
        String baseURL = this.getDocHandlerService().getDocHandlerUrl(docId);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", COMMITTEE_DOCUMENT);
        parameters.put(COMMITTEE_ID, committeeId);
        return UrlFactory.parameterizeUrl((String)baseURL, (Properties)parameters);
    }

    private DocHandlerService getDocHandlerService() {
        return KcServiceLocator.getService(DocHandlerService.class);
    }
}

