/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.protocol.ProtocolSubmissionLookupableHelperServiceImplBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;

public class ProtocolSubmissionLookupableHelperServiceImpl
extends ProtocolSubmissionLookupableHelperServiceImplBase {
    private ProtocolSubmitActionService protocolSubmitActionService;

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), ((ProtocolSubmission)businessObject).getProtocol(), "Modify Protocol")) {
            HtmlData.AnchorHtmlData editHtmlData = this.getViewLink((ProtocolSubmission)businessObject);
            String href = editHtmlData.getHref();
            href = href.replace("viewDocument=true", "viewDocument=false");
            editHtmlData.setHref(href);
            editHtmlData.setDisplayText("edit");
            htmlDataList.add((HtmlData)editHtmlData);
        }
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), ((ProtocolSubmission)businessObject).getProtocol(), "View Protocol")) {
            htmlDataList.add((HtmlData)this.getViewLink((ProtocolSubmission)businessObject));
        }
        return htmlDataList;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        List<ProtocolSubmission> submissionLookupData = super.getSearchResults(fieldValues);
        if (submissionLookupData != null && submissionLookupData.size() > 0) {
            submissionLookupData = this.protocolSubmitActionService.getProtocolSubmissionsLookupData(submissionLookupData);
        }
        for (ProtocolSubmission submission : submissionLookupData) {
            if (submission.getCommitteeSchedule() != null) continue;
            submission.setCommitteeSchedule(new CommitteeSchedule());
        }
        return submissionLookupData;
    }

    @Override
    protected String getHtmlAction() {
        return "protocolProtocol.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "ProtocolDocument";
    }

    public ProtocolSubmitActionService getProtocolSubmitActionService() {
        return this.protocolSubmitActionService;
    }

    public void setProtocolSubmitActionService(ProtocolSubmitActionService protocolSubmitActionService) {
        this.protocolSubmitActionService = protocolSubmitActionService;
    }
}

