<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2019 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="'PDF'"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="8.5in" page-width="11in" margin-left="0.2in" margin-right="0.2in">
                <fo:region-body margin-top="1.6in" margin-bottom="0.2in"/>
                <fo:region-before extent="1.5in"/>
                <fo:region-after extent="0.2in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="headerall"/>
                <xsl:call-template name="footerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <xsl:choose>
                                <xsl:when test="budgetSalary/totalPeriod  = 1">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod = 2">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod = 3">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod  = 4">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod = 5">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod = 6">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding-top="20pt" border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod  = 7">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>

                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding-top="20pt" border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod  = 8">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod  = 9">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"  height="5"  display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 9   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 9  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding-top="20pt" border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod  = 10">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 10</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 9   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 9  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 10   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 10  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
<!--                            <xsl:when test="budgetSalary/totalPeriod =11">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 10</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 9   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 9  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 10   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 10  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block/>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 11</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="13" display-align="center">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 11  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 11 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod =12">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 10</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 9   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 9  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 10   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 10  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block/>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 11</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 12</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 11  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 11 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 12  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 12 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod =13">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 10</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 7  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 7 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 8   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 8  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 9   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 9  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 10   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 10  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block/>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 11</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 12</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="19" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 13</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Total</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 11  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 11 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 12  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 12 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 13  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 13 and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="total">
                                                                        <xsl:choose>
                                                                            <xsl:when test="string-length( . ) &lt;7">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="."/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                            <xsl:when test="string-length( . ) &gt; 12">
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:text>$</xsl:text>
                                                                                </fo:inline>
                                                                                <fo:inline font-weight="bold">
                                                                                    <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                </fo:inline>
                                                                            </xsl:when>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block/>
                                    </xsl:for-each>
                                </xsl:when>
                                <xsl:when test="budgetSalary/totalPeriod =14">
                                    <xsl:for-each select="budgetSalary">
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="70pt" />
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Cost Element</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 1</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 2</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 3</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 4</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 5</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="costElementCode">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                <fo:block>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline>
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 1   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 1  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 2   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 2  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 3   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 3  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 4   and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 4  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                                                </xsl:when>
                                                                                <xsl:when test="../budgetPeriodID  = 5  and  ../../name  = &quot;Total&quot;">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="string-length( . ) &lt;7">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="."/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;6 and  string-length( . ) &lt;10">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -6 )  , &quot;,&quot; ,   substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt;9 and  string-length( . ) &lt;13">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -9 )  , &quot;,&quot; ,  substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="string-length( . ) &gt; 12">
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:text>$</xsl:text>
                                                                                            </fo:inline>
                                                                                            <fo:inline font-weight="bold">
                                                                                                <xsl:value-of select="concat(  substring( . , 1 ,  string-length( . ) -12 )  , &quot;,&quot; ,  substring( . , string-length( . ) -11, 3 ) ,&quot;,&quot;, substring( . ,  string-length( . ) -8,3), &quot;,&quot;, substring( . ,  string-length( . ) -5 )  )"/>
                                                                                            </fo:inline>
                                                                                        </xsl:when>
                                                                                    </xsl:choose>
                                                                                </xsl:when>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </xsl:for-each>
                                                </fo:table-body>
                                            </fo:table>
                                        </xsl:if>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                        <fo:block/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <xsl:if test="salary">
                                            <fo:table font-family="Times New Roman" font-size="8pt" table-layout="fixed" width="100%" border="solid 0.4pt gray">
                                                <fo:table-column column-width="190pt"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                <fo:table-header start-indent="0pt">
                                                    <fo:table-row>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Description</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 6</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 7</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 8</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 9</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" height="18" display-align="center">
                                                            <fo:block>
                                                                <fo:inline font-size="10pt" font-weight="bold">
                                                                    <xsl:text>Period 10</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:table-cell>
                                                    </fo:table-row>
                                                </fo:table-header>
                                                <fo:table-body start-indent="0pt">
                                                    <xsl:for-each select="salary">
                                                        <fo:table-row>
                                                            <fo:table-cell border="solid 0.4pt gray"   display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="name">
                                                                        <xsl:choose>
                                                                            <xsl:when test=". = &quot;Total&quot;">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-weight="bold">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),'&#x2029;')">
                                                                                        <fo:block>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline>
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell border="solid 0.4pt gray"  text-align="right"  display-align="center">
                                                                <fo:block>
                                                                    <xsl:for-each select="Period">
                                                                        <xsl:for-each select="periodCost">
                                                                            <xsl:choose>
                                                                                <xsl:when test="../budgetPeriodID  = 6  and  ../../name  != &quot;Total&quot;">
                                                                                    <fo:inline>
                                                                                        <xsl:text>$</xsl:text>
                                                                                    </fo:inline>
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(string(.)), '#,###,###,##0.00')"/>
                                                                                    </fo:inline>
                                                  