/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.document;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.OutboxItem;
import org.kuali.rice.kew.actionlist.service.ActionListService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.DocumentTypeXmlParser;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.util.KRADUtils;

public class DocumentTypeMaintainable
extends KualiMaintainableImpl {
    private static final long serialVersionUID = -5920808902137192662L;

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (!document.isNew()) {
            block0: for (Section section : sections) {
                for (Row row : section.getRows()) {
                    for (Field field : row.getFields()) {
                        if (!"name".equals(field.getPropertyName())) continue;
                        field.setReadOnly(true);
                        break block0;
                    }
                }
            }
        }
        return sections;
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        DocumentType docType = (DocumentType)this.getBusinessObject();
        docType.setDocumentTypeId(null);
        docType.setName("");
        docType.setPreviousVersionId(null);
        docType.setObjectId(null);
        docType.setVersionNumber(null);
    }

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
    }

    private Set<String> constructUserInterfaceEditablePropertyNamesList() {
        HashSet<String> propertyNames = new HashSet<String>();
        List sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        for (MaintainableSectionDefinition maintainableSectionDefinition : sectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                propertyNames.add(maintainableItemDefinition.getName());
            }
        }
        return propertyNames;
    }

    public void saveBusinessObject() {
        DocumentType newDocumentType;
        String documentTypeName;
        DocumentTypeService docTypeService = KEWServiceLocator.getDocumentTypeService();
        DocumentType docTypeFromDatabase = docTypeService.findByName(documentTypeName = (newDocumentType = (DocumentType)this.getBusinessObject()).getName());
        if (docTypeFromDatabase == null) {
            docTypeService.versionAndSave(newDocumentType);
        } else {
            DocumentType newDocumentTypeFromDatabase;
            Boolean applyRetroactively = newDocumentType.getApplyRetroactively();
            DocumentTypeXmlParser parser = new DocumentTypeXmlParser();
            try {
                newDocumentTypeFromDatabase = parser.generateNewDocumentTypeFromExisting(documentTypeName);
            }
            catch (Exception e) {
                throw new WorkflowRuntimeException("Error while attempting to generate new document type from existing database document type with name '" + documentTypeName + "'", (Throwable)e);
            }
            newDocumentTypeFromDatabase.populateDataDictionaryEditableFields(this.constructUserInterfaceEditablePropertyNamesList(), newDocumentType);
            docTypeService.versionAndSave(newDocumentTypeFromDatabase);
            if (KRADUtils.isNotNull((Object)applyRetroactively) && applyRetroactively.booleanValue()) {
                List<DocumentType> previousDocTypeInstances = docTypeService.findPreviousInstances(documentTypeName);
                for (DocumentType prevDocType : previousDocTypeInstances) {
                    prevDocType.setLabel(newDocumentType.getLabel());
                    prevDocType.setDescription(newDocumentType.getDescription());
                    prevDocType.setUnresolvedHelpDefinitionUrl(newDocumentType.getUnresolvedHelpDefinitionUrl());
                    prevDocType.setUnresolvedDocSearchHelpUrl(newDocumentType.getUnresolvedDocSearchHelpUrl());
                    docTypeService.save(prevDocType);
                }
                ActionListService actionListService = KEWServiceLocator.getActionListService();
                Collection<ActionItem> items = actionListService.findByDocumentTypeName(documentTypeName);
                for (ActionItem actionItem : items) {
                    actionItem.setDocLabel(newDocumentType.getLabel());
                    actionListService.saveActionItem(actionItem);
                }
                Collection<OutboxItem> outboxItems = actionListService.getOutboxItemsByDocumentType(documentTypeName);
                for (OutboxItem outboxItem : outboxItems) {
                    outboxItem.setDocLabel(newDocumentType.getLabel());
                    actionListService.saveOutboxItem(outboxItem);
                }
            }
        }
    }

    protected String getDocumentTypeName() {
        return "DocumentTypeDocument";
    }
}

