/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit.admin;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.data.DataObjectService;

public class UnitAdministratorMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = -4267900712064482626L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final String UNIT_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.unitId";
    private static final String PRINCIPAL_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.principalId";
    private static final String UNIT_ADMINISTRATOR_TYPE_CODE_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.unitAdministratorTypeCode";
    private transient DataObjectService dataObjectService;

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            UnitAdministrator unitAdministrator = (UnitAdministrator)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            unitAdministrator.setPersonId(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        UnitAdministrator unitAdministrator = (UnitAdministrator)this.businessObject;
        if (!this.isUnitIdValid(unitAdministrator.getUnitNumber())) {
            this.reportInvalidUnitId(unitAdministrator);
        }
        if (!this.isUnitAdministratorTypeCodeValid(unitAdministrator.getUnitAdministratorTypeCode())) {
            this.reportInvalidUnitAdministratorTypeCode(unitAdministrator);
        }
        if (!this.isValidPrincipalId(unitAdministrator.getPersonId())) {
            this.reportInvalidPrincipalId(unitAdministrator);
        }
        super.prepareForSave();
    }

    private void reportInvalidUnitId(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.unitNumber", UNIT_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidPrincipalId(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.person.userName", PRINCIPAL_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidUnitAdministratorTypeCode(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.unitAdministratorTypeCode", UNIT_ADMINISTRATOR_TYPE_CODE_INVALID_ERROR_KEY, new String[0]);
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        KcPersonService personService = KcServiceLocator.getService(KcPersonService.class);
        if (StringUtils.isEmpty((CharSequence)principalId)) {
            valid = false;
        } else {
            KcPerson person = personService.getKcPersonByPersonId(principalId);
            if (person == null) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isUnitIdValid(String unitNumber) {
        Unit result = (Unit)this.getDataObjectService().find(Unit.class, (Object)unitNumber);
        return result != null;
    }

    private boolean isUnitAdministratorTypeCodeValid(String unitAdministratorTypeCode) {
        UnitAdministratorType adminType = (UnitAdministratorType)this.getDataObjectService().find(UnitAdministratorType.class, (Object)unitAdministratorTypeCode);
        return adminType != null;
    }
}

