/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubAwardFundingSourceValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private transient BusinessObjectService businessObjectService;

    public List<KeyValue> getKeyValues() {
        SubAwardDocument doc = (SubAwardDocument)this.getDocument();
        StringBuilder fundingValues = new StringBuilder();
        Long subawardID = doc.getSubAward().getSubAwardId();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Collection fundingSource = this.getBusinessObjectService().findMatching(SubAwardFundingSource.class, Collections.singletonMap("subAwardId", subawardID));
        for (SubAwardFundingSource subAwardFunding : fundingSource) {
            fundingValues.append(subAwardFunding.getAward().getAwardNumber());
            keyValues.add((KeyValue)new ConcreteKeyValue(subAwardFunding.getSubAwardFundingSourceId().toString(), "Award:" + subAwardFunding.getAward().getAwardNumber()));
        }
        if (fundingValues.length() == 0) {
            keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "No Funding Source has been added to this Subaward"));
        }
        return keyValues;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

