/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.rule;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.BulkUpdateMaintenanceDataObject;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.AgendaTypeService;
import org.kuali.rice.krms.impl.authorization.AgendaAuthorizationService;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class AgendaEditorBusRule
extends MaintenanceDocumentRuleBase {
    protected boolean primaryKeyCheck(MaintenanceDocument document) {
        boolean success = true;
        Class dataObjectClass = document.getNewMaintainableObject().getDataObjectClass();
        AgendaBo oldBo = ((AgendaEditor)document.getOldMaintainableObject().getDataObject()).getAgenda();
        AgendaBo newDataObject = ((AgendaEditor)document.getNewMaintainableObject().getDataObject()).getAgenda();
        if (newDataObject instanceof BulkUpdateMaintenanceDataObject) {
            return success;
        }
        if (document.isEdit()) {
            if (!KRADServiceLocatorWeb.getLegacyDataAdapter().equalsByPrimaryKeys((Object)oldBo, (Object)newDataObject)) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.primaryKeysChangedOnEdit", this.getHumanReadablePrimaryKeyFieldNames(dataObjectClass));
                success &= false;
            }
        } else if (document.isNew() && newDataObject instanceof PersistableBusinessObject) {
            Map newPkFields = KRADServiceLocatorWeb.getLegacyDataAdapter().getPrimaryKeyFieldValues((Object)newDataObject);
            PersistableBusinessObject testBo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.getDataObjectService(), dataObjectClass.asSubclass(PersistableBusinessObject.class), newPkFields);
            if (testBo != null) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.objectAlreadyExistsByPrimaryKeysOnCreateNew", this.getHumanReadablePrimaryKeyFieldNames(dataObjectClass));
                success &= false;
            }
        }
        return success;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        AgendaEditor agendaEditor = (AgendaEditor)document.getNewMaintainableObject().getDataObject();
        AgendaEditor oldAgendaEditor = (AgendaEditor)document.getOldMaintainableObject().getDataObject();
        isValid &= this.validContext(agendaEditor);
        isValid &= this.validAgendaName(agendaEditor);
        isValid &= this.validContextAgendaNamespace(agendaEditor);
        return isValid &= this.validAgendaTypeAndAttributes(oldAgendaEditor, agendaEditor);
    }

    public boolean validContext(AgendaEditor agendaEditor) {
        boolean isValid = true;
        try {
            ContextDefinition context;
            if (agendaEditor.getAgenda().getContextId() == null && (context = this.getContextBoService().getContextByNameAndNamespace(agendaEditor.getContextName(), agendaEditor.getNamespace())) != null) {
                agendaEditor.getAgenda().setContextId(context.getId());
            }
            if (this.getContextBoService().getContextByContextId(agendaEditor.getAgenda().getContextId()) == null) {
                this.putFieldError("dataObject.contextName", "error.agenda.invalidContext");
                isValid = false;
            } else if (!this.getAgendaAuthorizationService().isAuthorized("Maintain KRMS Agenda", agendaEditor.getAgenda().getContextId())) {
                this.putFieldError("dataObject.contextName", "error.agenda.unauthorizedContext");
                isValid = false;
            }
        }
        catch (IllegalArgumentException e) {
            this.putFieldError("dataObject.contextName", "error.agenda.invalidContext");
            isValid = false;
        }
        return isValid;
    }

    public boolean validContextAgendaNamespace(AgendaEditor agendaEditor) {
        if (StringUtils.isNotBlank((String)agendaEditor.getNamespace()) && this.getContextBoService().getContextByNameAndNamespace(agendaEditor.getContextName(), agendaEditor.getNamespace()) != null) {
            return true;
        }
        this.putFieldError("dataObject.namespace", "error.context.invalidNamespace");
        return false;
    }

    private boolean validAgendaTypeAndAttributes(AgendaEditor oldAgendaEditor, AgendaEditor newAgendaEditor) {
        if (this.validAgendaType(newAgendaEditor.getAgenda().getTypeId(), newAgendaEditor.getAgenda().getContextId())) {
            return this.validAgendaAttributes(oldAgendaEditor, newAgendaEditor);
        }
        return false;
    }

    private boolean validAgendaType(String typeId, String contextId) {
        boolean isValid = true;
        if (!StringUtils.isBlank((String)typeId) && !StringUtils.isBlank((String)contextId)) {
            if (this.getKrmsTypeRepositoryService().getAgendaTypeByAgendaTypeIdAndContextId(typeId, contextId) != null) {
                return true;
            }
            this.putFieldError("dataObject.agenda.typeId", "error.agenda.invalidType");
            return false;
        }
        return isValid;
    }

    private boolean validAgendaAttributes(AgendaEditor oldAgendaEditor, AgendaEditor newAgendaEditor) {
        boolean isValid = true;
        String typeId = newAgendaEditor.getAgenda().getTypeId();
        if (!StringUtils.isEmpty((String)typeId)) {
            KrmsTypeDefinition typeDefinition = this.getKrmsTypeRepositoryService().getTypeById(typeId);
            if (typeDefinition == null) {
                throw new IllegalStateException("agenda typeId must match the id of a valid krms type");
            }
            if (StringUtils.isBlank((String)typeDefinition.getServiceName())) {
                throw new IllegalStateException("agenda type definition must have a non-blank service name");
            }
            AgendaTypeService agendaTypeService = (AgendaTypeService)KrmsRepositoryServiceLocator.getService(typeDefinition.getServiceName());
            if (agendaTypeService == null) {
                throw new IllegalStateException("typeDefinition must have a valid serviceName");
            }
            List errors = oldAgendaEditor == null ? agendaTypeService.validateAttributes(typeId, newAgendaEditor.getCustomAttributesMap()) : agendaTypeService.validateAttributesAgainstExisting(typeId, newAgendaEditor.getCustomAttributesMap(), oldAgendaEditor.getCustomAttributesMap());
            if (!CollectionUtils.isEmpty((Collection)errors)) {
                isValid = false;
                for (RemotableAttributeError error : errors) {
                    for (String errorStr : error.getErrors()) {
                        this.putFieldError("dataObject.customAttributesMap['" + error.getAttributeName() + "']", errorStr);
                    }
                }
            }
        }
        return isValid;
    }

    public boolean validAgendaName(AgendaEditor agendaEditor) {
        try {
            AgendaDefinition agendaFromDataBase = this.getAgendaBoService().getAgendaByNameAndContextId(agendaEditor.getAgenda().getName(), agendaEditor.getAgenda().getContextId());
            if (agendaFromDataBase != null && !StringUtils.equals((String)agendaFromDataBase.getId(), (String)agendaEditor.getAgenda().getId())) {
                this.putFieldError("dataObject.agenda.name", "error.agenda.duplicateName");
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.putFieldError("dataObject.agenda.name", "error.agenda.invalidName");
            return false;
        }
        return true;
    }

    public boolean processAgendaItemBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        AgendaEditor newAgendaEditor = (AgendaEditor)document.getNewMaintainableObject().getDataObject();
        AgendaEditor oldAgendaEditor = (AgendaEditor)document.getOldMaintainableObject().getDataObject();
        RuleBo rule = newAgendaEditor.getAgendaItemLine().getRule();
        isValid &= this.validateRuleName(rule, newAgendaEditor.getAgenda());
        isValid &= this.validRuleType(rule.getTypeId(), newAgendaEditor.getAgenda().getContextId());
        return isValid &= this.validateRuleAction(oldAgendaEditor, newAgendaEditor);
    }

    private boolean validateRuleName(RuleBo rule, AgendaBo agenda) {
        if (StringUtils.isBlank((String)rule.getName())) {
            this.putFieldError("dataObject.agendaItemLine.rule.name", "error.rule.invalidName");
            return false;
        }
        for (AgendaItemBo agendaItem : agenda.getItems()) {
            if (StringUtils.equals((String)agendaItem.getRule().getId(), (String)rule.getId()) || !StringUtils.equals((String)agendaItem.getRule().getName(), (String)rule.getName()) || !StringUtils.equals((String)agendaItem.getRule().getNamespace(), (String)rule.getNamespace())) continue;
            this.putFieldError("dataObject.agendaItemLine.rule.name", "error.rule.duplicateName");
            return false;
        }
        if (StringUtils.isNotBlank((String)rule.getNamespace())) {
            RuleDefinition ruleFromDatabase = this.getRuleBoService().getRuleByNameAndNamespace(rule.getName(), rule.getNamespace());
            try {
                if (ruleFromDatabase != null && !StringUtils.equals((String)ruleFromDatabase.getId(), (String)rule.getId())) {
                    this.putFieldError("dataObject.agendaItemLine.rule.name", "error.rule.duplicateName");
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                this.putFieldError("dataObject.agendaItemLine.rule.name", "error.rule.invalidName");
                return false;
            }
        }
        return true;
    }

    private boolean validRuleType(String ruleTypeId, String contextId) {
        if (StringUtils.isBlank((String)ruleTypeId)) {
            return true;
        }
        if (this.getKrmsTypeRepositoryService().getRuleTypeByRuleTypeIdAndContextId(ruleTypeId, contextId) != null) {
            return true;
        }
        this.putFieldError("dataObject.agendaItemLine.rule.typeId", "error.rule.invalidType");
        return false;
    }

    private boolean validateRuleAction(AgendaEditor oldAgendaEditor, AgendaEditor newAgendaEditor) {
        boolean isValid = true;
        ActionBo newActionBo = newAgendaEditor.getAgendaItemLineRuleAction();
        if ((isValid &= this.validRuleActionType(newActionBo.getTypeId(), newAgendaEditor.getAgenda().getContextId())) && StringUtils.isNotBlank((String)newActionBo.getTypeId())) {
            isValid &= this.validRuleActionName(newActionBo.getName());
            isValid &= this.validRuleActionAttributes(oldAgendaEditor, newAgendaEditor);
        }
        return isValid;
    }

    private boolean validRuleActionType(String typeId, String contextId) {
        if (StringUtils.isBlank((String)typeId)) {
            return true;
        }
        if (this.getKrmsTypeRepositoryService().getActionTypeByActionTypeIdAndContextId(typeId, contextId) != null) {
            return true;
        }
        this.putFieldError("dataObject.agendaItemLineRuleAction.typeId", "error.action.invalidType");
        return false;
    }

    private boolean validRuleActionName(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            return true;
        }
        this.putFieldError("dataObject.agendaItemLineRuleAction.name", "error.action.missingName");
        return false;
    }

    private boolean validRuleActionAttributes(AgendaEditor oldAgendaEditor, AgendaEditor newAgendaEditor) {
        boolean isValid = true;
        String typeId = newAgendaEditor.getAgendaItemLineRuleAction().getTypeId();
        if (!StringUtils.isBlank((String)typeId)) {
            KrmsTypeDefinition typeDefinition = this.getKrmsTypeRepositoryService().getTypeById(typeId);
            if (typeDefinition == null) {
                throw new IllegalStateException("rule action typeId must match the id of a valid krms type");
            }
            if (StringUtils.isBlank((String)typeDefinition.getServiceName())) {
                throw new IllegalStateException("rule action type definition must have a non-blank service name");
            }
            ActionTypeService actionTypeService = this.getActionTypeService(typeDefinition.getServiceName());
            if (actionTypeService == null) {
                throw new IllegalStateException("typeDefinition must have a valid serviceName");
            }
            List errors = oldAgendaEditor == null ? actionTypeService.validateAttributes(typeId, newAgendaEditor.getCustomRuleActionAttributesMap()) : actionTypeService.validateAttributesAgainstExisting(typeId, newAgendaEditor.getCustomRuleActionAttributesMap(), oldAgendaEditor.getCustomRuleActionAttributesMap());
            if (!CollectionUtils.isEmpty((Collection)errors)) {
                isValid = false;
                for (RemotableAttributeError error : errors) {
                    for (String errorStr : error.getErrors()) {
                        this.putFieldError("dataObject.customRuleActionAttributesMap['" + error.getAttributeName() + "']", errorStr);
                    }
                }
            }
        }
        return isValid;
    }

    public ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }

    public AgendaBoService getAgendaBoService() {
        return KrmsRepositoryServiceLocator.getAgendaBoService();
    }

    public RuleBoService getRuleBoService() {
        return KrmsRepositoryServiceLocator.getRuleBoService();
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
    }

    public ActionTypeService getActionTypeService(String serviceName) {
        return (ActionTypeService)KrmsRepositoryServiceLocator.getService(serviceName);
    }

    public AgendaAuthorizationService getAgendaAuthorizationService() {
        return KrmsRepositoryServiceLocator.getAgendaAuthorizationService();
    }
}

