/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.core.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.core.groups.GroupsPushService;
import org.kuali.coeus.common.framework.core.groups.GroupsPushStatus;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.framework.auth.CategoryDto;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.impl.core.CoreServicesUtil;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="groupsPushService")
public class GroupsPushServiceImpl
implements GroupsPushService {
    private static final String ACTIVE_FIELD_DESCRIPTION = "Active";
    private static final String UNIT_NUMBER_FIELD_DESCRIPTION = "Unit Number";
    private static final String CHECKBOX_FIELD_TYPE = "checkbox";
    private static final String TEXT_FIELD_TYPE = "text";
    private static final Logger LOG = LogManager.getLogger(GroupsPushServiceImpl.class);
    private static final String[] PREDEFINED_ROLE_IDS = new String[]{"IRB Admin", "IACUC Admin", "IRB User", "IACUC User", "IRB Viewer", "IACUC Viewer"};
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="coreGroupsService")
    private CoreGroupsService coreGroupsService;
    @Autowired
    @Qualifier(value="coreServicesUtil")
    private CoreServicesUtil coreServicesUtil;

    @Override
    public GroupsPushStatus pushAllGroups() {
        GroupsPushStatus status = new GroupsPushStatus();
        List<CategoryDto> categories = this.getAllCategories().stream().sorted(Comparator.comparing(CategoryDto::getId)).collect(Collectors.toList());
        List<GroupDto> groups = this.getAllGroups();
        List<UnitAdministratorType> unitAdminTypes = this.getUnitAdministratorTypes();
        Unit topUnit = this.unitService.getTopUnit();
        this.syncGroups(Collections.singletonList(topUnit), null, 1, null, categories, groups, unitAdminTypes, new ArrayList<Integer>(), status);
        return status;
    }

    protected List<UnitAdministratorType> getUnitAdministratorTypes() {
        return this.dataObjectService.findAll(UnitAdministratorType.class).getResults();
    }

    protected void syncGroups(List<Unit> units, GroupDto parentGroup, int level, CategoryDto parentCategory, List<CategoryDto> categories, List<GroupDto> groups, List<UnitAdministratorType> unitAdminTypes, List<Integer> levelsSynced, GroupsPushStatus status) {
        CategoryDto category;
        Optional<CategoryDto> currentCategory = this.findChildCategory(parentCategory, categories);
        if (!currentCategory.isPresent() || !levelsSynced.contains(level)) {
            category = this.syncCategory(currentCategory, parentCategory, level, unitAdminTypes, status);
            if (!currentCategory.isPresent()) {
                categories.add(category);
            }
            levelsSynced.add(level);
        } else {
            category = currentCategory.get();
        }
        status.setNumberOfUnits(status.getNumberOfUnits() + units.size());
        units.stream().forEach(unit -> {
            GroupDto group = groups.stream().filter(g -> StringUtils.equals((CharSequence)unit.getUnitNumber(), (CharSequence)this.getField((GroupDto)g, "UNIT_NUMBER").getValue())).findFirst().orElse(new GroupDto());
            if (group.getId() == null) {
                status.setGroupsAdded(status.getGroupsAdded() + 1);
                group.setCategoryId(category.getId());
                group.setName(unit.getUnitName());
                if (parentGroup != null) {
                    group.setParentId(parentGroup.getId());
                }
                group.getFields().add(new GroupDto.GroupFields("UNIT_NUMBER", unit.getUnitNumber()));
                group.getFields().add(new GroupDto.GroupFields("ACTIVE", Boolean.toString(unit.isActive())));
                this.addUnitAdmins(group, (Unit)unit);
                group = this.addGroup(group);
            } else {
                status.setGroupsUpdated(status.getGroupsUpdated() + 1);
                group.setCategoryId(category.getId());
                group.setName(unit.getUnitName());
                if (parentGroup != null) {
                    group.setParentId(parentGroup.getId());
                }
                this.getField(group, "ACTIVE").setValue(Boolean.toString(unit.isActive()));
                this.addUnitAdmins(group, (Unit)unit);
                this.updateGroup(group);
            }
            List<Unit> childUnits = this.unitService.getSubUnits(unit.getUnitNumber());
            if (childUnits != null && childUnits.size() > 0) {
                this.syncGroups(childUnits, group, level + 1, category, categories, groups, unitAdminTypes, levelsSynced, status);
            }
        });
    }

    protected void addUnitAdmins(GroupDto group, Unit unit) {
        Map unitAdmins = this.unitService.retrieveUnitAdministratorsByUnitNumber(unit.getUnitNumber()).stream().collect(Collectors.groupingBy(a -> a.getUnitAdministratorType().getDescription(), HashMap::new, Collectors.mapping(UnitAdministrator::getPersonId, Collectors.toSet())));
        Map updatedRoles = unitAdmins.entrySet().stream().map(entry -> new GroupDto.Role(this.createRoleIdFromAdminTypeDescription((String)entry.getKey()), ((Set)entry.getValue()).stream().map(this::getCoreUserId).filter(u -> u != null).collect(Collectors.toList()))).collect(Collectors.toMap(GroupDto.Role::getId, Function.identity()));
        group.setRoles(Stream.concat(group.getRoles().stream().filter(r -> !updatedRoles.containsKey(r.getId())), updatedRoles.values().stream()).collect(Collectors.toList()));
    }

    protected String getCoreUserId(String schoolId) {
        String uri = UriComponentsBuilder.fromHttpUrl((String)this.getUsersApiUrl()).queryParam("schoolId", new Object[]{schoolId}).build().encode().toString();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), (ParameterizedTypeReference)new ParameterizedTypeReference<List<AuthUser>>(){}, new Object[0]);
        if (!((List)result.getBody()).isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("GET " + uri + " returning " + ((List)result.getBody()).get(0));
            }
            return ((AuthUser)((List)result.getBody()).get(0)).getId();
        }
        return null;
    }

    private GroupDto.GroupFields getField(GroupDto group, String fieldId) {
        return group.getFields().stream().filter(f -> StringUtils.equals((CharSequence)f.getId(), (CharSequence)fieldId)).findFirst().orElse(new GroupDto.GroupFields());
    }

    protected CategoryDto syncCategory(Optional<CategoryDto> existingCategory, CategoryDto parentCategory, int level, List<UnitAdministratorType> unitAdminTypes, GroupsPushStatus status) {
        CategoryDto updatedCategory = existingCategory.orElse(null);
        if (updatedCategory == null) {
            status.setCategoriesAdded(status.getCategoriesAdded() + 1);
            updatedCategory = new CategoryDto();
            if (parentCategory != null) {
                updatedCategory.setParentId(parentCategory.getId());
            }
            updatedCategory.setName("Level " + level);
            updatedCategory.getFieldSchemas().add(new CategoryDto.FieldSchemaDto("UNIT_NUMBER", TEXT_FIELD_TYPE, UNIT_NUMBER_FIELD_DESCRIPTION));
            updatedCategory.getFieldSchemas().add(new CategoryDto.FieldSchemaDto("ACTIVE", CHECKBOX_FIELD_TYPE, ACTIVE_FIELD_DESCRIPTION));
            this.updateCategoryRoles(updatedCategory, unitAdminTypes);
            return this.addCategory(updatedCategory);
        }
        status.setCategoriesUpdated(status.getCategoriesUpdated() + 1);
        if (parentCategory != null) {
            updatedCategory.setParentId(parentCategory.getId());
        }
        this.updateCategoryRoles(updatedCategory, unitAdminTypes);
        this.updateCategory(updatedCategory);
        return updatedCategory;
    }

    protected void updateCategoryRoles(CategoryDto category, List<UnitAdministratorType> unitAdminTypes) {
        Stream.concat(Stream.of(PREDEFINED_ROLE_IDS), unitAdminTypes.stream().map(UnitAdministratorType::getDescription)).distinct().forEach(name -> {
            String id = this.createRoleIdFromAdminTypeDescription((String)name);
            Optional<CategoryDto.RoleSchemaDto> roleSchema = category.getRoleSchemas().stream().filter(rs -> StringUtils.equals((CharSequence)rs.getId(), (CharSequence)id)).findFirst();
            if (!roleSchema.isPresent()) {
                category.getRoleSchemas().add(new CategoryDto.RoleSchemaDto(id, (String)name));
            }
        });
    }

    private String createRoleIdFromAdminTypeDescription(String name) {
        return name.toUpperCase().replaceAll("\\s+|\\.", "_");
    }

    protected Optional<CategoryDto> findChildCategory(CategoryDto parentCategory, List<CategoryDto> categories) {
        String parentId;
        String string = parentId = parentCategory == null ? null : parentCategory.getId();
        if (parentId == null) {
            return categories.stream().filter(c -> StringUtils.isBlank((CharSequence)c.getParentId()) || StringUtils.equals((CharSequence)c.getParentId(), (CharSequence)c.getId())).findFirst();
        }
        return categories.stream().filter(c -> StringUtils.equals((CharSequence)c.getParentId(), (CharSequence)parentId)).findFirst();
    }

    public List<CategoryDto> getAllCategories() {
        return this.getCoreServicesUtil().getAll(this.getCoreGroupsService().getCategoriesApiUrl(), Collections.emptyMap(), new ParameterizedTypeReference<List<CategoryDto>>(){});
    }

    protected List<GroupDto> getAllGroups() {
        return this.coreGroupsService.getAllGroups();
    }

    protected GroupDto getOneGroup(String groupId) {
        String uri = UriComponentsBuilder.fromHttpUrl((String)(this.coreGroupsService.getGroupsApiUrl() + groupId)).build().encode().toString();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.GET, new HttpEntity((MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), GroupDto.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info("GET " + uri + " returned " + result.getBody());
        }
        return (GroupDto)result.getBody();
    }

    protected CategoryDto addCategory(CategoryDto category) {
        ResponseEntity result = this.restOperations.exchange(this.coreGroupsService.getCategoriesApiUrl(), HttpMethod.POST, new HttpEntity((Object)category, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), CategoryDto.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            throw new RestClientException(result.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("POST " + this.coreGroupsService.getCategoriesApiUrl() + " returned " + result.getBody());
        }
        return (CategoryDto)result.getBody();
    }

    protected void updateCategory(CategoryDto category) {
        String uri = this.coreGroupsService.getCategoriesApiUrl() + category.getId();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)category, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info("PUT " + uri + " returned status of " + result.getStatusCode() + " and body text of " + (String)result.getBody());
        }
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException((String)result.getBody());
        }
    }

    protected GroupDto addGroup(GroupDto group) {
        String uri = this.coreGroupsService.getGroupsApiUrl();
        ResponseEntity result = this.restOperations.exchange(this.coreGroupsService.getGroupsApiUrl(), HttpMethod.POST, new HttpEntity((Object)group, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), GroupDto.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            throw new RestClientException(result.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("POST " + uri + " returned " + result.getBody());
        }
        return (GroupDto)result.getBody();
    }

    protected void updateGroup(GroupDto group) {
        String uri = this.coreGroupsService.getGroupsApiUrl() + group.getId();
        ResponseEntity result = this.restOperations.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)group, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (LOG.isInfoEnabled()) {
            LOG.info("PUT " + uri + " returned status of " + result.getStatusCode() + " and body text of " + (String)result.getBody());
        }
        if (result.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException((String)result.getBody());
        }
    }

    protected String getUsersApiUrl() {
        return this.configurationService.getPropertyValueAsString("auth.users.url") + "/";
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public CoreGroupsService getCoreGroupsService() {
        return this.coreGroupsService;
    }

    public void setCoreGroupsService(CoreGroupsService coreGroupsService) {
        this.coreGroupsService = coreGroupsService;
    }

    public CoreServicesUtil getCoreServicesUtil() {
        return this.coreServicesUtil;
    }

    public void setCoreServicesUtil(CoreServicesUtil coreServicesUtil) {
        this.coreServicesUtil = coreServicesUtil;
    }
}

