/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NotificationTypeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String MODULE_CODE_FIELD_NAME = "moduleCode";
    private static final String ACTION_CODE_FIELD_NAME = "actionCode";
    private static final String ROLE_FIELD_NAME = "notificationTypeRecipients[%d].roleName";
    private transient BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    protected boolean isDocumentValidForSave(MaintenanceDocument document) {
        return this.checkUniqueness(document);
    }

    private boolean checkUniqueness(MaintenanceDocument document) {
        boolean isValid = true;
        NotificationType newNotificationType = (NotificationType)document.getNewMaintainableObject().getDataObject();
        isValid &= this.checkModuleCodeActionCodeUniqueness(newNotificationType);
        return isValid &= this.checkNotificationTypeIdRoleNameUniqueness(newNotificationType);
    }

    private boolean checkModuleCodeActionCodeUniqueness(NotificationType newNotificationType) {
        boolean isValid = true;
        String moduleCode = newNotificationType.getModuleCode();
        String actionCode = newNotificationType.getActionCode();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_CODE_FIELD_NAME, moduleCode);
        fieldValues.put(ACTION_CODE_FIELD_NAME, actionCode);
        Collection matchingNotificationTypes = this.getBusinessObjectService().findMatching(NotificationType.class, fieldValues);
        for (NotificationType matchingNotificationType : matchingNotificationTypes) {
            if (Objects.equals(newNotificationType.getNotificationTypeId(), matchingNotificationType.getNotificationTypeId())) continue;
            isValid = false;
            this.putFieldError(ACTION_CODE_FIELD_NAME, "error.notification.moduleCode.actionCode.combination.exists", new String[]{moduleCode, actionCode});
            break;
        }
        return isValid;
    }

    private boolean checkNotificationTypeIdRoleNameUniqueness(NotificationType newNotificationType) {
        boolean isValid = true;
        List<NotificationTypeRecipient> newNotificationTypeRecipients = newNotificationType.getNotificationTypeRecipients();
        ListIterator<NotificationTypeRecipient> outer = newNotificationTypeRecipients.listIterator();
        while (outer.hasNext()) {
            NotificationTypeRecipient outerNotificationTypeRecipient = outer.next();
            ListIterator<NotificationTypeRecipient> inner = newNotificationTypeRecipients.listIterator(outer.nextIndex());
            while (inner.hasNext()) {
                int currentIndex = inner.nextIndex();
                NotificationTypeRecipient innerNotificationTypeRecipient = inner.next();
                if (!StringUtils.equals((CharSequence)outerNotificationTypeRecipient.getRoleName(), (CharSequence)innerNotificationTypeRecipient.getRoleName()) || !StringUtils.equals((CharSequence)outerNotificationTypeRecipient.getRoleSubQualifier(), (CharSequence)innerNotificationTypeRecipient.getRoleSubQualifier())) continue;
                isValid = false;
                this.putFieldError(String.format(ROLE_FIELD_NAME, currentIndex), "error.notification.roleNamespace.roleName.exists", new String[]{innerNotificationTypeRecipient.getRoleName()});
            }
        }
        return isValid;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

