/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionExplanation;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionService;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(QuestionMaintenanceDocumentRule.class);

    @Override
    protected Collection<Class<?>> relationshipDeleteVerificationIgnores() {
        return Stream.of(QuestionMultiChoice.class, QuestionExplanation.class).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        LOG.debug("MaintenanceDocument validation beginning");
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.businessObject");
        try {
            Maintainable newMaintainable = document.getNewMaintainableObject();
            if (newMaintainable == null) {
                GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
                throw new ValidationException("Maintainable object from Maintenance Document '" + document.getDocumentTitle() + "' is null, unable to proceed.");
            }
            PersistableBusinessObject businessObject = newMaintainable.getBusinessObject();
            if (businessObject == null) {
                GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.");
                throw new ValidationException("Maintainable's component business object is null.");
            }
            this.maintDocDictionaryService.validateMaintenanceRequiredFields(document);
            this.maintDocDictionaryService.validateMaintainableCollectionsForDuplicateEntries(document);
            this.dictionaryValidationService.validateBusinessObject((Object)businessObject, false);
            this.dictionaryValidationService.validateDefaultExistenceChecks((Object)businessObject);
        }
        finally {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.businessObject");
        }
        LOG.debug("MaintenanceDocument validation ending");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument maintenanceDocument) {
        boolean isValid = true;
        isValid &= this.validateQuestionUsage(maintenanceDocument);
        return isValid &= this.validateQuestionResponseType(maintenanceDocument);
    }

    private boolean validateQuestionUsage(MaintenanceDocument maintenanceDocument) {
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        if (!"A".equals(question.getStatus()) && this.getQuestionService().isQuestionUsed(question.getQuestionSeqId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.status", "error.question.status.in.use", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateQuestionResponseType(MaintenanceDocument maintenanceDocument) {
        boolean isValid = true;
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        if (question.getQuestionTypeId() == null) {
            isValid &= false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.not.specified", new String[0]);
        } else {
            switch (question.getQuestionTypeId().intValue()) {
                case 1: {
                    isValid &= this.validateResponseTypeYesNo(question);
                    break;
                }
                case 2: {
                    isValid &= this.validateResponseTypeYesNoNa(question);
                    break;
                }
                case 3: {
                    isValid &= this.validateResponseTypeNumber(question);
                    break;
                }
                case 7: {
                    isValid &= this.validateResponseTypeDecimal(question);
                    break;
                }
                case 4: {
                    isValid &= this.validateResponseTypeDate(question);
                    break;
                }
                case 5: {
                    isValid &= this.validateResponseTypeText(question);
                    break;
                }
                case 6: {
                    isValid &= this.validateResponseTypeLookup(question);
                    break;
                }
                case 100: {
                    isValid &= this.validateResponseTypeMultipleChoice(question);
                    break;
                }
                default: {
                    isValid &= false;
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.invalid", new String[0]);
                }
            }
        }
        return isValid;
    }

    private boolean validateResponseTypeYesNo(Question question) {
        return true;
    }

    private boolean validateResponseTypeYesNoNa(Question question) {
        return true;
    }

    private boolean validateResponseTypeNumber(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateAnswerMaxLengthWithCeiling(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeDecimal(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateAnswerMaxLengthWithCeiling(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeDate(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeText(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateAnswerMaxLengthWithCeiling(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeLookup(Question question) {
        boolean isValid = true;
        isValid &= this.validateLookupClass(question);
        isValid &= this.validateLookupReturn(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeMultipleChoice(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateMaxAnswers(question);
        return isValid &= this.validateMultipleChoiceOptions(question);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMultipleChoiceOptions(Question question) {
        boolean isValid = true;
        if (CollectionUtils.isEmpty(question.getQuestionMultiChoices()) || question.getDisplayedAnswers() <= 0) {
            isValid = false;
        }
        for (int i = 0; i < question.getQuestionMultiChoices().size(); ++i) {
            GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.businessObject.questionMultiChoices[" + i + "]");
            try {
                this.dictionaryValidationService.validate((Object)question.getQuestionMultiChoices().get(i));
                continue;
            }
            finally {
                GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.businessObject.questionMultiChoices[" + i + "]");
            }
        }
        return isValid;
    }

    private boolean validateDisplayedAnswers(Question question) {
        if (question.getDisplayedAnswers() != null && question.getDisplayedAnswers() > 0) {
            return true;
        }
        if (Long.valueOf(5L).equals(question.getQuestionTypeId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.areas", new String[0]);
            return false;
        }
        if (!Long.valueOf(100L).equals(question.getQuestionTypeId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.boxes", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateAnswerMaxLength(Question question) {
        if (question.getAnswerMaxLength() != null && question.getAnswerMaxLength() > 0) {
            return true;
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.invalid", new String[0]);
        return false;
    }

    public boolean validateAnswerMaxLengthWithCeiling(Question question) {
        if (this.validateAnswerMaxLength(question)) {
            if (question.getAnswerMaxLength() != null && question.getAnswerMaxLength() <= 2000) {
                return true;
            }
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.value.too.large", new String[0]);
            return false;
        }
        return false;
    }

    private boolean validateMaxAnswers(Question question) {
        boolean isValid = true;
        if (question.getMaxAnswers() == null || question.getMaxAnswers() <= 0) {
            isValid = false;
        }
        if (question.getQuestionTypeId() != 6L && question.getMaxAnswers() != null && question.getDisplayedAnswers() != null && question.getMaxAnswers() > question.getDisplayedAnswers()) {
            isValid = false;
        }
        if (!isValid) {
            switch (question.getQuestionTypeId().intValue()) {
                case 6: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.returns", new String[0]);
                    break;
                }
                case 5: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.areas", new String[0]);
                    break;
                }
                case 100: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.checkboxes", new String[0]);
                    break;
                }
                default: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.boxes", new String[0]);
                }
            }
        }
        return isValid;
    }

    private boolean validateLookupClass(Question question) {
        String prevLookupClass = (String)GlobalVariables.getUserSession().retrieveObject("lookupClassName");
        if (Objects.equals(question.getLookupClass(), prevLookupClass)) {
            GlobalVariables.getUserSession().removeObject("lookupReturnFields");
        }
        if (question.getLookupClass() != null) {
            return true;
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupClass", "error.question.lookup.class.not.specified", new String[0]);
        return false;
    }

    private boolean validateLookupReturn(Question question) {
        if (question.getLookupReturn() != null) {
            return this.validateLookupReturnBasedOnLookupClass(question);
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.not.specified", new String[0]);
        return false;
    }

    private boolean validateLookupReturnBasedOnLookupClass(Question question) {
        if (question.getLookupClass() != null) {
            try {
                List lookupReturnClasses = this.getCustomAttributeService().getLookupReturns(question.getLookupClass());
                for (String lookupReturnClass : lookupReturnClasses) {
                    if (!StringUtils.equals((CharSequence)lookupReturnClass, (CharSequence)question.getLookupReturn())) continue;
                    return true;
                }
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.invalid", new String[0]);
                return false;
            }
            catch (Exception e) {
                LOG.info(e.getMessage(), (Throwable)e);
                throw new RuntimeException("QuestionMaintenanceDocumentRule encountered exception", e);
            }
        }
        return true;
    }

    private CustomAttributeService getCustomAttributeService() {
        return KcServiceLocator.getService(CustomAttributeService.class);
    }

    private QuestionService getQuestionService() {
        return KcServiceLocator.getService(QuestionService.class);
    }
}

