/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.dao.impl;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.PersistedMessagePayload;
import org.kuali.rice.ksb.messaging.dao.MessageQueueDAO;

public class MessageQueueDaoJpa
implements MessageQueueDAO {
    private static final Logger LOG = LogManager.getLogger(MessageQueueDaoJpa.class);
    private EntityManager entityManager;

    @Override
    public List<PersistedMessageBO> findAll() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning all persisted messages");
        }
        Query query = this.entityManager.createNamedQuery("PersistedMessageBO.FindAll");
        return query.getResultList();
    }

    @Override
    public List<PersistedMessageBO> findAll(int maxRows) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding next " + maxRows + " messages");
        }
        TypedQuery query = this.entityManager.createNamedQuery("PersistedMessageBO.FindAll", PersistedMessageBO.class);
        query.setMaxResults(maxRows);
        return query.getResultList();
    }

    @Override
    public PersistedMessagePayload findByPersistedMessageByRouteQueueId(Long routeQueueId) {
        return (PersistedMessagePayload)this.entityManager.find(PersistedMessagePayload.class, (Object)routeQueueId);
    }

    @Override
    public PersistedMessageBO findByRouteQueueId(Long routeQueueId) {
        return (PersistedMessageBO)this.entityManager.find(PersistedMessageBO.class, (Object)routeQueueId);
    }

    @Override
    public List<PersistedMessageBO> findByServiceName(QName serviceName, String methodName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finding messages for service name " + serviceName);
        }
        TypedQuery query = this.entityManager.createNamedQuery("PersistedMessageBO.FindByServiceName", PersistedMessageBO.class);
        query.setParameter("serviceName", (Object)serviceName.toString());
        query.setParameter("methodName", (Object)methodName);
        return query.getResultList();
    }

    @Override
    public List<PersistedMessageBO> findByValues(Map<String, String> criteriaValues, int maxRows) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(PersistedMessageBO.class);
        Root message = query.from(PersistedMessageBO.class);
        Predicate predicate = builder.conjunction();
        for (Map.Entry<String, String> entry : criteriaValues.entrySet()) {
            predicate = builder.and((Expression)predicate, (Expression)builder.equal((Expression)message.get(entry.getKey()), (Object)entry.getValue()));
        }
        query.where((Expression)predicate);
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        return typedQuery.getResultList();
    }

    @Override
    public List<PersistedMessageBO> getNextDocuments(Integer maxDocuments) {
        String applicationId = CoreConfigHelper.getApplicationId();
        TypedQuery query = this.entityManager.createNamedQuery("PersistedMessageBO.GetNextDocuments", PersistedMessageBO.class);
        query.setParameter("applicationId", (Object)applicationId);
        query.setParameter("queueStatus", (Object)"E");
        query.setParameter("ipNumber", (Object)RiceUtilities.getIpNumber());
        if (maxDocuments != null) {
            query.setMaxResults(maxDocuments.intValue());
        }
        return query.getResultList();
    }

    @Override
    public void remove(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing message " + routeQueue);
        }
        if (routeQueue.getRouteQueueId() == null) {
            throw new RiceRuntimeException("can't delete a PersistedMessageBO with no id");
        }
        routeQueue = (PersistedMessageBO)this.entityManager.merge((Object)routeQueue);
        this.entityManager.remove((Object)routeQueue);
        if (routeQueue.getPayload() != null) {
            PersistedMessagePayload payload = (PersistedMessagePayload)this.entityManager.merge((Object)routeQueue.getPayload());
            this.entityManager.remove((Object)payload);
        }
    }

    @Override
    public PersistedMessageBO save(PersistedMessageBO routeQueue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Persisting message " + routeQueue);
        }
        routeQueue = (PersistedMessageBO)this.entityManager.merge((Object)routeQueue);
        this.entityManager.flush();
        PersistedMessagePayload payload = routeQueue.getPayload();
        if (payload != null) {
            payload.setRouteQueueId(routeQueue.getRouteQueueId());
            payload = (PersistedMessagePayload)this.entityManager.merge((Object)payload);
            this.entityManager.flush();
            routeQueue.setPayload(payload);
        }
        return routeQueue;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

