/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.UifKeyValueLocation;
import org.kuali.rice.krad.uif.util.UifOptionGroupLabel;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

public abstract class MultiValueControlBase
extends ControlBase
implements MultiValueControl {
    private static final long serialVersionUID = -8691367056245775455L;
    private List<KeyValue> options;
    private List<KeyMessage> richOptions;
    private List<Component> inlineComponents;
    private List<Message> internalMessageComponents;
    private boolean locationSelect = false;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        this.getStyleClassesAsString();
        if (this.options != null && this.richOptions == null) {
            this.richOptions = new ArrayList<KeyMessage>();
            this.internalMessageComponents = new ArrayList<Message>();
            for (KeyValue option : this.options) {
                String value;
                if (option instanceof UifOptionGroupLabel) continue;
                Message message = ComponentFactory.getMessage();
                String key = option.getKey();
                if (key.contains("@{")) {
                    key = ViewLifecycle.getExpressionEvaluator().evaluateExpression(this.getContext(), key).toString();
                }
                if ((value = option.getValue()).contains("@{")) {
                    value = ViewLifecycle.getExpressionEvaluator().evaluateExpression(this.getContext(), value).toString();
                }
                message.setMessageText(value);
                message.setInlineComponents(this.inlineComponents);
                message.setRenderWrapperTag(false);
                if (AbstractKeyValue.class.isAssignableFrom(option.getClass()) && ((AbstractKeyValue)option).isDisabled()) {
                    this.richOptions.add(new KeyMessage(key, value, message, ((AbstractKeyValue)option).isDisabled()));
                } else {
                    this.richOptions.add(new KeyMessage(key, value, message));
                }
                this.internalMessageComponents.add(message);
            }
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        View view = ViewLifecycle.getView();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        if (this.options != null && !this.options.isEmpty()) {
            for (KeyValue option : this.options) {
                if (!(option instanceof UifKeyValueLocation)) continue;
                this.locationSelect = true;
                UrlInfo url = ((UifKeyValueLocation)option).getLocation();
                ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(url, false);
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, url, view.getContext());
            }
        }
        if (this.richOptions == null || this.richOptions.isEmpty()) {
            return;
        }
        for (KeyMessage richOption : this.richOptions) {
            List<Component> components = richOption.getMessage().getMessageComponentStructure();
            if (components == null || components.isEmpty()) continue;
            for (Component c : components) {
                if (!(c instanceof Container) && !(c instanceof InputField)) continue;
                c.addDataAttribute("parent", parent.getId());
            }
        }
    }

    @Override
    @BeanTagAttribute
    public List<KeyValue> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(List<KeyValue> options) {
        this.options = options;
    }

    @BeanTagAttribute
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public List<KeyMessage> getRichOptions() {
        return this.richOptions;
    }

    public void setRichOptions(List<KeyMessage> richOptions) {
        this.richOptions = richOptions;
    }

    public List<Message> getInternalMessageComponents() {
        return this.internalMessageComponents;
    }

    public boolean isLocationSelect() {
        return this.locationSelect;
    }

    protected void setLocationSelect(boolean locationSelect) {
        this.locationSelect = locationSelect;
    }
}

