/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.initialize;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;

public class InitializeDataFieldFromDictionaryTask
extends ViewLifecycleTaskBase<DataField> {
    public InitializeDataFieldFromDictionaryTask() {
        super(DataField.class);
    }

    @Override
    protected void performLifecycleTask() {
        InputField inputField;
        DataField field = (DataField)this.getElementState().getElement();
        AttributeDefinition attributeDefinition = null;
        String dictionaryAttributeName = field.getDictionaryAttributeName();
        String dictionaryObjectEntry = field.getDictionaryObjectEntry();
        Map<String, String> propertyExpressions = field.getPropertyExpressions();
        if (dictionaryAttributeName == null && propertyExpressions.containsKey("dictionaryAttributeName")) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            dictionaryAttributeName = propertyExpressions.get("dictionaryAttributeName");
            if (dictionaryAttributeName.contains("#dp.")) {
                dictionaryAttributeName = dictionaryAttributeName.replace("#dp.", "");
            } else if (dictionaryAttributeName.contains("#lp.")) {
                List collection = (List)ObjectPropertyUtils.getPropertyValue(ViewLifecycle.getModel(), field.getBindingInfo().getCollectionPath());
                dictionaryAttributeName = !collection.isEmpty() ? dictionaryAttributeName.replace("#lp.", field.getBindingInfo().getCollectionPath() + "[0].") : null;
            }
            dictionaryAttributeName = (String)expressionEvaluator.evaluateExpression(field.getContext(), dictionaryAttributeName);
        }
        if (dictionaryAttributeName != null || !propertyExpressions.containsKey("dictionaryAttributeName")) {
            if (StringUtils.isNotBlank((String)dictionaryObjectEntry) && StringUtils.isBlank((String)dictionaryAttributeName)) {
                dictionaryAttributeName = field.getPropertyName();
            }
            if (StringUtils.isNotBlank((String)dictionaryAttributeName) && StringUtils.isNotBlank((String)dictionaryObjectEntry)) {
                attributeDefinition = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeDefinition(dictionaryObjectEntry, dictionaryAttributeName);
            }
            if (attributeDefinition == null) {
                String propertyPath;
                BindingInfo fieldBindingInfo = field.getBindingInfo();
                String collectionPath = fieldBindingInfo.getCollectionPath();
                if (StringUtils.isNotBlank((String)collectionPath)) {
                    StringBuilder propertyPathBuilder = new StringBuilder();
                    String bindingObjectPath = fieldBindingInfo.getBindingObjectPath();
                    if (StringUtils.isNotBlank((String)bindingObjectPath)) {
                        propertyPathBuilder.append(bindingObjectPath).append('.');
                    }
                    propertyPathBuilder.append(collectionPath).append('.');
                    String bindByNamePrefix = fieldBindingInfo.getBindByNamePrefix();
                    if (StringUtils.isNotBlank((String)bindByNamePrefix) && !bindByNamePrefix.startsWith(collectionPath)) {
                        propertyPathBuilder.append(bindByNamePrefix).append('.');
                    }
                    propertyPathBuilder.append(fieldBindingInfo.getBindingName());
                    propertyPath = propertyPathBuilder.toString();
                } else {
                    propertyPath = field.getBindingInfo().getBindingPath();
                }
                attributeDefinition = this.findNestedDictionaryAttribute(propertyPath);
            }
            if (attributeDefinition != null) {
                field.copyFromAttributeDefinition(attributeDefinition);
            }
        }
        if (field instanceof InputField && (inputField = (InputField)field).getControl() == null) {
            inputField.setControl(ComponentFactory.getTextControl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDictionaryEntryName(String dictionaryEntryPrefix) {
        if (StringUtils.isEmpty((String)dictionaryEntryPrefix)) {
            return dictionaryEntryPrefix;
        }
        Map<String, Class<?>> modelClasses = ViewLifecycle.getView().getObjectPathToConcreteClassMapping();
        Class<?> dictionaryModelClass = modelClasses.get(dictionaryEntryPrefix);
        if (dictionaryModelClass != null) {
            return dictionaryModelClass.getName();
        }
        Class<?> modelClass = null;
        String modelProperty = dictionaryEntryPrefix;
        int bestMatchLength = 0;
        int modelClassPathLength = dictionaryEntryPrefix.length();
        Map<String, Class<?>> map = modelClasses;
        synchronized (map) {
            for (Map.Entry<String, Class<?>> modelClassEntry : modelClasses.entrySet()) {
                String path = modelClassEntry.getKey();
                int pathlen = path.length();
                if (!dictionaryEntryPrefix.startsWith(path) || pathlen <= bestMatchLength || modelClassPathLength <= pathlen || dictionaryEntryPrefix.charAt(pathlen) != '.') continue;
                bestMatchLength = pathlen;
                modelClass = modelClassEntry.getValue();
                modelProperty = dictionaryEntryPrefix.substring(pathlen + 1);
            }
        }
        if (modelClass != null) {
            dictionaryModelClass = ObjectPropertyUtils.getPropertyType(modelClass, modelProperty);
        }
        if (dictionaryModelClass == null) {
            dictionaryModelClass = ObjectPropertyUtils.getPropertyType(ViewLifecycle.getModel(), dictionaryEntryPrefix);
        }
        return dictionaryModelClass == null ? null : dictionaryModelClass.getName();
    }

    protected AttributeDefinition findNestedDictionaryAttribute(String propertyPath) {
        DataField field = (DataField)this.getElementState().getElement();
        Object fieldBindingPrefix = null;
        String dictionaryAttributePath = propertyPath;
        if (field.getBindingInfo().isBindToMap()) {
            fieldBindingPrefix = "";
            if (!field.getBindingInfo().isBindToForm() && StringUtils.isNotBlank((String)field.getBindingInfo().getBindingObjectPath())) {
                fieldBindingPrefix = field.getBindingInfo().getBindingObjectPath();
            }
            if (StringUtils.isNotBlank((String)field.getBindingInfo().getBindByNamePrefix())) {
                fieldBindingPrefix = StringUtils.isNotBlank((String)fieldBindingPrefix) ? (String)fieldBindingPrefix + "." + field.getBindingInfo().getBindByNamePrefix() : field.getBindingInfo().getBindByNamePrefix();
            }
            dictionaryAttributePath = field.getBindingInfo().getBindingName();
        }
        if (StringUtils.isEmpty((String)dictionaryAttributePath)) {
            return null;
        }
        if (StringUtils.startsWith((String)dictionaryAttributePath, (String)"rangeLowerBoundKeyPrefix_")) {
            dictionaryAttributePath = StringUtils.substringAfter((String)dictionaryAttributePath, (String)"rangeLowerBoundKeyPrefix_");
        }
        DataDictionaryService ddService = KRADServiceLocatorWeb.getDataDictionaryService();
        String dictionaryAttributeName = ObjectPropertyUtils.getCanonicalPath(dictionaryAttributePath);
        Object dictionaryEntryPrefix = fieldBindingPrefix;
        AttributeDefinition attribute = null;
        String dictionaryEntryName = null;
        int i = dictionaryAttributeName.indexOf(46);
        while (attribute == null && i != -1) {
            if (dictionaryEntryPrefix != null) {
                dictionaryEntryName = this.getDictionaryEntryName((String)dictionaryEntryPrefix);
                dictionaryEntryPrefix = (String)dictionaryEntryPrefix + "." + dictionaryAttributeName.substring(0, i);
            } else {
                dictionaryEntryName = null;
                dictionaryEntryPrefix = dictionaryAttributeName.substring(0, i);
            }
            if (dictionaryEntryName != null) {
                attribute = ddService.getAttributeDefinition(dictionaryEntryName, dictionaryAttributeName);
            }
            if (attribute != null) continue;
            dictionaryAttributeName = dictionaryAttributeName.substring(i + 1);
            i = dictionaryAttributeName.indexOf(46);
        }
        if (attribute == null && dictionaryEntryPrefix != null && (dictionaryEntryName = this.getDictionaryEntryName((String)dictionaryEntryPrefix)) != null) {
            attribute = ddService.getAttributeDefinition(dictionaryEntryName, dictionaryAttributeName);
        }
        if (attribute != null) {
            field.setDictionaryObjectEntry(dictionaryEntryName);
            field.setDictionaryAttributeName(dictionaryAttributeName);
        }
        return attribute;
    }
}

