/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.IncidentReportForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class UifHandlerExceptionResolver
implements HandlerExceptionResolver {
    private static final Logger LOG = LogManager.getLogger(UifHandlerExceptionResolver.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UifFormManager uifFormManager;
        LOG.error("The following error was caught by the UifHandlerExceptionResolver : ", (Throwable)ex);
        LOG.error(ex.getMessage(), (Throwable)ex);
        String incidentDocId = request.getParameter("document.documentNumber");
        String incidentViewId = "";
        UifFormBase form = (UifFormBase)request.getAttribute("requestForm");
        if (form instanceof DocumentFormBase) {
            if (((DocumentFormBase)form).getDocument() != null) {
                incidentDocId = ((DocumentFormBase)form).getDocument().getDocumentNumber();
            }
            incidentViewId = ((DocumentFormBase)form).getViewId();
        }
        if ((uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager")) == null) {
            uifFormManager = new UifFormManager();
            request.getSession().setAttribute("formManager", (Object)uifFormManager);
            GlobalVariables.setUifFormManager(uifFormManager);
        } else {
            uifFormManager.removeSessionForm(form);
        }
        UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
        IncidentReportForm incidentReportForm = new IncidentReportForm();
        incidentReportForm.preBind(request);
        incidentReportForm.setSessionId(request.getSession().getId());
        String postUrl = ConfigContext.getCurrentContextConfig().getProperty("krad.url") + "/incidentReport";
        incidentReportForm.setException(ex);
        incidentReportForm.setIncidentDocId(incidentDocId);
        incidentReportForm.setIncidentViewId(incidentViewId);
        incidentReportForm.setController(handler.getClass().toString());
        if (userSession != null) {
            incidentReportForm.setUserId(userSession.getPrincipalId());
            incidentReportForm.setUserName(userSession.getPrincipalName());
            incidentReportForm.setUserEmail(userSession.getPerson().getEmailAddress());
        }
        incidentReportForm.setDevMode(!KRADUtils.isProductionEnvironment());
        incidentReportForm.setViewId("Uif-IncidentReportView");
        if (form != null) {
            incidentReportForm.setAjaxRequest(form.isAjaxRequest());
        } else {
            String ajaxRequestParm = request.getParameter("ajaxRequest");
            if (StringUtils.isNotBlank((String)ajaxRequestParm)) {
                incidentReportForm.setAjaxRequest(Boolean.parseBoolean(ajaxRequestParm));
            }
        }
        incidentReportForm.setView(this.getViewService().getViewById("Uif-IncidentReportView"));
        incidentReportForm.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEVIEW.getKey());
        incidentReportForm.postBind(request);
        incidentReportForm.setFormPostUrl(postUrl);
        incidentReportForm.setFormKey(UUID.randomUUID().toString());
        uifFormManager.addSessionForm(incidentReportForm);
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)incidentReportForm, "");
        try {
            this.getModelAndViewService().prepareView(request, modelAndView);
        }
        catch (Exception e) {
            LOG.error("An error stopped the incident form from loading", (Throwable)e);
        }
        return modelAndView;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    protected ModelAndViewService getModelAndViewService() {
        return KRADServiceLocatorWeb.getModelAndViewService();
    }
}

