/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.service.NotificationChannelService;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class UserPreferenceServiceImpl
implements UserPreferenceService {
    private NotificationChannelService notificationChannelService;
    private DataObjectService dataObjectService;
    private static final Logger LOG = LogManager.getLogger(UserPreferenceServiceImpl.class);

    public UserPreferenceServiceImpl(DataObjectService dataObjectService, NotificationChannelService notificationChannelService) {
        this.dataObjectService = dataObjectService;
        this.notificationChannelService = notificationChannelService;
    }

    @Override
    public Collection<UserChannelSubscriptionBo> getCurrentSubscriptions(String userid) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"userId", (Object)userid)});
        return this.dataObjectService.findMatching(UserChannelSubscriptionBo.class, criteria.build()).getResults();
    }

    @Override
    public UserChannelSubscriptionBo getSubscription(String channelid, String userid) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"channel.id", (Object)channelid), PredicateFactory.equal((String)"userId", (Object)userid)});
        List subscriptions = this.dataObjectService.findMatching(UserChannelSubscriptionBo.class, criteria.build()).getResults();
        if (!subscriptions.isEmpty() && subscriptions.size() == 1) {
            return (UserChannelSubscriptionBo)((Object)subscriptions.get(0));
        }
        return null;
    }

    @Override
    public void subscribeToChannel(UserChannelSubscriptionBo userChannelSubscription) {
        LOG.info("Saving channel subscription");
        try {
            this.dataObjectService.save((Object)userChannelSubscription, new PersistenceOption[0]);
        }
        catch (Exception e) {
            LOG.error("Exception when saving userChannelSubscription", (Throwable)e);
        }
        LOG.debug("Channel subscription saved");
    }

    @Override
    public void unsubscribeFromChannel(UserChannelSubscriptionBo userChannelSubscription) {
        LOG.info("unsubscribing from channel");
        try {
            this.dataObjectService.delete((Object)userChannelSubscription);
        }
        catch (Exception e) {
            LOG.error("Exception when deleting userChannelSubscription", (Throwable)e);
        }
    }
}

