/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.web.form.HistoryFlow;

public class HistoryManager
implements Serializable {
    private static final long serialVersionUID = 7612500634309569727L;
    private Map<String, HistoryFlow> historyFlowMap = new HashMap<String, HistoryFlow>();
    private Map<String, HistoryFlow> recentFlows = new HashMap<String, HistoryFlow>();

    public HistoryFlow process(String flowKey, String formKey, String currentUrl) {
        if (StringUtils.isBlank((String)flowKey) || flowKey.equalsIgnoreCase("start")) {
            flowKey = UUID.randomUUID().toString();
        }
        HistoryFlow newFlow = new HistoryFlow(flowKey);
        if (((String)currentUrl).contains("?") && !((String)currentUrl).contains("formKey") && StringUtils.isNotBlank((String)formKey)) {
            currentUrl = (String)currentUrl + "&formKey=" + formKey;
        }
        if (this.getMostRecentFlowByFormKey(flowKey, formKey) != null) {
            newFlow = this.getMostRecentFlowByFormKey(flowKey, formKey);
            newFlow.update((String)currentUrl);
        } else if (StringUtils.isNotBlank((String)flowKey)) {
            HistoryFlow recentFlow = this.recentFlows.get(flowKey);
            newFlow.continueFlow(recentFlow);
            newFlow.push((String)currentUrl);
        }
        this.recentFlows.put(flowKey, newFlow);
        this.historyFlowMap.put(flowKey + "@@" + formKey, newFlow);
        return newFlow;
    }

    public HistoryFlow getMostRecentFlowByKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        return this.recentFlows.get(key);
    }

    public HistoryFlow getMostRecentFlowByFormKey(String key, String formKey) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)formKey)) {
            return null;
        }
        return this.historyFlowMap.get(key + "@@" + formKey);
    }
}

