/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrderByClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;

public class OrderByItemStateObject
extends AbstractStateObject {
    private OrderByItem.Ordering ordering;
    private StateObject stateObject;
    public static final String ORDERING_PROPERTY = "ordering";
    public static final String STATE_OBJECT_PROPERTY = "stateObject";

    public OrderByItemStateObject(OrderByClauseStateObject parent) {
        super(parent);
    }

    public OrderByItemStateObject(OrderByClauseStateObject parent, OrderByItem.Ordering ordering) {
        super(parent);
        this.validateOrdering(ordering);
        this.ordering = ordering;
    }

    public OrderByItemStateObject(OrderByClauseStateObject parent, StateObject stateObject, OrderByItem.Ordering ordering) {
        this(parent, ordering);
        this.stateObject = this.parent(stateObject);
    }

    public OrderByItemStateObject(OrderByClauseStateObject parent, String jpqlFragment, OrderByItem.Ordering ordering) {
        this(parent, ordering);
        this.parse(jpqlFragment);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
    }

    @Override
    public OrderByItem getExpression() {
        return (OrderByItem)super.getExpression();
    }

    public OrderByItem.Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public OrderByClauseStateObject getParent() {
        return (OrderByClauseStateObject)super.getParent();
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    public boolean isAscending() {
        return this.ordering == OrderByItem.Ordering.ASC;
    }

    public boolean isDefault() {
        return this.ordering == OrderByItem.Ordering.DEFAULT;
    }

    public boolean isDescending() {
        return this.ordering == OrderByItem.Ordering.DESC;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            OrderByItemStateObject orderByItem = (OrderByItemStateObject)stateObject;
            return this.ordering == orderByItem.ordering && this.areEquivalent(stateObject, orderByItem.stateObject);
        }
        return false;
    }

    public void parse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "orderby_item");
        this.setStateObject((StateObject)stateObject);
    }

    public void removeOrdering() {
        this.setOrdering(OrderByItem.Ordering.DEFAULT);
    }

    public void setExpression(OrderByItem expression) {
        super.setExpression(expression);
    }

    public void setOrdering(OrderByItem.Ordering ordering) {
        this.validateOrdering(ordering);
        OrderByItem.Ordering oldOrdering = this.ordering;
        this.ordering = ordering;
        this.firePropertyChanged(ORDERING_PROPERTY, (Object)oldOrdering, (Object)ordering);
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stateObject != null) {
            this.stateObject.toString(writer);
        }
        if (!this.isDefault()) {
            writer.append(' ');
            writer.append(this.ordering.name());
        }
    }

    private void validateOrdering(OrderByItem.Ordering ordering) {
        Assert.isNotNull((Object)ordering, "The Ordering cannot be null");
    }
}

