/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.bo;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.iacuc.bo.IacucOrganizationCorrespondent;
import org.kuali.kra.iacuc.correspondence.IacucCorrespondentType;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucOrganizationCorrespondentMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = 7781035495216633332L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final String ORGANIZATION_ID_INVALID_ERROR_KEY = "error.protocolLocation.organizationId.invalid";
    private static final String PRINCIPAL_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.principalId";
    private static final String CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY = "error.invalid.organizationCorrespondent.correspondentType";

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            IacucOrganizationCorrespondent organizationCorrespondent = (IacucOrganizationCorrespondent)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            organizationCorrespondent.setPersonId(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        IacucOrganizationCorrespondent organizationCorrespondent = (IacucOrganizationCorrespondent)this.businessObject;
        if (!this.isOrganizationIdValid(organizationCorrespondent.getOrganizationId())) {
            this.reportInvalidOrganizationId(organizationCorrespondent);
        }
        if (!this.isCorrespondentTypeCodeValid(organizationCorrespondent.getCorrespondentTypeCode())) {
            this.reportInvalidCorrespondentTypeCode(organizationCorrespondent);
        }
        if (!this.isValidPrincipalId(organizationCorrespondent.getPersonId())) {
            this.reportInvalidPrincipalId(organizationCorrespondent);
        }
        super.prepareForSave();
    }

    private void reportInvalidOrganizationId(IacucOrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.organizationId", ORGANIZATION_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidPrincipalId(IacucOrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.person.userName", PRINCIPAL_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidCorrespondentTypeCode(IacucOrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.correspondentTypeCode", CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY, new String[0]);
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        KcPersonService personService = KcServiceLocator.getService(KcPersonService.class);
        if (StringUtils.isEmpty((CharSequence)principalId)) {
            valid = false;
        } else {
            KcPerson person = personService.getKcPersonByPersonId(principalId);
            if (person == null) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isOrganizationIdValid(String organizationId) {
        BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("organizationId", organizationId);
        return !businessObjectService.findMatching(Organization.class, validParams).isEmpty();
    }

    private boolean isCorrespondentTypeCodeValid(Integer correspondentTypeCode) {
        BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("correspondentTypeCode", correspondentTypeCode.toString());
        return !businessObjectService.findMatching(IacucCorrespondentType.class, validParams).isEmpty();
    }
}

