/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subawardReporting.printing.xmlstream;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.ContactUsage;
import org.kuali.kra.award.printing.schema.AwardHeaderType;
import org.kuali.kra.award.printing.schema.AwardType;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardForms;
import org.kuali.kra.subaward.bo.SubAwardReportType;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.kra.subaward.bo.SubAwardTemplateInfo;
import org.kuali.kra.subaward.lookup.keyvalue.SubawardTemplateContactFinder;
import org.kuali.kra.subaward.printing.schema.OrganizationType;
import org.kuali.kra.subaward.printing.schema.PersonDetailsType;
import org.kuali.kra.subaward.printing.schema.RolodexDetailsType;
import org.kuali.kra.subaward.printing.schema.SubContractDataDocument;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class SubAwardFDPPrintXmlStream
implements XmlStream<SubContractDataDocument> {
    private static final String ORGANIZATION_ID = "organizationId";
    private static final String FDP_ORG_FROM_REQUISITIONER_UNIT = "FDP_ORG_FROM_REQUISITIONER_UNIT";
    public static final String CONTACT_TYPE_CODE = "contactTypeCode";
    public static final String AWARD_NUMBER = "awardNumber";
    public static final String ROLE_CODE = "roleCode";
    public static final String PRINCIPAL_INVESTIGATOR = "PI";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String AWARD_TITLE = "awardTitle";
    public static final String SPONSOR_AWARD_NUMBER = "sponsorAwardNumber";
    public static final String SPONSOR_NAME = "sponsorName";
    public static final String CFDA_NUMBER = "cfdaNumber";
    public static final String MODIFICATION_TYPE = "modificationType";
    public static final String FCOI = "fcoi";
    public static final String FAIN = "fain";
    public static final String FFATA = "ffata";
    public static final String PRIME_SPONSOR_NAME = "primeSponsorName";
    public static final String NOTICE_DATE = "noticeDate";
    public static final String FED_AWARD_DATE = "fedAwardDate";
    public static final String OBLIGATED_TOTAL = "obligatedTotal";
    public static final String ANTICIPATED_TOTAL = "anticipatedTotal";
    public static final String INVOICES_EMAILED = "invoicesEmailed";
    public static final String INVOICE_ADDRESS_DIFFERENT = "invoiceAddressDifferent";
    public static final String INVOICE_EMAIL_DIFFERENT = "invoiceEmailDifferent";
    public static final String FDP_PTE_INVOICE_EMAIL = "FDP_PTE_Invoice_email";
    public static final String FDP_PTE_INVOICE_ADDRESS = "FDP_PTE_Invoice_address";
    private static final String FDP_NIH_POLICY = "FDP_NIH_Policy";
    private static final String FDP_NIH_CFR = "FDP_NIH_CFR";
    private static final String FDP_NIH_GRANTS_POLICY_STATEMENT = "FDP_NIH_Grants_Policy_Statement";
    private static final String FDP_NIH_INTERIM_RESEARCH_TERMS = "FDP_NIH_Interim_Research_Terms";
    private static final String FDP_NIH_AGENCY_REQUIREMENTS = "FDP_NIH_Agency_Requirements";
    private static final String FDP_NIH_FCOI_GUIDANCE = "FDP_NIH_FCOI_Guidance";
    private static final String FDP_NSF_POLICY = "FDP_NSF_Policy";
    private static final String FDP_NSF_CFR = "FDP_NSF_CFR";
    private static final String FDP_NSF_GRANTS_POLICY_STATEMENT = "FDP_NSF_Grants_Policy_Statement";
    private static final String FDP_NSF_INTERIM_RESEARCH_TERMS = "FDP_NSF_Interim_Research_Terms";
    private static final String FDP_NSF_AGENCY_REQUIREMENTS = "FDP_NSF_Agency_Requirements";
    private static final String FDP_NSF_FCOI_GUIDANCE = "FDP_NSF_FCOI_Guidance";
    private static final String FDP_NASA_POLICY = "FDP_NASA_Policy";
    private static final String FDP_NASA_CFR = "FDP_NASA_CFR";
    private static final String FDP_NASA_GRANTS_POLICY_STATEMENT = "FDP_NASA_Grants_Policy_Statement";
    private static final String FDP_NASA_INTERIM_RESEARCH_TERMS = "FDP_NASA_Interim_Research_Terms";
    private static final String FDP_NASA_AGENCY_REQUIREMENTS = "FDP_NASA_Agency_Requirements";
    private static final String FDP_NASA_FCOI_GUIDANCE = "FDP_NASA_FCOI_Guidance";
    private static final String FDP_ONR_POLICY = "FDP_ONR_Policy";
    private static final String FDP_ONR_CFR = "FDP_ONR_CFR";
    private static final String FDP_ONR_GRANTS_POLICY_STATEMENT = "FDP_ONR_Grants_Policy_Statement";
    private static final String FDP_ONR_INTERIM_RESEARCH_TERMS = "FDP_ONR_Interim_Research_Terms";
    private static final String FDP_ONR_AGENCY_REQUIREMENTS = "FDP_ONR_Agency_Requirements";
    private static final String FDP_ONR_FCOI_GUIDANCE = "FDP_ONR_FCOI_Guidance";
    private static final String FDP_ARO_POLICY = "FDP_ARO_Policy";
    private static final String FDP_ARO_CFR = "FDP_ARO_CFR";
    private static final String FDP_ARO_GRANTS_POLICY_STATEMENT = "FDP_ARO_Grants_Policy_Statement";
    private static final String FDP_ARO_INTERIM_RESEARCH_TERMS = "FDP_ARO_Interim_Research_Terms";
    private static final String FDP_ARO_AGENCY_REQUIREMENTS = "FDP_ARO_Agency_Requirements";
    private static final String FDP_ARO_FCOI_GUIDANCE = "FDP_ARO_FCOI_Guidance";
    private static final String FDP_AFOSR_POLICY = "FDP_AFOSR_Policy";
    private static final String FDP_AFOSR_CFR = "FDP_AFOSR_CFR";
    private static final String FDP_AFOSR_GRANTS_POLICY_STATEMENT = "FDP_AFOSR_Grants_Policy_Statement";
    private static final String FDP_AFOSR_INTERIM_RESEARCH_TERMS = "FDP_AFOSR_Interim_Research_Terms";
    private static final String FDP_AFOSR_AGENCY_REQUIREMENTS = "FDP_AFOSR_Agency_Requirements";
    private static final String FDP_AFOSR_FCOI_GUIDANCE = "FDP_AFOSR_FCOI_Guidance";
    private static final String FDP_EPA_POLICY = "FDP_EPA_Policy";
    private static final String FDP_EPA_CFR = "FDP_EPA_CFR";
    private static final String FDP_EPA_GRANTS_POLICY_STATEMENT = "FDP_EPA_Grants_Policy_Statement";
    private static final String FDP_EPA_INTERIM_RESEARCH_TERMS = "FDP_EPA_Interim_Research_Terms";
    private static final String FDP_EPA_AGENCY_REQUIREMENTS = "FDP_EPA_Agency_Requirements";
    private static final String FDP_EPA_FCOI_GUIDANCE = "FDP_EPA_FCOI_Guidance";
    private static final String FDP_AMRMC_POLICY = "FDP_AMRAA_Policy";
    private static final String FDP_AMRMC_CFR = "FDP_AMRAA_CFR";
    private static final String FDP_AMRMC_GRANTS_POLICY_STATEMENT = "FDP_AMRMC_Grants_Policy_Statement";
    private static final String FDP_AMRMC_INTERIM_RESEARCH_TERMS = "FDP_AMRMC_Interim_Research_Terms";
    private static final String FDP_AMRMC_AGENCY_REQUIREMENTS = "FDP_AMRMC_Agency_Requirements";
    private static final String FDP_AMRMC_FCOI_GUIDANCE = "FDP_AMRMC_FCOI_Guidance";
    private static final String FDP_AMRAA_POLICY = "FDP_AMRMC_Policy";
    private static final String FDP_AMRAA_CFR = "FDP_AMRMC_CFR";
    private static final String FDP_AMRAA_GRANTS_POLICY_STATEMENT = "FDP_AMRAA_Grants_Policy_Statement";
    private static final String FDP_AMRAA_INTERIM_RESEARCH_TERMS = "FDP_AMRAA_Interim_Research_Terms";
    private static final String FDP_AMRAA_AGENCY_REQUIREMENTS = "FDP_AMRAA_Agency_Requirements";
    private static final String FDP_AMRAA_FCOI_GUIDANCE = "FDP_AMRAA_FCOI_Guidance";
    private static final String FDP_USDA_POLICY = "FDP_USDA_Policy";
    private static final String FDP_USDA_CFR = "FDP_USDA_CFR";
    private static final String FDP_USDA_GRANTS_POLICY_STATEMENT = "FDP_USDA_Grants_Policy_Statement";
    private static final String FDP_USDA_INTERIM_RESEARCH_TERMS = "FDP_USDA_Interim_Research_Terms";
    private static final String FDP_USDA_AGENCY_REQUIREMENTS = "FDP_USDA_Agency_Requirements";
    private static final String FDP_USDA_FCOI_GUIDANCE = "FDP_USDA_FCOI_Guidance";
    private static final String FDP_SUBAWARD_BILATERAL_AGREEMENTS = "FDP_Subaward_Bilateral_Agreements";
    private static final String TYPE_CODE = "typeCode";
    private BusinessObjectService businessObjectService;
    private CountryService countryService;
    private StateService stateService;
    private ConfigurationService configurationService;
    private String awardNumber;
    private String awardTitle;
    private String sponsorAwardNumber;
    private String sponsorName;
    private String cfdaNumber;
    private String fain;
    private String modificationType;
    private Boolean fcoi;
    private Boolean ffata;
    private Boolean invoicesEmailed;
    private Boolean invoiceAddressDifferent;
    private Boolean invoiceEmailDifferent;
    private String primeSponsorName;
    private Calendar noticeDate;
    private Calendar fedAwardDate;
    private BigDecimal obligatedTotal;
    private BigDecimal anticipatedTotal;
    private List<SubAwardForms> sponsorTemplates;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;

    @Override
    public Class<SubContractDataDocument> type() {
        return SubContractDataDocument.class;
    }

    @Override
    public Map<String, SubContractDataDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        this.awardNumber = (String)reportParameters.get(AWARD_NUMBER);
        this.awardTitle = (String)reportParameters.get(AWARD_TITLE);
        this.sponsorAwardNumber = (String)reportParameters.get(SPONSOR_AWARD_NUMBER);
        this.sponsorName = (String)reportParameters.get(SPONSOR_NAME);
        this.cfdaNumber = (String)reportParameters.get(CFDA_NUMBER);
        this.sponsorTemplates = (List)reportParameters.get("Selected Templates");
        this.modificationType = (String)reportParameters.get(MODIFICATION_TYPE);
        this.fcoi = (Boolean)reportParameters.get(FCOI);
        this.fain = (String)reportParameters.get(FAIN);
        this.ffata = (Boolean)reportParameters.get(FFATA);
        this.invoicesEmailed = (Boolean)reportParameters.get(INVOICES_EMAILED);
        this.invoiceAddressDifferent = (Boolean)reportParameters.get(INVOICE_ADDRESS_DIFFERENT);
        this.invoiceEmailDifferent = (Boolean)reportParameters.get(INVOICE_EMAIL_DIFFERENT);
        this.primeSponsorName = (String)reportParameters.get(PRIME_SPONSOR_NAME);
        this.noticeDate = (Calendar)reportParameters.get(NOTICE_DATE);
        this.fedAwardDate = (Calendar)reportParameters.get(FED_AWARD_DATE);
        this.obligatedTotal = (BigDecimal)reportParameters.get(OBLIGATED_TOTAL);
        this.anticipatedTotal = (BigDecimal)reportParameters.get(ANTICIPATED_TOTAL);
        SubAward subaward = (SubAward)printableBusinessObject;
        SubContractDataDocument.SubContractData subContractData = SubContractDataDocument.SubContractData.Factory.newInstance();
        this.setOtherConfigInfo(subContractData);
        this.setSubcontractTemplateInfo(subContractData, subaward);
        this.setSubcontractDetail(subContractData, subaward);
        this.setSubcontractAmountInfo(subContractData, subaward);
        this.setAwardHeader(subContractData);
        this.setPrimeRecipientContacts(subContractData, subaward);
        this.setPrintRequirement(subContractData);
        this.setPrimeAdministrativeContact(subContractData, subaward);
        this.setPrimePrincipalInvestigator(subContractData);
        this.setPrimeFinancialContact(subContractData, subaward);
        this.setPrimeAuthorizedOfficial(subContractData, subaward);
        this.setAdministrativeContact(subContractData, subaward);
        this.setFinancialContact(subContractData, subaward);
        this.setAuthorizedOfficial(subContractData, subaward);
        this.setSubcontractReports(subContractData, subaward);
        SubContractDataDocument subContractDataDoc = SubContractDataDocument.Factory.newInstance();
        subContractDataDoc.setSubContractData(subContractData);
        LinkedHashMap<String, SubContractDataDocument> xmlObjectList = new LinkedHashMap<String, SubContractDataDocument>();
        xmlObjectList.put(SubAwardPrintType.SUB_AWARD_FDP_TEMPLATE.getSubAwardPrintType(), subContractDataDoc);
        return xmlObjectList;
    }

    public void setOtherConfigInfo(SubContractDataDocument.SubContractData subContractData) {
        SubContractDataDocument.SubContractData.OtherConfigInfo otherConfigInfo = SubContractDataDocument.SubContractData.OtherConfigInfo.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.OtherConfigInfo> otherConfigInfoList = new ArrayList<SubContractDataDocument.SubContractData.OtherConfigInfo>();
        otherConfigInfo.setFdpNihPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_POLICY));
        otherConfigInfo.setFdpNihCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_CFR));
        otherConfigInfo.setFdpNihGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpNihInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpNihAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpNihFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NIH_FCOI_GUIDANCE));
        otherConfigInfo.setFdpNsfPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_POLICY));
        otherConfigInfo.setFdpNsfCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_CFR));
        otherConfigInfo.setFdpNsfGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpNsfInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpNsfAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpNsfFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NSF_FCOI_GUIDANCE));
        otherConfigInfo.setFdpNasaPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_POLICY));
        otherConfigInfo.setFdpNasaCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_CFR));
        otherConfigInfo.setFdpNasaGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpNasaInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpNasaAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpNasaFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_NASA_FCOI_GUIDANCE));
        otherConfigInfo.setFdpOnrPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_POLICY));
        otherConfigInfo.setFdpOnrCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_CFR));
        otherConfigInfo.setFdpOnrGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpOnrInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpOnrAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpOnrFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ONR_FCOI_GUIDANCE));
        otherConfigInfo.setFdpAroPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_POLICY));
        otherConfigInfo.setFdpAroCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_CFR));
        otherConfigInfo.setFdpAroGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpAroInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpAroAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpAroFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_ARO_FCOI_GUIDANCE));
        otherConfigInfo.setFdpAfosrPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_POLICY));
        otherConfigInfo.setFdpAfosrCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_CFR));
        otherConfigInfo.setFdpAfosrGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpAfosrInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpAfosrAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpAfosrFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AFOSR_FCOI_GUIDANCE));
        otherConfigInfo.setFdpEpaPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_POLICY));
        otherConfigInfo.setFdpEpaCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_CFR));
        otherConfigInfo.setFdpEpaGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpEpaInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpEpaAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpEpaFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_EPA_FCOI_GUIDANCE));
        otherConfigInfo.setFdpAmrmcPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_POLICY));
        otherConfigInfo.setFdpAmrmcCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_CFR));
        otherConfigInfo.setFdpAmrmcGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpAmrmcInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpAmrmcAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpAmrmcFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRMC_FCOI_GUIDANCE));
        otherConfigInfo.setFdpAmraaPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_POLICY));
        otherConfigInfo.setFdpAmraaCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_CFR));
        otherConfigInfo.setFdpAmraaGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpAmraaInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpAmraaAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpAmraaFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_AMRAA_FCOI_GUIDANCE));
        otherConfigInfo.setFdpUsdaPolicy(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_POLICY));
        otherConfigInfo.setFdpUsdaCfr(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_CFR));
        otherConfigInfo.setFdpUsdaGrantsPolicyStatement(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_GRANTS_POLICY_STATEMENT));
        otherConfigInfo.setFdpUsdaInterimResearchTerms(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_INTERIM_RESEARCH_TERMS));
        otherConfigInfo.setFdpUsdaAgencyRequirements(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_AGENCY_REQUIREMENTS));
        otherConfigInfo.setFdpUsdaFCoiGuidance(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_USDA_FCOI_GUIDANCE));
        otherConfigInfo.setFdpSubawardBilateralAgreements(this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "Document", FDP_SUBAWARD_BILATERAL_AGREEMENTS));
        otherConfigInfoList.add(otherConfigInfo);
        subContractData.setOtherConfigInfoArray(otherConfigInfoList.toArray(new SubContractDataDocument.SubContractData.OtherConfigInfo[0]));
    }

    public void setSubcontractTemplateInfo(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.SubcontractTemplateInfo subContractTemplateInfo = SubContractDataDocument.SubContractData.SubcontractTemplateInfo.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.SubcontractTemplateInfo> templateDataList = new ArrayList<SubContractDataDocument.SubContractData.SubcontractTemplateInfo>();
        if (subaward.getSubAwardTemplateInfo() != null && !subaward.getSubAwardTemplateInfo().isEmpty()) {
            SubAwardTemplateInfo subawardTemplate = subaward.getSubAwardTemplateInfo().get(0);
            if (subawardTemplate.getInvoiceOrPaymentContact() != null) {
                subContractTemplateInfo.setInvoiceOrPaymentContactCd(subawardTemplate.getInvoiceOrPaymentContact().toString());
            }
            if (subawardTemplate.getIrbIacucContact() != null) {
                subContractTemplateInfo.setIrbIacucContactCd(subawardTemplate.getIrbIacucContact().toString());
            }
            if (subawardTemplate.getFinalStmtOfCostscontact() != null) {
                subContractTemplateInfo.setFinalStmtOfCostsContactCd(subawardTemplate.getFinalStmtOfCostscontact().toString());
            }
            if (subawardTemplate.getChangeRequestsContact() != null) {
                subContractTemplateInfo.setChangeRequestsContactCd(subawardTemplate.getChangeRequestsContact().toString());
            }
            if (subawardTemplate.getTerminationContact() != null) {
                subContractTemplateInfo.setTerminationContactCd(subawardTemplate.getTerminationContact().toString());
            }
            if (subawardTemplate.getNoCostExtensionContact() != null) {
                subContractTemplateInfo.setNoCostExtensionContactCd(subawardTemplate.getNoCostExtensionContact().toString());
            }
            if (subawardTemplate.getCopyRightType() != null) {
                subContractTemplateInfo.setCopyRights(subawardTemplate.getCopyRightType().toString());
            }
            if (subawardTemplate.getAutomaticCarryForward() != null) {
                subContractTemplateInfo.setAutomaticCarryForward(this.toFlag(subawardTemplate.getAutomaticCarryForward()));
            }
            if (subawardTemplate.getTreatmentPrgmIncomeAdditive() != null) {
                subContractTemplateInfo.setTreatmentPrgmIncomeAdditive(this.toFlag(subawardTemplate.getTreatmentPrgmIncomeAdditive()));
            }
            subContractTemplateInfo.setRAndD(this.toFlag(subawardTemplate.getrAndD()));
            if (subawardTemplate.getFcioSubrecPolicyCd() != null) {
                subContractTemplateInfo.setFcioSubrecPolicyCd(subawardTemplate.getFcioSubrecPolicyCd());
            }
            subContractTemplateInfo.setAnimalFlag(this.toFlag(subawardTemplate.getAnimalFlag()));
            if (subawardTemplate.getAnimalPteSendCd() != null) {
                subContractTemplateInfo.setAnimalPteSendCd(subawardTemplate.getAnimalPteSendCd());
            }
            if (subawardTemplate.getAnimalPteNrCd() != null) {
                subContractTemplateInfo.setAnimalPteNrCd(subawardTemplate.getAnimalPteNrCd());
            }
            subContractTemplateInfo.setHumanFlag(this.toFlag(subawardTemplate.getHumanFlag()));
            if (subawardTemplate.getHumanPteSendCd() != null) {
                subContractTemplateInfo.setHumanPteSendCd(subawardTemplate.getHumanPteSendCd());
            }
            if (subawardTemplate.getHumanPteNrCd() != null) {
                subContractTemplateInfo.setHumanPteNrCd(subawardTemplate.getHumanPteNrCd());
            }
            if (subawardTemplate.getHumanDataExchangeAgreeCd() != null) {
                subContractTemplateInfo.setHumanDataExchangeAgreeCd(subawardTemplate.getHumanDataExchangeAgreeCd());
            }
            if (subawardTemplate.getHumanDataExchangeTermsCd() != null) {
                subContractTemplateInfo.setHumanDataExchangeTermsCd(subawardTemplate.getHumanDataExchangeTermsCd());
            }
            subContractTemplateInfo.setMpiAward(this.toFlag(subawardTemplate.getMpiAward()));
            if (subawardTemplate.getMpiLeadershipPlan() != null) {
                subContractTemplateInfo.setMpiLeadershipPlan(subawardTemplate.getMpiLeadershipPlan());
            }
            if (subawardTemplate.getAdditionalTerms() != null) {
                subContractTemplateInfo.setAdditionalTerms(subawardTemplate.getAdditionalTerms());
            }
            if (subawardTemplate.getTreatmentOfIncome() != null) {
                subContractTemplateInfo.setTreatmentOfIncome(subawardTemplate.getTreatmentOfIncome());
            }
            if (subawardTemplate.getDataSharingAttachment() != null) {
                subContractTemplateInfo.setDataSharingAttachment(subawardTemplate.getDataSharingAttachment());
            }
            if (subawardTemplate.getDataSharingCd() != null) {
                subContractTemplateInfo.setDataSharingCd(subawardTemplate.getDataSharingCd());
            }
            if (subawardTemplate.getFinalStatementDueCd() != null) {
                subContractTemplateInfo.setFinalStatementDueCd(subawardTemplate.getFinalStatementDueCd());
            }
            templateDataList.add(subContractTemplateInfo);
        }
        subContractData.setSubcontractTemplateInfoArray(templateDataList.toArray(new SubContractDataDocument.SubContractData.SubcontractTemplateInfo[0]));
    }

    public void setSubcontractDetail(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        List<SubAwardAmountInfo> subAwardAmountInfos;
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        RolodexDetailsType rolodexDetailsType = RolodexDetailsType.Factory.newInstance();
        if (subaward.getRolodex() != null) {
            subcontractDetail.setSiteInvestigator(subaward.getRolodex().getFullName());
            subcontractDetail.setSiteInvestigatorEmail(subaward.getRolodex().getEmailAddress());
        }
        subcontractDetail.setFsrsSubawardNumber(subaward.getFsrsSubawardNumber());
        if (subaward.getOrganization() != null) {
            subcontractDetail.setSubcontractorName(subaward.getOrganization().getOrganizationName());
            rolodexDetailsType.setAddress1(subaward.getOrganization().getRolodex().getAddressLine1());
            rolodexDetailsType.setAddress2(subaward.getOrganization().getRolodex().getAddressLine2());
            rolodexDetailsType.setAddress3(subaward.getOrganization().getRolodex().getAddressLine3());
            rolodexDetailsType.setCity(subaward.getOrganization().getRolodex().getCity());
            String countryCode = subaward.getOrganization().getRolodex().getCountryCode();
            String stateName = subaward.getOrganization().getRolodex().getState();
            rolodexDetailsType.setStateDescription(this.getStateName(countryCode, stateName));
            rolodexDetailsType.setPincode(subaward.getOrganization().getRolodex().getPostalCode());
        }
        if (subaward.getStartDate() != null) {
            subcontractDetail.setStartDate(this.getDateTimeService().getCalendar((Date)subaward.getStartDate()));
        }
        if (subaward.getEndDate() != null) {
            subcontractDetail.setEndDate(this.getDateTimeService().getCalendar((Date)subaward.getEndDate()));
        }
        if ((subAwardAmountInfos = subaward.getSubAwardAmountInfoList()) != null && !subAwardAmountInfos.isEmpty()) {
            SubAwardAmountInfo lastSubAwardAmountInfo = subAwardAmountInfos.get(subAwardAmountInfos.size() - 1);
            subcontractDetail.setComments(lastSubAwardAmountInfo.getComments());
            subcontractDetail.setModificationType(lastSubAwardAmountInfo.getModificationTypeCode());
        }
        subcontractDetail.setSubcontractorOrgRolodexDetails(rolodexDetailsType);
        if (this.fcoi != null) {
            subcontractDetail.setPHSFCOI(this.toFlag(this.fcoi));
        }
        if (this.ffata != null) {
            subcontractDetail.setFFATA(this.toFlag(this.ffata));
        }
        subContractData.setSubcontractDetail(subcontractDetail);
    }

    private Optional<Date> getPeriodOfPerformanceEndDate(SubAward subaward) {
        List<SubAwardAmountInfo> subAwardAmountInfoList = subaward.getSubAwardAmountInfoList();
        return subAwardAmountInfoList.isEmpty() ? Optional.empty() : Optional.ofNullable(subAwardAmountInfoList.get(subAwardAmountInfoList.size() - 1).getPeriodofPerformanceEndDate());
    }

    private Optional<Date> getPeriodOfPerformanceStartDate(SubAward subaward) {
        List<SubAwardAmountInfo> subAwardAmountInfoList = subaward.getSubAwardAmountInfoList();
        return subAwardAmountInfoList.isEmpty() ? Optional.empty() : Optional.ofNullable(subAwardAmountInfoList.get(subAwardAmountInfoList.size() - 1).getPeriodofPerformanceStartDate());
    }

    private String toFlag(Boolean b) {
        return Boolean.TRUE.equals(b) ? "Y" : "N";
    }

    public void setSubcontractAmountInfo(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.SubcontractAmountInfo subContractAmountInfo = SubContractDataDocument.SubContractData.SubcontractAmountInfo.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.SubcontractAmountInfo> amountinfoList = new ArrayList<SubContractDataDocument.SubContractData.SubcontractAmountInfo>();
        List<SubAwardAmountInfo> subAwardAmountInfoList = subaward.getSubAwardAmountInfoList();
        if (subAwardAmountInfoList != null && !subAwardAmountInfoList.isEmpty()) {
            subContractAmountInfo.setObligatedAmount(subaward.getTotalObligatedAmount().bigDecimalValue());
            subContractAmountInfo.setAnticipatedAmount(subaward.getTotalAnticipatedAmount().bigDecimalValue());
            SubAwardAmountInfo lastSubAwardAmountInfo = subAwardAmountInfoList.get(subAwardAmountInfoList.size() - 1);
            if (lastSubAwardAmountInfo.getObligatedChange() != null) {
                subContractAmountInfo.setObligatedChange(lastSubAwardAmountInfo.getObligatedChange().bigDecimalValue());
            }
            if (lastSubAwardAmountInfo.getObligatedChangeDirect() != null) {
                subContractAmountInfo.setObligatedChangeDirect(lastSubAwardAmountInfo.getObligatedChangeDirect().bigDecimalValue());
                subContractAmountInfo.setObligatedChange(lastSubAwardAmountInfo.getObligatedChangeDirect().bigDecimalValue());
            }
            if (lastSubAwardAmountInfo.getObligatedChangeIndirect() != null) {
                subContractAmountInfo.setObligatedChangeIndirect(lastSubAwardAmountInfo.getObligatedChangeIndirect().bigDecimalValue());
                subContractAmountInfo.setObligatedChange(subContractAmountInfo.getObligatedChange().add(lastSubAwardAmountInfo.getObligatedChangeIndirect().bigDecimalValue()));
            }
            this.getPeriodOfPerformanceStartDate(subaward).ifPresent(date -> subContractAmountInfo.setPerformanceStartDate(this.getDateTimeService().getCalendar(date)));
            this.getPeriodOfPerformanceEndDate(subaward).ifPresent(date -> subContractAmountInfo.setPerformanceEndDate(this.getDateTimeService().getCalendar(date)));
            if (lastSubAwardAmountInfo.getModificationEffectiveDate() != null) {
                subContractAmountInfo.setModificationEffectiveDate(this.getDateTimeService().getCalendar((Date)lastSubAwardAmountInfo.getModificationEffectiveDate()));
            }
            if (lastSubAwardAmountInfo.getModificationID() != null) {
                subContractAmountInfo.setModificationNumber(lastSubAwardAmountInfo.getModificationID());
            }
        }
        amountinfoList.add(subContractAmountInfo);
        subContractData.setSubcontractAmountInfoArray(amountinfoList.toArray(new SubContractDataDocument.SubContractData.SubcontractAmountInfo[0]));
    }

    public void setAwardHeader(SubContractDataDocument.SubContractData subContractData) {
        AwardType awardType = AwardType.Factory.newInstance();
        AwardHeaderType awardHeaderType = AwardHeaderType.Factory.newInstance();
        AwardType.AwardDetails awardDetails = AwardType.AwardDetails.Factory.newInstance();
        AwardType.AwardDetails.OtherHeaderDetails otherDetails = AwardType.AwardDetails.OtherHeaderDetails.Factory.newInstance();
        ArrayList<AwardType> awardTypeList = new ArrayList<AwardType>();
        if (StringUtils.isNotBlank((CharSequence)this.sponsorAwardNumber)) {
            awardHeaderType.setSponsorAwardNumber(this.sponsorAwardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sponsorName)) {
            awardHeaderType.setSponsorDescription(this.sponsorName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.awardTitle)) {
            awardHeaderType.setTitle(this.awardTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cfdaNumber)) {
            otherDetails.setCFDANumber(this.cfdaNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.primeSponsorName)) {
            otherDetails.setPrimeSponsorDescription(this.primeSponsorName);
        }
        if (this.noticeDate != null) {
            otherDetails.setLastUpdate(this.noticeDate);
        }
        if (this.fedAwardDate != null) {
            otherDetails.setFAID(this.fedAwardDate);
        }
        if (this.obligatedTotal != null) {
            otherDetails.setObligatedAmt(this.obligatedTotal);
        }
        if (this.anticipatedTotal != null) {
            otherDetails.setAnticipatedAmt(this.anticipatedTotal);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fain)) {
            otherDetails.setFAIN(this.fain);
        }
        awardDetails.setAwardHeader(awardHeaderType);
        awardDetails.setOtherHeaderDetails(otherDetails);
        awardType.setAwardDetails(awardDetails);
        awardTypeList.add(awardType);
        subContractData.setAwardArray(awardTypeList.toArray(new AwardType[0]));
    }

    public void setPrimeRecipientContacts(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        Rolodex rolodex;
        boolean requisitionerOrg;
        Organization reqOrganisation;
        SubContractDataDocument.SubContractData.PrimeRecipientContacts primeReceipient = SubContractDataDocument.SubContractData.PrimeRecipientContacts.Factory.newInstance();
        OrganizationType organisation = OrganizationType.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        Organization univOrganisation = (Organization)this.getBusinessObjectService().findByPrimaryKey(Organization.class, Collections.singletonMap(ORGANIZATION_ID, "000001"));
        if (univOrganisation != null) {
            organisation.setOrganizationName(univOrganisation.getOrganizationName());
        }
        Organization organization = reqOrganisation = (requisitionerOrg = this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", FDP_ORG_FROM_REQUISITIONER_UNIT).booleanValue()) && subaward.getUnit() != null ? subaward.getUnit().getOrganization() : null;
        Rolodex rolodex2 = requisitionerOrg && reqOrganisation != null && reqOrganisation.getRolodex() != null ? reqOrganisation.getRolodex() : (rolodex = univOrganisation != null ? univOrganisation.getRolodex() : null);
        if (rolodex != null) {
            rolodexDetails.setAddress1(rolodex.getAddressLine1());
            rolodexDetails.setAddress2(rolodex.getAddressLine2());
            rolodexDetails.setAddress3(rolodex.getAddressLine3());
            rolodexDetails.setCity(rolodex.getCity());
            String countryCode = rolodex.getCountryCode();
            String stateName = rolodex.getState();
            rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
            rolodexDetails.setPincode(rolodex.getPostalCode());
        }
        primeReceipient.setOrgRolodexDetails(rolodexDetails);
        primeReceipient.setRequisitionerOrgDetails(organisation);
        subContractData.setPrimeRecipientContacts(primeReceipient);
    }

    public void setPrintRequirement(SubContractDataDocument.SubContractData subContractData) {
        SubContractDataDocument.SubContractData.PrintRequirement printrequirement = SubContractDataDocument.SubContractData.PrintRequirement.Factory.newInstance();
        String externalImageURL = "kra.externalizable.images.url";
        String imagePath = this.configurationService.getPropertyValueAsString(externalImageURL);
        printrequirement.setAttachment5Required("N");
        printrequirement.setAttachment3BRequired("N");
        printrequirement.setAttachment4Required("N");
        String subawardAttachment4 = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "Subaward_FDP_Attachment_4_Form_ID");
        String subawardAttachment3B = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "Subaward_FDP_Attachment_3B_Form_ID");
        for (SubAwardForms subAwardForms : this.sponsorTemplates) {
            if (subAwardForms.getFormId().equals(subawardAttachment4)) {
                printrequirement.setAttachment4Required("Y");
            }
            if (!subAwardForms.getFormId().equals(subawardAttachment3B)) continue;
            printrequirement.setAttachment3BRequired("Y");
        }
        printrequirement.setImageCheckedPath(imagePath);
        printrequirement.setImageUncheckedPath(imagePath);
        subContractData.setPrintRequirement(printrequirement);
    }

    public void setPrimeAdministrativeContact(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact = SubContractDataDocument.SubContractData.PrimeAdministrativeContact.Factory.newInstance();
        RolodexDetailsType rolodexdetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.PrimeAdministrativeContact> rolodexDetailsList = new ArrayList<SubContractDataDocument.SubContractData.PrimeAdministrativeContact>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String administrativeContactCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Administrative_Contact_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, administrativeContactCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(administrativeContactCode)) continue;
                primeAdministrativeContact.setContactTypeCode(administrativeContactCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                if (rolodex.getFullName() == null) {
                    rolodexdetails.setRolodexName(rolodex.getOrganization());
                } else {
                    rolodexdetails.setRolodexName(rolodex.getFullName());
                }
                rolodexdetails.setAddress1(rolodex.getAddressLine1());
                rolodexdetails.setAddress2(rolodex.getAddressLine2());
                rolodexdetails.setAddress3(rolodex.getAddressLine3());
                rolodexdetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexdetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexdetails.setPincode(rolodex.getPostalCode());
                rolodexdetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexdetails.setFax(rolodex.getFaxNumber());
                rolodexdetails.setEmail(rolodex.getEmailAddress());
                primeAdministrativeContact.setCoiContactEmail(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_COI_Contact_email"));
            }
        }
        primeAdministrativeContact.setRolodexDetails(rolodexdetails);
        rolodexDetailsList.add(primeAdministrativeContact);
        subContractData.setPrimeAdministrativeContactArray(rolodexDetailsList.toArray(new SubContractDataDocument.SubContractData.PrimeAdministrativeContact[0]));
    }

    public void setPrimePrincipalInvestigator(SubContractDataDocument.SubContractData subContractData) {
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator = SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.PrimePrincipalInvestigator> primePrincipalInvestigatorsList = new ArrayList<SubContractDataDocument.SubContractData.PrimePrincipalInvestigator>();
        HashMap<String, String> awardNum = new HashMap<String, String>();
        if (this.awardNumber != null) {
            awardNum.put(AWARD_NUMBER, this.awardNumber);
            awardNum.put(ROLE_CODE, PRINCIPAL_INVESTIGATOR);
            List awardNumList = (List)this.getBusinessObjectService().findMatchingOrderBy(AwardPerson.class, awardNum, SEQUENCE_NUMBER, true);
            if (CollectionUtils.isNotEmpty((Collection)awardNumList)) {
                AwardPerson awardPerson = (AwardPerson)awardNumList.get(awardNumList.size() - 1);
                KcPerson awardPersons = awardPerson.getPerson();
                PersonDetailsType personDetails = PersonDetailsType.Factory.newInstance();
                if (awardPersons != null) {
                    personDetails.setFullName(awardPersons.getFullName());
                    personDetails.setAddressLine1(awardPersons.getAddressLine1());
                    personDetails.setAddressLine2(awardPersons.getAddressLine2());
                    personDetails.setAddressLine3(awardPersons.getAddressLine3());
                    personDetails.setCity(awardPersons.getCity());
                    String countryCode = awardPersons.getCountryCode();
                    String stateName = awardPersons.getState();
                    personDetails.setState(this.getStateName(countryCode, stateName));
                    personDetails.setPostalCode(awardPersons.getPostalCode());
                    personDetails.setMobilePhoneNumber(awardPersons.getOfficePhone());
                    personDetails.setFaxNumber(awardPersons.getFaxNumber());
                    personDetails.setEmailAddress(awardPersons.getEmailAddress());
                } else {
                    NonOrganizationalRolodex rolodex = awardPerson.getRolodex();
                    if (rolodex != null) {
                        personDetails.setFullName(rolodex.getFullName());
                        personDetails.setAddressLine1(rolodex.getAddressLine1());
                        personDetails.setAddressLine2(rolodex.getAddressLine2());
                        personDetails.setAddressLine3(rolodex.getAddressLine3());
                        personDetails.setCity(rolodex.getCity());
                        String countryCode = rolodex.getCountryCode();
                        String stateName = rolodex.getState();
                        personDetails.setState(this.getStateName(countryCode, stateName));
                        personDetails.setPostalCode(rolodex.getPostalCode());
                        personDetails.setMobilePhoneNumber(rolodex.getPhoneNumber());
                        personDetails.setFaxNumber(rolodex.getFaxNumber());
                        personDetails.setEmailAddress(rolodex.getEmailAddress());
                    }
                }
                primePrincipalInvestigator.setContactTypeCode(SubawardTemplateContactFinder.PI.getKey());
                primePrincipalInvestigator.setContactTypeDesc(SubawardTemplateContactFinder.PI.getValue());
                primePrincipalInvestigator.setPersonDetailsType(personDetails);
            }
        }
        primePrincipalInvestigatorsList.add(primePrincipalInvestigator);
        subContractData.setPrimePrincipalInvestigatorArray(primePrincipalInvestigatorsList.toArray(new SubContractDataDocument.SubContractData.PrimePrincipalInvestigator[0]));
    }

    private String getStateName(String countryCode, String stateName) {
        if (countryCode != null && countryCode.length() > 0 && stateName != null && stateName.length() > 0) {
            Country country = this.getCountryService().getCountryByAlternateCode(countryCode);
            State state = this.getStateService().getState(country.getCode(), stateName);
            if (state != null) {
                return state.getName();
            }
        }
        return "";
    }

    public void setPrimeFinancialContact(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact = SubContractDataDocument.SubContractData.PrimeFinancialContact.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.PrimeFinancialContact> personDetailsList = new ArrayList<SubContractDataDocument.SubContractData.PrimeFinancialContact>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String administrativeFinancialCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Financial_Contact_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, administrativeFinancialCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(administrativeFinancialCode)) continue;
                primeFinancialContact.setContactTypeCode(administrativeFinancialCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                if (rolodex.getFullName() == null) {
                    rolodexDetails.setRolodexName(rolodex.getOrganization());
                } else {
                    rolodexDetails.setRolodexName(rolodex.getFullName());
                }
                rolodexDetails.setAddress1(rolodex.getAddressLine1());
                rolodexDetails.setAddress2(rolodex.getAddressLine2());
                rolodexDetails.setAddress3(rolodex.getAddressLine3());
                rolodexDetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexDetails.setPincode(rolodex.getPostalCode());
                rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexDetails.setFax(rolodex.getFaxNumber());
                rolodexDetails.setEmail(rolodex.getEmailAddress());
                primeFinancialContact.setInvoicesEmailed(this.toFlag(this.invoicesEmailed));
                if (this.invoiceEmailDifferent != null && this.invoiceEmailDifferent.booleanValue()) {
                    primeFinancialContact.setInvoiceEmailDifferent(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_PTE_INVOICE_EMAIL));
                }
                if (this.invoiceAddressDifferent == null || !this.invoiceAddressDifferent.booleanValue()) continue;
                primeFinancialContact.setInvoiceAddressDifferent(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_PTE_INVOICE_ADDRESS));
            }
        }
        primeFinancialContact.setRolodexDetails(rolodexDetails);
        personDetailsList.add(primeFinancialContact);
        subContractData.setPrimeFinancialContactArray(personDetailsList.toArray(new SubContractDataDocument.SubContractData.PrimeFinancialContact[0]));
    }

    public void setPrimeAuthorizedOfficial(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorisedOfficial = SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial> primeAuthorisedList = new ArrayList<SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String auhtorisedOfficialCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Prime_Authorized_Official_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, auhtorisedOfficialCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(auhtorisedOfficialCode)) continue;
                primeAuthorisedOfficial.setContactTypeCode(auhtorisedOfficialCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                if (rolodex.getFullName() == null) {
                    rolodexDetails.setRolodexName(rolodex.getOrganization());
                } else {
                    rolodexDetails.setRolodexName(rolodex.getFullName());
                }
                rolodexDetails.setAddress1(rolodex.getAddressLine1());
                rolodexDetails.setAddress2(rolodex.getAddressLine2());
                rolodexDetails.setAddress3(rolodex.getAddressLine3());
                rolodexDetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexDetails.setPincode(rolodex.getPostalCode());
                rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexDetails.setFax(rolodex.getFaxNumber());
                rolodexDetails.setEmail(rolodex.getEmailAddress());
                primeAuthorisedOfficial.setCentralEmail(this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_PTE_AOR_Central_email"));
            }
        }
        primeAuthorisedOfficial.setRolodexDetails(rolodexDetails);
        primeAuthorisedList.add(primeAuthorisedOfficial);
        subContractData.setPrimeAuthorizedOfficialArray(primeAuthorisedList.toArray(new SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial[0]));
    }

    public void setAdministrativeContact(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.AdministrativeContact administrativeContact = SubContractDataDocument.SubContractData.AdministrativeContact.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.AdministrativeContact> administrativeContactList = new ArrayList<SubContractDataDocument.SubContractData.AdministrativeContact>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String administrativeCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Administrative_Contact_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, administrativeCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(administrativeCode)) continue;
                administrativeContact.setContactTypeCode(administrativeCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                String organization = rolodex.getOrganization();
                String fullName = rolodex.getFullName();
                if (fullName != null && fullName.length() > 0) {
                    rolodexDetails.setRolodexName(fullName);
                } else {
                    rolodexDetails.setRolodexName(organization);
                }
                rolodexDetails.setAddress1(rolodex.getAddressLine1());
                rolodexDetails.setAddress2(rolodex.getAddressLine2());
                rolodexDetails.setAddress3(rolodex.getAddressLine3());
                rolodexDetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexDetails.setPincode(rolodex.getPostalCode());
                rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexDetails.setFax(rolodex.getFaxNumber());
                rolodexDetails.setEmail(rolodex.getEmailAddress());
            }
        }
        administrativeContact.setRolodexDetails(rolodexDetails);
        administrativeContactList.add(administrativeContact);
        subContractData.setAdministrativeContactArray(administrativeContactList.toArray(new SubContractDataDocument.SubContractData.AdministrativeContact[0]));
    }

    public void setFinancialContact(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.FinancialContact financialContact = SubContractDataDocument.SubContractData.FinancialContact.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.FinancialContact> financialContactList = new ArrayList<SubContractDataDocument.SubContractData.FinancialContact>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String financialContactCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Financial_Contact_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, financialContactCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(financialContactCode)) continue;
                financialContact.setContactTypeCode(financialContactCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                String organization = rolodex.getOrganization();
                String fullName = rolodex.getFullName();
                if (fullName != null && fullName.length() > 0) {
                    rolodexDetails.setRolodexName(fullName);
                } else {
                    rolodexDetails.setRolodexName(organization);
                }
                rolodexDetails.setAddress1(rolodex.getAddressLine1());
                rolodexDetails.setAddress2(rolodex.getAddressLine2());
                rolodexDetails.setAddress3(rolodex.getAddressLine3());
                rolodexDetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexDetails.setPincode(rolodex.getPostalCode());
                rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexDetails.setFax(rolodex.getFaxNumber());
                rolodexDetails.setEmail(rolodex.getEmailAddress());
            }
        }
        financialContact.setRolodexDetails(rolodexDetails);
        financialContactList.add(financialContact);
        subContractData.setFinancialContactArray(financialContactList.toArray(new SubContractDataDocument.SubContractData.FinancialContact[0]));
    }

    public void setAuthorizedOfficial(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        SubContractDataDocument.SubContractData.AuthorizedOfficial authorizedOfficial = SubContractDataDocument.SubContractData.AuthorizedOfficial.Factory.newInstance();
        RolodexDetailsType rolodexDetails = RolodexDetailsType.Factory.newInstance();
        ArrayList<SubContractDataDocument.SubContractData.AuthorizedOfficial> authorizedOfficialList = new ArrayList<SubContractDataDocument.SubContractData.AuthorizedOfficial>();
        HashMap<String, String> administrativeMap = new HashMap<String, String>();
        String financialContactCode = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", "FDP_Sub_Authorized_Official_Code");
        administrativeMap.put(CONTACT_TYPE_CODE, financialContactCode);
        ContactUsage contactUsage = (ContactUsage)this.getBusinessObjectService().findByPrimaryKey(ContactUsage.class, administrativeMap);
        if (contactUsage.getModuleCode().equals("4") && subaward.getSubAwardContactsList() != null && !subaward.getSubAwardContactsList().isEmpty()) {
            for (SubAwardContact subAwardContact : subaward.getSubAwardContactsList()) {
                if (!subAwardContact.getContactTypeCode().equals(financialContactCode)) continue;
                authorizedOfficial.setContactTypeCode(financialContactCode);
                Rolodex rolodex = subAwardContact.getRolodex();
                String organization = rolodex.getOrganization();
                String fullName = rolodex.getFullName();
                if (fullName != null && fullName.length() > 0) {
                    rolodexDetails.setRolodexName(fullName);
                } else {
                    rolodexDetails.setRolodexName(organization);
                }
                rolodexDetails.setAddress1(rolodex.getAddressLine1());
                rolodexDetails.setAddress2(rolodex.getAddressLine2());
                rolodexDetails.setAddress3(rolodex.getAddressLine3());
                rolodexDetails.setCity(rolodex.getCity());
                String countryCode = rolodex.getCountryCode();
                String stateName = rolodex.getState();
                rolodexDetails.setStateDescription(this.getStateName(countryCode, stateName));
                rolodexDetails.setPincode(rolodex.getPostalCode());
                rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
                rolodexDetails.setFax(rolodex.getFaxNumber());
                rolodexDetails.setEmail(rolodex.getEmailAddress());
            }
        }
        authorizedOfficial.setRolodexDetails(rolodexDetails);
        authorizedOfficialList.add(authorizedOfficial);
        subContractData.setAuthorizedOfficialArray(authorizedOfficialList.toArray(new SubContractDataDocument.SubContractData.AuthorizedOfficial[0]));
    }

    public void setSubcontractReports(SubContractDataDocument.SubContractData subContractData, SubAward subaward) {
        ArrayList<SubContractDataDocument.SubContractData.SubcontractReports> subContractReportsList = new ArrayList<SubContractDataDocument.SubContractData.SubcontractReports>();
        if (subaward.getSubAwardReportList() != null && !subaward.getSubAwardReportList().isEmpty()) {
            for (SubAwardReports subAwardReports : subaward.getSubAwardReportList()) {
                SubContractDataDocument.SubContractData.SubcontractReports subContractReports = SubContractDataDocument.SubContractData.SubcontractReports.Factory.newInstance();
                subAwardReports.refreshReferenceObject(TYPE_CODE);
                SubAwardReportType subAwardReportsType = subAwardReports.getTypeCode();
                subContractReports.setReportTypeDescription(subAwardReportsType.getDescription());
                subContractReportsList.add(subContractReports);
            }
        }
        subContractData.setSubcontractReportsArray(subContractReportsList.toArray(new SubContractDataDocument.SubContractData.SubcontractReports[0]));
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    public StateService getStateService() {
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

