/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jta;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.transaction.TransactionManager;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.core.framework.persistence.jta.Jta;
import org.springframework.beans.factory.FactoryBean;

public class TransactionManagerFactoryBean
implements FactoryBean<TransactionManager> {
    public TransactionManager getObject() throws Exception {
        if (ConfigContext.getCurrentContextConfig() != null && ConfigContext.getCurrentContextConfig().getObject("SPRING_TRANSACTION_MANAGER") != null) {
            return null;
        }
        return (TransactionManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getObjectType()}, (InvocationHandler)((Object)new LazyInitializationHandler()));
    }

    public Class<TransactionManager> getObjectType() {
        return TransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static class LazyInitializationHandler
    extends BaseTargetedInvocationHandler<TransactionManager> {
        private volatile boolean initialized;
        private TransactionManager transactionManager;

        LazyInitializationHandler() {
            super(null);
        }

        public Object invokeInternal(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.initialized) {
                if (Jta.isFrozen()) {
                    this.transactionManager = Jta.getTransactionManager();
                    this.initialized = true;
                } else {
                    throw new IllegalStateException("JTA has not been initialized, in order to use the TransactionManager please ensure that it has been configured on " + Jta.class.getName());
                }
            }
            if (this.transactionManager == null) {
                throw new IllegalStateException("Attempting to use TransactionManager but JTA is not enabled.");
            }
            return method.invoke((Object)this.transactionManager, args);
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public TransactionManager getTarget() {
            return this.transactionManager;
        }
    }
}

