/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.quartz;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kcb.api.exception.MessageDeliveryProcessingException;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.MessageDeliveryStatus;
import org.kuali.rice.kcb.deliverer.BulkMessageDeliverer;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.quartz.ConcurrentJob;
import org.kuali.rice.kcb.quartz.ProcessingResult;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.MessageDelivererRegistryService;
import org.kuali.rice.kcb.service.MessageDeliveryService;
import org.kuali.rice.kcb.service.MessageService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.factory.annotation.Required;

public class MessageProcessingJob
extends ConcurrentJob<MessageDelivery>
implements StatefulJob {
    public static final String NAME = "MessageProcessingJobDetail";
    public static final String GROUP = "KCB-Delivery";
    private static final Logger LOG = LogManager.getLogger(MessageProcessingJob.class);
    private DataObjectService dataObjectService;
    private MessageDelivererRegistryService registry = GlobalKCBServiceLocator.getInstance().getMessageDelivererRegistryService();
    private MessageDeliveryService messageDeliveryService = GlobalKCBServiceLocator.getInstance().getMessageDeliveryService();
    private Long messageId;
    private Mode mode = null;
    private String user;
    private String cause;

    public MessageProcessingJob(Long messageId, Mode mode, String user, String cause) {
        this();
        this.messageId = messageId;
        this.mode = mode;
        this.user = user;
        this.cause = cause;
    }

    public MessageProcessingJob() {
        this.txManager = GlobalKCBServiceLocator.getInstance().getTransactionManager();
        this.dataObjectService = KRADServiceLocator.getDataObjectService();
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Required
    public void setMessageDelivererRegistry(MessageDelivererRegistryService registry) {
        this.registry = registry;
    }

    @Required
    public void setMessageDeliveryService(MessageDeliveryService messageDeliveryService) {
        this.messageDeliveryService = messageDeliveryService;
    }

    @Override
    protected Collection<MessageDelivery> takeAvailableWorkItems() {
        MessageDeliveryStatus[] statuses;
        switch (this.mode) {
            case DELIVER: {
                statuses = new MessageDeliveryStatus[]{MessageDeliveryStatus.UNDELIVERED};
                break;
            }
            case REMOVE: {
                if (this.messageId == null) {
                    throw new IllegalStateException("Message id must be specified for message removal mode");
                }
                statuses = new MessageDeliveryStatus[]{MessageDeliveryStatus.DELIVERED, MessageDeliveryStatus.UNDELIVERED};
                break;
            }
            default: {
                throw new RuntimeException("Invalid mode: " + this.mode);
            }
        }
        for (MessageDeliveryStatus status : statuses) {
            LOG.debug("Taking message deliveries with status: " + status);
        }
        Collection<MessageDelivery> ds = this.messageDeliveryService.lockAndTakeMessageDeliveries(this.messageId, statuses);
        LOG.debug("Took " + ds.size() + " deliveries");
        for (MessageDelivery md : ds) {
            LOG.debug((Object)md);
            md.setProcessCount(md.getProcessCount() + 1);
        }
        return ds;
    }

    @Override
    protected void unlockWorkItem(MessageDelivery item) {
        item.setLockedDate(null);
        this.dataObjectService.save((Object)item, new PersistenceOption[0]);
    }

    @Override
    protected Collection<Collection<MessageDelivery>> groupWorkItems(Collection<MessageDelivery> workItems, ProcessingResult<MessageDelivery> result) {
        ArrayList<Collection<MessageDelivery>> groupedWorkItems = new ArrayList<Collection<MessageDelivery>>(workItems.size());
        HashMap<CallSite, LinkedList<MessageDelivery>> bulkWorkUnits = new HashMap<CallSite, LinkedList<MessageDelivery>>();
        for (MessageDelivery messageDelivery : workItems) {
            MessageDeliverer deliverer = this.registry.getDeliverer(messageDelivery);
            if (deliverer == null) {
                LOG.error("Error obtaining message deliverer for message delivery: " + messageDelivery);
                result.addFailure(new ProcessingResult.Failure<MessageDelivery>(messageDelivery, "Error obtaining message deliverer for message delivery"));
                this.unlockWorkItemAtomically(messageDelivery);
                continue;
            }
            if (deliverer instanceof BulkMessageDeliverer) {
                String key = messageDelivery.getDelivererTypeName() + ":" + messageDelivery.getMessage().getId();
                LinkedList<MessageDelivery> workUnit = (LinkedList<MessageDelivery>)bulkWorkUnits.get(key);
                if (workUnit == null) {
                    workUnit = new LinkedList<MessageDelivery>();
                    bulkWorkUnits.put((CallSite)((Object)key), workUnit);
                }
                workUnit.add(messageDelivery);
                continue;
            }
            ArrayList<MessageDelivery> l = new ArrayList<MessageDelivery>(1);
            l.add(messageDelivery);
            groupedWorkItems.add(l);
        }
        return groupedWorkItems;
    }

    @Override
    protected Collection<MessageDelivery> processWorkItems(Collection<MessageDelivery> messageDeliveries) {
        MessageDelivery firstMessageDelivery = messageDeliveries.iterator().next();
        MessageDeliverer messageDeliverer = this.registry.getDeliverer(firstMessageDelivery);
        if (messageDeliverer == null) {
            throw new RuntimeException("Message deliverer could not be obtained");
        }
        if (messageDeliveries.size() > 1) {
            if (!(messageDeliverer instanceof BulkMessageDeliverer)) {
                throw new RuntimeException("Discrepency in dispatch service: deliverer for list of message deliveries is not a BulkMessageDeliverer");
            }
            return this.bulkProcess((BulkMessageDeliverer)messageDeliverer, messageDeliveries, this.mode);
        }
        return this.process(messageDeliverer, firstMessageDelivery, this.mode);
    }

    protected Collection<MessageDelivery> process(MessageDeliverer messageDeliverer, MessageDelivery messageDelivery, Mode mode) {
        try {
            if (mode == Mode.DELIVER) {
                messageDeliverer.deliver(messageDelivery);
                messageDelivery.setProcessCount(0);
                this.updateStatusAndUnlock(messageDelivery, mode == Mode.DELIVER ? MessageDeliveryStatus.DELIVERED : MessageDeliveryStatus.REMOVED);
            } else {
                messageDeliverer.dismiss(messageDelivery, this.user, this.cause);
                this.messageDeliveryService.deleteMessageDelivery(messageDelivery);
            }
        }
        catch (MessageDeliveryProcessingException nmde) {
            LOG.error("Error processing message delivery " + messageDelivery, (Throwable)nmde);
            throw new RuntimeException(nmde);
        }
        LOG.debug("Message delivery '" + messageDelivery.getId() + "' for message '" + messageDelivery.getMessage().getId() + "' was successfully processed.");
        ArrayList<MessageDelivery> success = new ArrayList<MessageDelivery>(1);
        success.add(messageDelivery);
        return success;
    }

    protected Collection<MessageDelivery> bulkProcess(BulkMessageDeliverer messageDeliverer, Collection<MessageDelivery> messageDeliveries, Mode mode) {
        MessageDeliveryStatus targetStatus = mode == Mode.DELIVER ? MessageDeliveryStatus.DELIVERED : MessageDeliveryStatus.REMOVED;
        try {
            if (mode == Mode.DELIVER) {
                messageDeliverer.bulkDeliver(messageDeliveries);
            } else {
                messageDeliverer.bulkDismiss(messageDeliveries);
            }
        }
        catch (MessageDeliveryProcessingException nmde) {
            LOG.error("Error bulk-delivering messages " + messageDeliveries, (Throwable)nmde);
            throw new RuntimeException(nmde);
        }
        ArrayList<MessageDelivery> successes = new ArrayList<MessageDelivery>(messageDeliveries.size());
        for (MessageDelivery nmd : messageDeliveries) {
            successes.add(nmd);
            LOG.debug("Message delivery '" + nmd.getId() + "' for notification '" + nmd.getMessage().getId() + "' was successfully delivered.");
            if (mode == Mode.REMOVE) {
                this.messageDeliveryService.deleteMessageDelivery(nmd);
                continue;
            }
            nmd.setProcessCount(0);
            this.updateStatusAndUnlock(nmd, targetStatus);
        }
        return successes;
    }

    @Override
    protected void finishProcessing(ProcessingResult<MessageDelivery> result) {
        LOG.debug("Message processing job: " + result.getSuccesses().size() + " processed, " + result.getFailures().size() + " failures");
        HashSet<Long> messageIds = new HashSet<Long>(result.getSuccesses().size());
        for (MessageDelivery md : result.getSuccesses()) {
            messageIds.add(md.getMessage().getId());
        }
        MessageService ms = GlobalKCBServiceLocator.getInstance().getKcbMessageService();
        for (Long id : messageIds) {
            LOG.debug("Finishing processing message " + id);
            Message m = ms.getMessage(id);
            Collection<MessageDelivery> c = this.messageDeliveryService.getMessageDeliveries(m);
            if (c.size() == 0) {
                LOG.debug("Deleting message " + m);
                ms.deleteMessage(m);
                continue;
            }
            LOG.debug("Message " + m.getId() + " has " + c.size() + " deliveries");
            for (MessageDelivery md : c) {
                LOG.debug((Object)md);
            }
        }
    }

    protected void updateStatusAndUnlock(MessageDelivery messageDelivery, MessageDeliveryStatus status) {
        messageDelivery.setDeliveryStatus(status);
        messageDelivery.setLockedDate(null);
        this.dataObjectService.save((Object)messageDelivery, new PersistenceOption[0]);
    }

    @Override
    public ProcessingResult<MessageDelivery> run() {
        LOG.debug("MessageProcessingJob running in Thread " + Thread.currentThread() + ": " + this.mode + " " + this.user + " " + this.cause);
        return super.run();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String mode = context.getMergedJobDataMap().getString("mode");
        this.mode = mode != null ? Mode.valueOf(mode) : Mode.DELIVER;
        this.user = context.getMergedJobDataMap().getString("user");
        this.cause = context.getMergedJobDataMap().getString("cause");
        if (context.getMergedJobDataMap().containsKey((Object)"messageId")) {
            this.messageId = context.getMergedJobDataMap().getLong("messageId");
        }
        LOG.debug("==== message processing job: " + this.mode + " message id: " + this.messageId + "====");
        super.run();
    }

    public static enum Mode {
        DELIVER,
        REMOVE;

    }
}

