/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.user;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;

public final class UserUtils {
    private static final Logger LOG = LogManager.getLogger(UserUtils.class);
    private static PersonService personService;

    private UserUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getIdValue(String idType, Person user) {
        if ("workflowId".equalsIgnoreCase(idType) || "w".equalsIgnoreCase(idType) || "principalId".equalsIgnoreCase(idType)) {
            return user.getPrincipalId();
        }
        if ("authenticationId".equalsIgnoreCase(idType) || "a".equalsIgnoreCase(idType) || "principalName".equalsIgnoreCase(idType)) {
            return user.getPrincipalName();
        }
        if ("emplId".equalsIgnoreCase(idType) || "e".equalsIgnoreCase(idType)) {
            return user.getEmployeeId();
        }
        LOG.error("Could not determine ID Value for given id type!" + idType);
        return null;
    }

    public static String getIdValue(String idType, String principalId) {
        if ("workflowId".equalsIgnoreCase(idType) || "w".equalsIgnoreCase(idType) || "principalId".equalsIgnoreCase(idType)) {
            return principalId;
        }
        Person person = KimApiServiceLocator.getPersonService().getPerson(principalId);
        return UserUtils.getIdValue(idType, person);
    }

    public static String getTransposedName(UserSession userSession, PrincipalContract principal) {
        Person person = UserUtils.getPersonService().getPerson(principal.getPrincipalId());
        return person.getName();
    }

    public static PersonService getPersonService() {
        if (personService == null) {
            personService = KimApiServiceLocator.getPersonService();
        }
        return personService;
    }
}

