/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.util.Collection;
import java.util.Map;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.doctype.service.impl.DocumentActionsPermissionBase;
import org.kuali.rice.kew.framework.document.security.AuthorizableAction;
import org.kuali.rice.kew.framework.document.security.Authorization;
import org.kuali.rice.kew.framework.document.security.DocumentTypeAuthorizer;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class KimDocumentTypeAuthorizer
extends DocumentActionsPermissionBase
implements DocumentTypeAuthorizer {
    public Authorization isActionAuthorized(AuthorizableAction action, String principalId, DocumentType documentType, Document document, Map<DocumentTypeAuthorizer.ActionArgument, Object> actionParameters) {
        org.kuali.rice.kew.doctype.bo.DocumentType documentTypeBo = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)documentType);
        boolean success = false;
        block0 : switch (action.type) {
            case INITIATION: {
                success = this.canInitiate(principalId, documentTypeBo);
                break;
            }
            case SU_APPROVE_ACTION_REQUEST: {
                success = this.canSuperUserApproveSingleActionRequest(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS));
                break;
            }
            case ACTION: {
                switch (action.actionType) {
                    case BLANKET_APPROVE: {
                        success = this.canBlanketApprove(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                    case SU_APPROVE: {
                        success = this.canSuperUserApproveDocument(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS));
                        break block0;
                    }
                    case SU_DISAPPROVE: {
                        success = this.canSuperUserDisapproveDocument(principalId, documentTypeBo, (Collection)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.ROUTENODE_NAMES), (String)actionParameters.get(DocumentTypeAuthorizer.ActionArgument.DOCSTATUS));
                        break block0;
                    }
                    case CANCEL: {
                        success = this.canCancel(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                    case RECALL: {
                        success = this.canRecall(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                    case ROUTE: {
                        success = this.canRoute(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                    case SAVE: {
                        success = this.canSave(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                    case RETURN_TO_PREVIOUS: {
                        success = this.canReturnToPreviousRouteNode(principalId, DocumentRouteHeaderValue.from(document));
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown document action check");
            }
            default: {
                throw new RuntimeException("Unknown authorization check");
            }
        }
        return new Authorization(success);
    }
}

