/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.service.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.framework.persistence.jta.TransactionalNoValidationExceptionRollback;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentBase;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.CompleteDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveEvent;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.DocumentHeaderService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.OptimisticLockingFailureException;

@TransactionalNoValidationExceptionRollback
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOG = LogManager.getLogger(DocumentServiceImpl.class);
    protected DateTimeService dateTimeService;
    protected NoteService noteService;
    protected WorkflowDocumentService workflowDocumentService;
    protected LegacyDataAdapter legacyDataAdapter;
    protected DataDictionaryService dataDictionaryService;
    protected DocumentDictionaryService documentDictionaryService;
    protected PersonService personService;
    protected ConfigurationService kualiConfigurationService;
    protected DocumentHeaderService documentHeaderService;
    protected DocumentAdHocService documentAdHocService;

    public Document saveDocument(Document document) throws WorkflowException, ValidationException {
        return this.saveDocument(document, SaveDocumentEvent.class);
    }

    public Document saveDocument(Document document, DocumentEvent event) throws WorkflowException {
        this.checkForNulls(document);
        if (event == null) {
            throw new IllegalArgumentException("invalid (null) DocumentEvent instance");
        }
        if (!SaveEvent.class.isAssignableFrom(event.getClass())) {
            throw new ConfigurationException("The KualiDocumentEvent class '" + event.getClass().getName() + "' does not implement the class '" + SaveEvent.class.getName() + "'");
        }
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocumentAndSaveAdHocRoutingRecipients(document, event);
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().save(savedDocument.getDocumentHeader().getWorkflowDocument(), null);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        return savedDocument;
    }

    public Document saveDocument(Document document, Class<? extends DocumentEvent> kualiDocumentEventClass) throws WorkflowException, ValidationException {
        this.checkForNulls(document);
        if (kualiDocumentEventClass == null) {
            throw new IllegalArgumentException("invalid (null) kualiDocumentEventClass");
        }
        if (!SaveEvent.class.isAssignableFrom(kualiDocumentEventClass)) {
            throw new ConfigurationException("The KualiDocumentEvent class '" + kualiDocumentEventClass.getName() + "' does not implement the class '" + SaveEvent.class.getName() + "'");
        }
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocumentAndSaveAdHocRoutingRecipients(document, this.generateKualiDocumentEvent(document, kualiDocumentEventClass));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().save(savedDocument.getDocumentHeader().getWorkflowDocument(), null);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        return savedDocument;
    }

    private DocumentEvent generateKualiDocumentEvent(Document document, Class<? extends DocumentEvent> eventClass) throws ConfigurationException {
        String potentialErrorMessage = "Found error trying to generate Kuali Document Event using event class '" + eventClass.getName() + "' for document " + document.getDocumentNumber();
        try {
            Constructor<?> usableConstructor = null;
            ArrayList<Document> paramList = new ArrayList<Document>();
            for (Constructor<?> currentConstructor : eventClass.getConstructors()) {
                for (Class<?> parameterClass : currentConstructor.getParameterTypes()) {
                    if (Document.class.isAssignableFrom(parameterClass)) {
                        usableConstructor = currentConstructor;
                        paramList.add(document);
                        continue;
                    }
                    paramList.add(null);
                }
                if (KRADUtils.isNotNull((Object)usableConstructor)) break;
            }
            if (usableConstructor == null) {
                throw new RuntimeException("Cannot find a constructor for class '" + eventClass.getName() + "' that takes in a document parameter");
            }
            return (DocumentEvent)usableConstructor.newInstance(paramList.toArray());
        }
        catch (SecurityException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(potentialErrorMessage, (Throwable)e);
        }
    }

    public Document routeDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        return this.routeDocument(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document routeDocument(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, (DocumentEvent)new RouteDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().route(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document approveDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        return this.approveDocument(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document approveDocument(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, (DocumentEvent)new ApproveDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().approve(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document superUserApproveDocument(Document document, String annotation) throws WorkflowException {
        Document savedDocument = (Document)this.getLegacyDataAdapter().saveDocument((Object)document);
        savedDocument.processAfterRetrieve();
        savedDocument.getDocumentHeader().setWorkflowDocument(document.getDocumentHeader().getWorkflowDocument());
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().superUserApprove(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document superUserCancelDocument(Document document, String annotation) throws WorkflowException {
        Document savedDocument = (Document)this.getLegacyDataAdapter().saveDocument((Object)document);
        savedDocument.processAfterRetrieve();
        savedDocument.getDocumentHeader().setWorkflowDocument(document.getDocumentHeader().getWorkflowDocument());
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().superUserCancel(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document superUserDisapproveDocument(Document document, String annotation) throws WorkflowException {
        Document savedDocument = (Document)this.getLegacyDataAdapter().saveDocument((Object)document);
        savedDocument.processAfterRetrieve();
        savedDocument.getDocumentHeader().setWorkflowDocument(document.getDocumentHeader().getWorkflowDocument());
        return this.superUserDisapproveDocumentWithoutSaving(savedDocument, annotation);
    }

    public Document superUserDisapproveDocumentWithoutSaving(Document document, String annotation) throws WorkflowException {
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().superUserDisapprove(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document disapproveDocument(Document document, String annotation) throws Exception {
        this.checkForNulls(document);
        Note note = this.createNoteFromDocument(document, annotation);
        if (document.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT)) {
            note.setNoteTypeCode(NoteType.DOCUMENT_HEADER.getCode());
            note.setRemoteObjectIdentifier(document.getDocumentHeader().getObjectId());
        }
        document.addNote(note);
        this.getNoteService().save(note);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().disapprove(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document cancelDocument(Document document, String annotation) throws WorkflowException {
        this.checkForNulls(document);
        if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintDoc = (MaintenanceDocument)document;
            if (maintDoc.getOldMaintainableObject() != null && maintDoc.getOldMaintainableObject().getDataObject() instanceof BusinessObject) {
                ((BusinessObject)maintDoc.getOldMaintainableObject().getDataObject()).refresh();
            }
            if (maintDoc.getNewMaintainableObject().getDataObject() instanceof BusinessObject) {
                ((BusinessObject)maintDoc.getNewMaintainableObject().getDataObject()).refresh();
            }
        }
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().cancel(document.getDocumentHeader().getWorkflowDocument(), annotation);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document recallDocument(Document document, String annotation, boolean cancel) throws WorkflowException {
        this.checkForNulls(document);
        WorkflowDocument workflowDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(document.getDocumentNumber()).getDocumentHeader().getWorkflowDocument();
        if (!workflowDocument.isFinal() && !workflowDocument.isProcessed()) {
            Note note = this.createNoteFromDocument(document, annotation);
            document.addNote(note);
            this.getNoteService().save(note);
        }
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().recall(document.getDocumentHeader().getWorkflowDocument(), annotation, cancel);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document acknowledgeDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        return this.acknowledgeDocument(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document acknowledgeDocument(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        this.prepareWorkflowDocument(document);
        this.getWorkflowDocumentService().acknowledge(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document blanketApproveDocument(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        return this.blanketApproveDocument(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document blanketApproveDocument(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws ValidationException, WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, (DocumentEvent)new BlanketApproveDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().blanketApprove(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document clearDocumentFyi(Document document, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        return this.clearDocumentFyi(document, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document clearDocumentFyi(Document document, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        document.populateDocumentForRouting();
        this.getWorkflowDocumentService().clearFyi(document.getDocumentHeader().getWorkflowDocument(), adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    public Document completeDocument(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.checkForNulls(document);
        document.prepareForSave();
        Document savedDocument = this.validateAndPersistDocument(document, (DocumentEvent)new CompleteDocumentEvent(document));
        this.prepareWorkflowDocument(savedDocument);
        this.getWorkflowDocumentService().complete(savedDocument.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)savedDocument.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(savedDocument);
        return savedDocument;
    }

    public Document completeDocument(Document document, String annotation, List adHocRecipients) throws WorkflowException {
        return this.completeDocument(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    protected void checkForNulls(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentNumber() == null) {
            throw new IllegalStateException("invalid (null) documentHeaderId");
        }
    }

    private Document validateAndPersistDocumentAndSaveAdHocRoutingRecipients(Document document, DocumentEvent event) {
        this.documentAdHocService.replaceAdHocsForDocument(document);
        return this.validateAndPersistDocument(document, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean documentExists(String documentHeaderId) {
        if (StringUtils.isBlank((String)documentHeaderId)) {
            throw new IllegalArgumentException("invalid (blank) documentHeaderId");
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession((UserSession)new UserSession("kr"));
                GlobalVariables.clear();
            }
            if (this.getWorkflowDocumentService().workflowDocumentExists(documentHeaderId)) {
                boolean bl = this.documentHeaderService.getDocumentHeaderById(documentHeaderId) != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    public Document getNewDocument(Class<? extends Document> documentClass) throws WorkflowException {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) documentClass");
        }
        if (!Document.class.isAssignableFrom(documentClass)) {
            throw new IllegalArgumentException("invalid (non-Document) documentClass");
        }
        String documentTypeName = this.getDataDictionaryService().getDocumentTypeNameByClass(documentClass);
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new UnknownDocumentTypeException("unable to get documentTypeName for unknown documentClass '" + documentClass.getName() + "'");
        }
        return this.getNewDocument(documentTypeName);
    }

    public Document getNewDocument(String documentTypeName, String initiatorPrincipalNm) throws WorkflowException {
        String watchName = "DocumentServiceImpl.getNewDocument";
        StopWatch watch = new StopWatch();
        watch.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug(watchName + ": started");
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (GlobalVariables.getUserSession() == null) {
            throw new IllegalStateException("GlobalVariables must be populated with a valid UserSession before a new document can be created");
        }
        Class<? extends Document> documentClass = this.getDocumentClassByTypeName(documentTypeName);
        Person initiator = null;
        if (StringUtils.isBlank((String)initiatorPrincipalNm)) {
            initiator = GlobalVariables.getUserSession().getPerson();
        } else {
            initiator = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(initiatorPrincipalNm);
            if (initiator == null) {
                initiator = GlobalVariables.getUserSession().getPerson();
            }
        }
        DocumentAuthorizer documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(documentTypeName);
        DocumentPresentationController documentPresentationController = this.getDocumentDictionaryService().getDocumentPresentationController(documentTypeName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling canInitiate from getNewDocument(" + documentTypeName + "," + initiatorPrincipalNm + ")");
        }
        if (!documentPresentationController.canInitiate(documentTypeName) || !documentAuthorizer.canInitiate(documentTypeName, initiator)) {
            throw new DocumentAuthorizationException(initiator.getPrincipalName(), "initiate", documentTypeName);
        }
        WorkflowDocument workflowDocument = this.getWorkflowDocumentService().createWorkflowDocument(documentTypeName, initiator);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)workflowDocument);
        DocumentHeader documentHeader = new DocumentHeader();
        documentHeader.setWorkflowDocument(workflowDocument);
        documentHeader.setDocumentNumber(workflowDocument.getDocumentId());
        Document document = null;
        try {
            if (MaintenanceDocumentBase.class.isAssignableFrom(documentClass)) {
                Class[] defaultConstructor = new Class[]{String.class};
                Constructor<? extends Document> cons = documentClass.getConstructor(defaultConstructor);
                if (cons == null) {
                    throw new ConfigurationException("Could not find constructor with document type name parameter needed for Maintenance Document Base class");
                }
                document = cons.newInstance(documentTypeName);
            } else {
                document = documentClass.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error instantiating Document", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating Document", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error instantiating Maintenance Document: No constructor with String parameter found", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error instantiating Maintenance Document", e);
        }
        document.setDocumentHeader(documentHeader);
        document.setDocumentNumber(documentHeader.getDocumentNumber());
        watch.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug(watchName + ": " + watch.toString());
        }
        return document;
    }

    public Document getNewDocument(String documentTypeName) throws WorkflowException {
        return this.getNewDocument(documentTypeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getByDocumentHeaderId(String documentHeaderId) throws WorkflowException {
        if (documentHeaderId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession((UserSession)new UserSession("kr"));
                GlobalVariables.clear();
            }
            WorkflowDocument workflowDocument = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving doc id: " + documentHeaderId + " from workflow service.");
            }
            workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(documentHeaderId, GlobalVariables.getUserSession().getPerson());
            UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)workflowDocument);
            Class<? extends Document> documentClass = this.getDocumentClassByTypeName(workflowDocument.getDocumentTypeName());
            Document document = this.getLegacyDataAdapter().findByDocumentHeaderId(documentClass, documentHeaderId);
            Document document2 = this.postProcessDocument(documentHeaderId, workflowDocument, document);
            return document2;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    public Document getByDocumentHeaderIdSessionless(String documentHeaderId) throws WorkflowException {
        if (documentHeaderId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        WorkflowDocument workflowDocument = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving doc id: " + documentHeaderId + " from workflow service.");
        }
        Person person = this.getPersonService().getPersonByPrincipalName("kr");
        workflowDocument = this.workflowDocumentService.loadWorkflowDocument(documentHeaderId, person);
        Class<? extends Document> documentClass = this.getDocumentClassByTypeName(workflowDocument.getDocumentTypeName());
        Document document = this.getLegacyDataAdapter().findByDocumentHeaderId(documentClass, documentHeaderId);
        return this.postProcessDocument(documentHeaderId, workflowDocument, document);
    }

    private Class<? extends Document> getDocumentClassByTypeName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        Class clazz = this.getDataDictionaryService().getDocumentClassByTypeName(documentTypeName);
        if (clazz == null) {
            throw new UnknownDocumentTypeException("unable to get class for unknown documentTypeName '" + documentTypeName + "'");
        }
        return clazz;
    }

    protected void loadNotes(Document document) {
        if (this.isNoteTargetReady(document)) {
            if (document instanceof MaintenanceDocument) {
                MaintenanceDocument mdoc = (MaintenanceDocument)document;
                Class legacyObjectClass = ((Maintainable)ObjectUtils.defaultIfNull((Object)mdoc.getOldMaintainableObject(), (Object)mdoc.getNewMaintainableObject())).getDataObjectClass();
            } else {
                Class<?> legacyObjectClass = document.getClass();
            }
            ArrayList notes = new ArrayList();
            if (StringUtils.isNotBlank((String)document.getNoteTarget().getObjectId())) {
                notes.addAll(this.getNoteService().getByRemoteObjectId(document.getNoteTarget().getObjectId()));
            }
            if (document.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT) && document.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
                notes.addAll(this.getNoteService().getByRemoteObjectId(document.getDocumentHeader().getObjectId()));
            }
            document.setNotes(notes);
        }
    }

    private Document postProcessDocument(String documentHeaderId, WorkflowDocument workflowDocument, Document document) {
        if (document != null) {
            document.getDocumentHeader().setWorkflowDocument(workflowDocument);
            document.processAfterRetrieve();
            this.loadNotes(document);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> getDocumentsByListOfDocumentHeaderIds(Class<? extends Document> documentClass, List<String> documentHeaderIds) throws WorkflowException {
        if (documentHeaderIds == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId list");
        }
        int index = 0;
        for (String documentHeaderId : documentHeaderIds) {
            if (StringUtils.isBlank((String)documentHeaderId)) {
                throw new IllegalArgumentException("invalid (blank) documentHeaderId at list index " + index);
            }
            ++index;
        }
        boolean internalUserSession = false;
        try {
            if (GlobalVariables.getUserSession() == null) {
                internalUserSession = true;
                GlobalVariables.setUserSession((UserSession)new UserSession("kr"));
                GlobalVariables.clear();
            }
            List rawDocuments = this.getLegacyDataAdapter().findByDocumentHeaderIds(documentClass, documentHeaderIds);
            ArrayList<Document> documents = new ArrayList<Document>();
            for (Document document : rawDocuments) {
                WorkflowDocument workflowDocument = this.getWorkflowDocumentService().loadWorkflowDocument(document.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                document = this.postProcessDocument(document.getDocumentNumber(), workflowDocument, document);
                documents.add(document);
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
        finally {
            if (internalUserSession) {
                GlobalVariables.clear();
                GlobalVariables.setUserSession(null);
            }
        }
    }

    public Document validateAndPersistDocument(Document document, DocumentEvent event) throws ValidationException {
        if (document == null) {
            LOG.error("document passed to validateAndPersist was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("validating and preparing to persist document " + document.getDocumentNumber());
        }
        document.validateBusinessRules(event);
        document.prepareForSave(event);
        Document savedDocument = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("storing document " + document.getDocumentNumber());
            }
            savedDocument = (Document)this.getLegacyDataAdapter().saveDocument((Object)document);
            savedDocument.getDocumentHeader().setWorkflowDocument(document.getDocumentHeader().getWorkflowDocument());
            savedDocument.processAfterRetrieve();
        }
        catch (OptimisticLockingFailureException e) {
            LOG.error("exception encountered on store of document " + e.getMessage());
            throw e;
        }
        boolean notesSaved = this.saveDocumentNotes(savedDocument);
        if (!notesSaved && LOG.isInfoEnabled()) {
            LOG.info("Notes not saved during validateAndPersistDocument, likely means that note save needs to be deferred because note target is not ready.");
        }
        savedDocument.postProcessSave(event);
        return savedDocument;
    }

    public void prepareWorkflowDocument(Document document) throws WorkflowException {
        document.populateDocumentForRouting();
        this.populateDocumentTitle(document);
        this.populateApplicationDocumentId(document);
    }

    private void populateDocumentTitle(Document document) throws WorkflowException {
        String documentTitle = document.getDocumentTitle();
        if (StringUtils.isNotBlank((String)documentTitle)) {
            document.getDocumentHeader().getWorkflowDocument().setTitle(documentTitle);
        }
    }

    private void populateApplicationDocumentId(Document document) {
        String organizationDocumentNumber = document.getDocumentHeader().getOrganizationDocumentNumber();
        if (StringUtils.isNotBlank((String)organizationDocumentNumber)) {
            document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentId(organizationDocumentNumber);
        }
    }

    public Document updateDocument(Document document) {
        this.checkForNulls(document);
        Document savedDocument = (Document)this.getLegacyDataAdapter().saveDocument((Object)document);
        savedDocument.processAfterRetrieve();
        savedDocument.getDocumentHeader().setWorkflowDocument(document.getDocumentHeader().getWorkflowDocument());
        return savedDocument;
    }

    public Note createNoteFromDocument(Document document, String text) {
        Note note = new Note();
        note.setNotePostedTimestamp(this.getDateTimeService().getCurrentTimestamp());
        note.setNoteText(text);
        note.setNoteTypeCode(document.getNoteType().getCode());
        GloballyUnique bo = document.getNoteTarget();
        Person kualiUser = GlobalVariables.getUserSession().getPerson();
        if (kualiUser == null) {
            throw new IllegalStateException("Current UserSession has a null Person.");
        }
        return bo == null ? null : this.getNoteService().createNote(note, bo, kualiUser.getPrincipalId());
    }

    public boolean saveDocumentNotes(Document document) {
        if (this.isNoteTargetReady(document)) {
            List notes = document.getNotes();
            for (Note note : document.getNotes()) {
                this.linkNoteRemoteObjectId(note, document.getNoteTarget());
            }
            document.setNotes(this.getNoteService().saveNoteList(notes));
            return true;
        }
        return false;
    }

    public Document sendNoteRouteNotification(Document document, Note note, Person sender) throws WorkflowException {
        AdHocRouteRecipient routeRecipient = note.getAdHocRouteRecipient();
        Person requestedUser = this.getPersonService().getPersonByPrincipalName(routeRecipient.getId());
        String senderName = sender.getFirstName() + " " + sender.getLastName();
        String requestedName = requestedUser.getFirstName() + " " + requestedUser.getLastName();
        String notificationText = this.kualiConfigurationService.getPropertyValueAsString("message.note.notification.annotation");
        if (StringUtils.isBlank((String)notificationText)) {
            throw new RuntimeException("No annotation message found for note notification. Message needs added to application resources with key:message.note.notification.annotation");
        }
        notificationText = MessageFormat.format(notificationText, senderName, requestedName, note.getNoteText());
        ArrayList<AdHocRouteRecipient> routeRecipients = new ArrayList<AdHocRouteRecipient>();
        routeRecipients.add(routeRecipient);
        this.workflowDocumentService.sendWorkflowNotification(document.getDocumentHeader().getWorkflowDocument(), notificationText, routeRecipients, "READ NOTES");
        note.setAdHocRouteRecipient((AdHocRouteRecipient)new AdHocRoutePerson());
        return document;
    }

    protected boolean isNoteTargetReady(Document document) {
        if (document.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            return true;
        }
        GloballyUnique noteTarget = document.getNoteTarget();
        return noteTarget != null && !StringUtils.isBlank((String)noteTarget.getObjectId());
    }

    private void linkNoteRemoteObjectId(Note note, GloballyUnique noteTarget) {
        String objectId = noteTarget.getObjectId();
        if (StringUtils.isBlank((String)objectId)) {
            throw new IllegalStateException("Attempted to link a Note with a PersistableBusinessObject with no object id");
        }
        note.setRemoteObjectIdentifier(noteTarget.getObjectId());
    }

    public Document sendAdHocRequests(Document document, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        return this.sendAdHocRequests(document, annotation, document.getAdHocRouteNodeName(), adHocRecipients);
    }

    public Document sendAdHocRequests(Document document, String annotation, String adHocRouteNodeName, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.getWorkflowDocumentService().sendWorkflowNotification(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRouteNodeName, adHocRecipients);
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)document.getDocumentHeader().getWorkflowDocument());
        this.removeAdHocPersonsAndWorkgroups(document);
        return document;
    }

    private void removeAdHocPersonsAndWorkgroups(Document document) {
        document.setAdHocRoutePersons(new ArrayList());
        document.setAdHocRouteWorkgroups(new ArrayList());
        this.documentAdHocService.replaceAdHocsForDocument(document);
    }

    @Required
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        }
        return this.dateTimeService;
    }

    @Required
    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    protected LegacyDataAdapter getLegacyDataAdapter() {
        return this.legacyDataAdapter;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    @Required
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    @Required
    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    @Required
    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public DocumentHeaderService getDocumentHeaderService() {
        return this.documentHeaderService;
    }

    @Required
    public void setDocumentHeaderService(DocumentHeaderService documentHeaderService) {
        this.documentHeaderService = documentHeaderService;
    }

    @Required
    public void setDocumentAdHocService(DocumentAdHocService documentAdHocService) {
        this.documentAdHocService = documentAdHocService;
    }
}

