/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;
import org.kuali.rice.location.impl.state.StateBo;

public class LookupableBoValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        DataDictionaryService dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        Map businessObjectEntries = dataDictionaryService.getDataDictionary().getBusinessObjectEntries();
        Map<String, Integer> labelCounts = this.getLabelCounts(businessObjectEntries);
        for (String businessObject : businessObjectEntries.keySet()) {
            ConcreteKeyValue KeyValue2;
            org.kuali.rice.kns.datadictionary.BusinessObjectEntry businessObjectEntry = (org.kuali.rice.kns.datadictionary.BusinessObjectEntry)businessObjectEntries.get(businessObject);
            if (!businessObjectEntry.hasLookupDefinition() || !this.kcBo(businessObject) && !this.supportedRiceBo(businessObject)) continue;
            String key = businessObject;
            Object label = StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
            if (labelCounts.get(label) > 1) {
                label = (String)label + " (" + key.toString().substring(key.toString().lastIndexOf(".") + 1) + ")";
            }
            if (keyValues.contains(KeyValue2 = new ConcreteKeyValue(key, (String)label))) continue;
            keyValues.add((KeyValue)KeyValue2);
        }
        Collections.sort(keyValues, new KeyValueComparator());
        keyValues.add(0, ValuesFinderUtils.getSelectOption());
        return keyValues;
    }

    public Map<String, Integer> getLabelCounts(Map<String, BusinessObjectEntry> businessObjectEntries) {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        for (String businessObject : businessObjectEntries.keySet()) {
            org.kuali.rice.kns.datadictionary.BusinessObjectEntry businessObjectEntry = (org.kuali.rice.kns.datadictionary.BusinessObjectEntry)businessObjectEntries.get(businessObject);
            if (!businessObjectEntry.hasLookupDefinition() || !this.kcBo(businessObject) && !this.supportedRiceBo(businessObject)) continue;
            String label = StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
            if (labels.containsKey(label)) {
                Integer count = (Integer)labels.get(label) + 1;
                labels.put(label, count);
                continue;
            }
            labels.put(label, 1);
        }
        return labels;
    }

    protected boolean kcBo(String businessObject) {
        return businessObject.startsWith("org.kuali.kra") || businessObject.startsWith("org.kuali.coeus");
    }

    protected boolean supportedRiceBo(String businessObject) {
        return businessObject.equals(CampusBo.class.getName()) || businessObject.equals(CountryBo.class.getName()) || businessObject.equals(CountyBo.class.getName()) || businessObject.equals(PostalCodeBo.class.getName()) || businessObject.equals(StateBo.class.getName());
    }
}

