/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.address;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.impl.identity.address.EntityAddressBase;
import org.kuali.rice.kim.impl.identity.address.EntityAddressTypeBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="KRIM_ENTITY_ADDR_T")
public class EntityAddressBo
extends EntityAddressBase
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 0L;
    @PortableSequenceGenerator(name="KRIM_ENTITY_ADDR_ID_S")
    @GeneratedValue(generator="KRIM_ENTITY_ADDR_ID_S")
    @Id
    @Column(name="ENTITY_ADDR_ID")
    private String id;
    @JoinFetch(value=JoinFetchType.OUTER)
    @ManyToOne(targetEntity=EntityAddressTypeBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="ADDR_TYP_CD", referencedColumnName="ADDR_TYP_CD", insertable=false, updatable=false)
    private EntityAddressTypeBo addressType;

    public static EntityAddress to(EntityAddressBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityAddress.Builder.create((EntityAddressContract)bo).build();
    }

    public static EntityAddressBo from(EntityAddress immutable) {
        if (immutable == null) {
            return null;
        }
        EntityAddressBo bo = new EntityAddressBo();
        bo.setActive(immutable.isActive());
        bo.setEntityTypeCode(immutable.getEntityTypeCode());
        if (immutable.getAddressType() != null) {
            bo.setAddressTypeCode(immutable.getAddressType().getCode());
        }
        bo.setAddressType(EntityAddressTypeBo.from(immutable.getAddressType()));
        bo.setDefaultValue(immutable.isDefaultValue());
        bo.setAttentionLine(immutable.getAttentionLineUnmasked());
        bo.setLine1(immutable.getLine1Unmasked());
        bo.setLine2(immutable.getLine2Unmasked());
        bo.setLine3(immutable.getLine3Unmasked());
        bo.setCity(immutable.getCityUnmasked());
        bo.setStateProvinceCode(immutable.getStateProvinceCodeUnmasked());
        bo.setCountryCode(immutable.getCountryCodeUnmasked());
        bo.setPostalCode(immutable.getPostalCodeUnmasked());
        bo.setAddressFormat(immutable.getAddressFormat());
        bo.setModifiedDate(immutable.getModifiedDate());
        bo.setValidatedDate(immutable.getValidatedDate());
        bo.setValidated(immutable.isValidated());
        bo.setNoteMessage(immutable.getNoteMessage());
        bo.setId(immutable.getId());
        bo.setEntityId(immutable.getEntityId());
        bo.setActive(immutable.isActive());
        bo.setVersionNumber(immutable.getVersionNumber());
        return bo;
    }

    public EntityAddressTypeBo getAddressType() {
        return this._persistence_get_addressType();
    }

    public void setAddressType(EntityAddressTypeBo addressType) {
        this._persistence_set_addressType(addressType);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityAddressBo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "addressType") {
            return this.addressType;
        }
        if (string == "id") {
            return this.id;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "addressType") {
            this.addressType = (EntityAddressTypeBo)((Object)object);
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public EntityAddressTypeBo _persistence_get_addressType() {
        this._persistence_checkFetched("addressType");
        return this.addressType;
    }

    public void _persistence_set_addressType(EntityAddressTypeBo entityAddressTypeBo) {
        this._persistence_checkFetchedForSet("addressType");
        this._persistence_propertyChange("addressType", (Object)this.addressType, (Object)entityAddressTypeBo);
        this.addressType = entityAddressTypeBo;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }
}

