/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.country;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.country.CountryContract;
import org.w3c.dom.Element;

@XmlRootElement(name="country")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="CountryType", propOrder={"code", "alternateCode", "name", "nameV3", "restricted", "active", "versionNumber", "_futureElements"})
public final class Country
extends AbstractDataTransferObject
implements CountryContract {
    private static final long serialVersionUID = -8975392777320033940L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="alternateCode", required=false)
    private final String alternateCode;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="nameV3", required=false)
    private final String nameV3;
    @XmlElement(name="restricted", required=true)
    private final boolean restricted;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Country() {
        this.code = null;
        this.alternateCode = null;
        this.name = null;
        this.nameV3 = null;
        this.restricted = false;
        this.active = false;
        this.versionNumber = null;
    }

    private Country(Builder builder) {
        this.code = builder.getCode();
        this.alternateCode = builder.getAlternateCode();
        this.name = builder.getName();
        this.nameV3 = builder.getNameV3();
        this.restricted = builder.isRestricted();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getAlternateCode() {
        return this.alternateCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameV3() {
        return this.nameV3;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/location/v2_0/CountryType";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "country";
        static final String TYPE_NAME = "CountryType";

        Constants() {
        }
    }

    static class Elements {
        static final String CODE = "code";
        static final String ALTERNATE_CODE = "alternateCode";
        static final String NAME = "name";
        static final String NAME_V3 = "nameV3";
        static final String RESTRICTED = "restricted";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    public static class Builder
    implements CountryContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -4786917485397379322L;
        private String code;
        private String alternateCode;
        private String name;
        private String nameV3;
        private boolean restricted;
        private boolean active;
        private Long versionNumber;

        private Builder(String code, String alternateCode, String name, String nameV3, boolean restricted, boolean active) {
            this.setCode(code);
            this.setAlternateCode(alternateCode);
            this.setName(name);
            this.setNameV3(nameV3);
            this.setRestricted(restricted);
            this.setActive(active);
        }

        public static Builder create(String code, String name) {
            return new Builder(code, null, name, null, false, true);
        }

        public static Builder create(String code, String name, String nameV3) {
            return new Builder(code, null, name, nameV3, false, true);
        }

        public static Builder create(String code, String alternatePostalCode, String name, boolean restricted, boolean active) {
            return new Builder(code, alternatePostalCode, name, null, restricted, active);
        }

        public static Builder create(String code, String alternatePostalCode, String name, String nameV3, boolean restricted, boolean active) {
            return new Builder(code, alternatePostalCode, name, nameV3, restricted, active);
        }

        public static Builder create(CountryContract cc) {
            Builder builder = new Builder(cc.getCode(), cc.getAlternateCode(), cc.getName(), cc.getNameV3(), cc.isRestricted(), cc.isActive());
            builder.setVersionNumber(cc.getVersionNumber());
            return builder;
        }

        public Country build() {
            return new Country(this);
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code cannot be blank or null");
            }
            this.code = code;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        public void setAlternateCode(String alternatePostalCode) {
            this.alternateCode = alternatePostalCode;
        }

        @Override
        public String getAlternateCode() {
            return this.alternateCode;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setNameV3(String nameV3) {
            this.nameV3 = nameV3;
        }

        @Override
        public String getNameV3() {
            return this.nameV3;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setRestricted(boolean restricted) {
            this.restricted = restricted;
        }

        @Override
        public boolean isRestricted() {
            return this.restricted;
        }
    }
}

