/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.component.MethodInvokerConfig;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.layout.CssGridSizes;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.modifier.ComponentModifier;
import org.kuali.rice.krad.uif.util.LifecycleAwareMap;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewIndex;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="componentBase", parent="Uif-ComponentBase")
public abstract class ComponentBase
extends UifDictionaryBeanBase
implements Component {
    private static final long serialVersionUID = -4449335748129894350L;
    private String id;
    private String containerIdSuffix;
    private String viewPath;
    private Map<String, String> phasePathMapping;
    private String template;
    private String templateName;
    private String viewStatus = "C";
    private String title;
    private boolean render = true;
    private boolean retrieveViaAjax;
    @KeepExpression
    private String progressiveRender;
    private boolean progressiveRenderViaAJAX = false;
    private boolean progressiveRenderAndRefresh = false;
    private List<String> progressiveDisclosureControlNames;
    private String progressiveDisclosureConditionJs;
    @KeepExpression
    private String conditionalRefresh;
    private String conditionalRefreshConditionJs;
    private List<String> conditionalRefreshControlNames;
    private List<String> refreshWhenChangedPropertyNames;
    private List<String> additionalComponentsToRefresh;
    private String additionalComponentsToRefreshJs;
    private boolean refreshedByAction = false;
    private boolean disclosedByAction;
    private int refreshTimer;
    private boolean resetDataOnRefresh = false;
    private String methodToCallOnRefresh;
    private List<String> fieldsToSendOnRefresh;
    private boolean hidden;
    private Boolean readOnly;
    private Boolean canCopyOnReadOnly = false;
    private Boolean required;
    private String align;
    private String valign;
    private String width;
    private int colSpan = 1;
    private int rowSpan = 1;
    private List<String> wrapperCssClasses;
    private String wrapperStyle;
    private String cellWidth;
    private CssGridSizes cssGridSizes = new CssGridSizes();
    private List<String> layoutCssClasses;
    private String style;
    private List<String> libraryCssClasses;
    private List<String> cssClasses;
    private List<String> additionalCssClasses;
    @DelayedCopy
    private Tooltip toolTip;
    private int order = 0;
    private boolean skipInTabOrder;
    private String finalizeMethodToCall;
    private List<Object> finalizeMethodAdditionalArguments;
    private MethodInvokerConfig finalizeMethodInvoker;
    private boolean selfRendered = false;
    private String renderedHtmlOutput;
    private boolean disableSessionPersistence = false;
    private boolean forceSessionPersistence = false;
    private ComponentSecurity componentSecurity;
    private String onLoadScript;
    private String onUnloadScript;
    private String onCloseScript;
    private String onBlurScript;
    private String onChangeScript;
    private String onClickScript;
    private String onDblClickScript;
    private String onFocusScript;
    private String onSubmitScript;
    private String onInputScript;
    private String onKeyPressScript;
    private String onKeyUpScript;
    private String onKeyDownScript;
    private String onMouseOverScript;
    private String onMouseOutScript;
    private String onMouseUpScript;
    private String onMouseDownScript;
    private String onMouseMoveScript;
    private String onDocumentReadyScript;
    private List<ComponentModifier> componentModifiers;
    protected Map<String, String> templateOptions;
    private String templateOptionsJSString;
    @ReferenceCopy(newCollectionInstance=true)
    private transient Map<String, Object> context;
    private List<PropertyReplacer> propertyReplacers;
    private Map<String, String> dataAttributes;
    private Map<String, String> scriptDataAttributes;
    private String role;
    private Map<String, String> ariaAttributes;
    private String preRenderContent;
    private String postRenderContent;
    private String excludeIf;
    private String excludeUnless;
    private boolean omitFromFormPost;

    public ComponentBase() {
        this.phasePathMapping = new HashMap<String, String>();
        this.context = Collections.emptyMap();
        this.dataAttributes = Collections.emptyMap();
        this.scriptDataAttributes = Collections.emptyMap();
        this.ariaAttributes = Collections.emptyMap();
        this.templateOptions = Collections.emptyMap();
        this.cssClasses = Collections.emptyList();
        this.libraryCssClasses = Collections.emptyList();
        this.additionalCssClasses = Collections.emptyList();
    }

    @Override
    public boolean skipLifecycle() {
        return this.isRetrieveViaAjax();
    }

    @Override
    public void checkMutable(boolean legalDuringInitialization) {
        if ("X".equals(this.viewStatus)) {
            ViewLifecycle.reportIllegalState("Cached component " + this.getClass() + " " + this.getId() + " is immutable, use copy() to get a mutable instance");
            return;
        }
        if (ViewLifecycle.isActive()) {
            return;
        }
        if ("C".equals(this.viewStatus) && !legalDuringInitialization) {
            ViewLifecycle.reportIllegalState("View has not been fully initialized, attempting to change component " + this.getClass() + " " + this.getId());
            return;
        }
    }

    @Override
    public boolean isMutable(boolean legalDuringInitialization) {
        return "C".equals(this.viewStatus) && legalDuringInitialization || ViewLifecycle.isActive();
    }

    @Override
    public String getViewStatus() {
        return this.viewStatus;
    }

    @Override
    public void setViewStatus(String status) {
        if (!"C".equals(status) && !"X".equals(status)) {
            this.checkMutable(true);
        }
        this.viewStatus = status;
    }

    @Override
    public void notifyCompleted(ViewLifecyclePhase phase) {
        ViewIndex viewIndex;
        if (!"PRE_PROCESS".equals(phase.getViewPhase()) && (viewIndex = ViewLifecycle.getView().getViewIndex()) != null) {
            viewIndex.indexComponent(this);
        }
    }

    @Override
    public boolean isInitialized() {
        return StringUtils.equals((String)this.viewStatus, (String)"I") || this.isModelApplied();
    }

    @Override
    public boolean isModelApplied() {
        return StringUtils.equals((String)this.viewStatus, (String)"M") || this.isFinal();
    }

    @Override
    public boolean isFinal() {
        return StringUtils.equals((String)this.viewStatus, (String)"F") || this.isRendered();
    }

    @Override
    public boolean isRendered() {
        return StringUtils.equals((String)this.viewStatus, (String)"R");
    }

    @Override
    public void performInitialization(Object model) {
        if (this.componentModifiers != null) {
            for (ComponentModifier modifier : this.componentModifiers) {
                modifier.performInitialization(model, this);
            }
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        View view = ViewLifecycle.getView();
        if (this.render && StringUtils.isNotEmpty((String)this.progressiveRender)) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            String adjustedProgressiveRender = expressionEvaluator.replaceBindingPrefixes(view, this, this.progressiveRender);
            Boolean progRenderEval = (Boolean)expressionEvaluator.evaluateExpression(this.context, adjustedProgressiveRender);
            this.setRender(progRenderEval);
        }
    }

    @Override
    public void afterEvaluateExpression() {
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        View view = ViewLifecycle.getView();
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.progressiveRender)) {
            this.progressiveRender = expressionEvaluator.replaceBindingPrefixes(view, this, this.progressiveRender);
            this.progressiveDisclosureControlNames = new ArrayList<String>();
            this.progressiveDisclosureConditionJs = expressionEvaluator.parseExpression(this.progressiveRender, this.progressiveDisclosureControlNames, this.getContext());
        }
        if (StringUtils.isNotEmpty((String)this.conditionalRefresh)) {
            this.conditionalRefresh = expressionEvaluator.replaceBindingPrefixes(view, this, this.conditionalRefresh);
            this.conditionalRefreshControlNames = new ArrayList<String>();
            this.conditionalRefreshConditionJs = expressionEvaluator.parseExpression(this.conditionalRefresh, this.conditionalRefreshControlNames, this.getContext());
        }
        if (this.refreshWhenChangedPropertyNames != null) {
            ArrayList<String> adjustedRefreshPropertyNames = new ArrayList<String>(this.refreshWhenChangedPropertyNames.size());
            for (String refreshPropertyName : this.refreshWhenChangedPropertyNames) {
                adjustedRefreshPropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, refreshPropertyName));
            }
            this.refreshWhenChangedPropertyNames = adjustedRefreshPropertyNames;
            if (!this.retrieveViaAjax) {
                ViewLifecycle.getViewPostMetadata().addAccessibleMethodToCall("refresh");
            }
        }
        if (this.retrieveViaAjax) {
            this.forceSessionPersistence = true;
        }
        if (StringUtils.isNotBlank((String)this.getAlign()) && !StringUtils.contains((String)this.getStyle(), (String)"text-align: ")) {
            this.appendToStyle("text-align: " + this.getAlign() + ";");
        }
        if (StringUtils.isNotBlank((String)this.getValign()) && !StringUtils.contains((String)this.getStyle(), (String)"vertical-align: ")) {
            this.appendToStyle("vertical-align: " + this.getValign() + ";");
        }
        if (StringUtils.isNotBlank((String)this.getWidth()) && !StringUtils.contains((String)this.getStyle(), (String)"width: ")) {
            this.appendToStyle("width: " + this.getWidth() + ";");
        }
        if (this.skipInTabOrder) {
            for (LifecycleElement component : ViewLifecycleUtils.getElementsForLifecycle(this).values()) {
                if (component == null || !(component instanceof ComponentBase)) continue;
                ((ComponentBase)component).setSkipInTabOrder(this.skipInTabOrder);
                if (!(component instanceof ControlBase)) continue;
                ((ControlBase)component).setTabIndex(-1);
            }
        }
        boolean hide = false;
        if (!this.render && !this.progressiveRenderViaAJAX && !this.progressiveRenderAndRefresh && StringUtils.isNotBlank((String)this.progressiveRender)) {
            hide = true;
        } else if (this.isHidden()) {
            hide = true;
        }
        if (hide) {
            if (StringUtils.isNotBlank((String)this.getStyle())) {
                if (this.getStyle().endsWith(";")) {
                    this.setStyle(this.getStyle() + " display: none;");
                } else {
                    this.setStyle(this.getStyle() + "; display: none;");
                }
            } else {
                this.setStyle("display: none;");
            }
        }
        if (this.refreshTimer > 0) {
            Object timerScript = this.getOnDocumentReadyScript();
            if (StringUtils.isBlank((String)this.methodToCallOnRefresh)) {
                this.methodToCallOnRefresh = "refresh";
            }
            timerScript = null == timerScript ? "" : timerScript;
            timerScript = "refreshComponentUsingTimer('" + this.id + "','" + this.methodToCallOnRefresh + "'," + this.refreshTimer + ");" + (String)timerScript;
            this.setOnDocumentReadyScript((String)timerScript);
        }
        if (this.getToolTip() != null && StringUtils.isNotBlank((String)this.getToolTip().getTooltipContent())) {
            this.addStyleClass("uif-tooltip");
        }
        LinkedHashSet<String> finalCssClasses = new LinkedHashSet<String>();
        if (this.libraryCssClasses != null && (!ViewLifecycle.isActive() || ViewLifecycle.getView().isUseLibraryCssClasses())) {
            finalCssClasses.addAll(this.libraryCssClasses);
            this.libraryCssClasses.clear();
        }
        if (this.cssClasses != null) {
            finalCssClasses.addAll(this.cssClasses);
            this.cssClasses.clear();
        }
        if (this.additionalCssClasses != null) {
            finalCssClasses.addAll(this.additionalCssClasses);
            this.additionalCssClasses.clear();
        }
        ArrayList<String> newCssClasses = new ArrayList<String>();
        newCssClasses.addAll(finalCssClasses);
        this.cssClasses = newCssClasses;
        if (StringUtils.isNotBlank((String)this.methodToCallOnRefresh)) {
            ViewLifecycle.getViewPostMetadata().addAvailableMethodToCall(this.methodToCallOnRefresh);
        }
        if ((this.isRender() || StringUtils.isNotBlank((String)this.getProgressiveRender())) && StringUtils.isNotBlank((String)this.methodToCallOnRefresh)) {
            ViewLifecycle.getViewPostMetadata().addAccessibleMethodToCall(this.methodToCallOnRefresh);
        }
    }

    @Override
    @ViewLifecycleRestriction
    public List<Component> getPropertyReplacerComponents() {
        if (this.propertyReplacers == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (PropertyReplacer replacer : this.propertyReplacers) {
            components.addAll(replacer.getNestedComponents());
        }
        return components;
    }

    @Override
    @BeanTagAttribute
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.checkMutable(true);
        this.id = id;
    }

    @Override
    public String getContainerIdSuffix() {
        return this.containerIdSuffix;
    }

    @Override
    public void setContainerIdSuffix(String containerIdSuffix) {
        this.containerIdSuffix = containerIdSuffix;
    }

    @Override
    public String getViewPath() {
        return this.viewPath;
    }

    @Override
    public void setViewPath(String viewPath) {
        this.checkMutable(true);
        this.viewPath = viewPath;
    }

    @Override
    public Map<String, String> getPhasePathMapping() {
        return this.phasePathMapping;
    }

    @Override
    public void setPhasePathMapping(Map<String, String> phasePathMapping) {
        this.phasePathMapping = phasePathMapping;
    }

    @Override
    @BeanTagAttribute
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.checkMutable(true);
        this.template = template;
    }

    @Override
    public List<String> getAdditionalTemplates() {
        return Collections.emptyList();
    }

    @Override
    @BeanTagAttribute
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.checkMutable(true);
        this.templateName = templateName;
    }

    @Override
    @BeanTagAttribute
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.checkMutable(true);
        this.title = title;
    }

    @Override
    @BeanTagAttribute
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.checkMutable(true);
        this.hidden = hidden;
    }

    @Override
    @BeanTagAttribute
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean readOnly) {
        this.checkMutable(true);
        this.readOnly = readOnly;
    }

    @Override
    public Boolean getCanCopyOnReadOnly() {
        return this.canCopyOnReadOnly;
    }

    @Override
    public void setCanCopyOnReadOnly(Boolean canCopyOnReadOnly) {
        this.canCopyOnReadOnly = canCopyOnReadOnly;
    }

    @Override
    @BeanTagAttribute
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.checkMutable(true);
        this.required = required;
    }

    @Override
    @BeanTagAttribute
    public boolean isRender() {
        return this.render;
    }

    @Override
    public void setRender(boolean render) {
        this.checkMutable(true);
        this.render = render;
    }

    @Override
    @BeanTagAttribute
    public boolean isRetrieveViaAjax() {
        return this.retrieveViaAjax;
    }

    @Override
    public void setRetrieveViaAjax(boolean retrieveViaAjax) {
        this.checkMutable(true);
        this.retrieveViaAjax = retrieveViaAjax;
    }

    @Override
    @BeanTagAttribute
    public int getColSpan() {
        return this.colSpan;
    }

    @Override
    public void setColSpan(int colSpan) {
        this.checkMutable(true);
        this.colSpan = colSpan;
    }

    @Override
    @BeanTagAttribute
    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public void setRowSpan(int rowSpan) {
        this.checkMutable(true);
        this.rowSpan = rowSpan;
    }

    @Override
    @BeanTagAttribute
    public List<String> getWrapperCssClasses() {
        return this.wrapperCssClasses;
    }

    @Override
    public void setWrapperCssClasses(List<String> wrapperCssClasses) {
        this.checkMutable(true);
        this.wrapperCssClasses = wrapperCssClasses;
    }

    @Override
    public void addWrapperCssClass(String cssClass) {
        this.checkMutable(false);
        if (this.wrapperCssClasses == null) {
            this.wrapperCssClasses = new ArrayList<String>();
        }
        if (cssClass != null) {
            this.wrapperCssClasses.add(cssClass);
        }
    }

    public String getWrapperCssClassesAsString() {
        if (this.wrapperCssClasses != null) {
            return StringUtils.join(this.wrapperCssClasses, (String)" ").trim();
        }
        return "";
    }

    @Override
    @BeanTagAttribute
    public String getWrapperStyle() {
        return this.wrapperStyle;
    }

    @Override
    public void setWrapperStyle(String wrapperStyle) {
        this.checkMutable(true);
        this.wrapperStyle = wrapperStyle;
    }

    @Override
    @BeanTagAttribute
    public String getCellWidth() {
        return this.cellWidth;
    }

    @Override
    public void setCellWidth(String cellWidth) {
        this.checkMutable(true);
        this.cellWidth = cellWidth;
    }

    @Override
    @BeanTagAttribute
    public CssGridSizes getCssGridSizes() {
        return this.cssGridSizes;
    }

    @Override
    public void setCssGridSizes(CssGridSizes cssGridSizes) {
        this.cssGridSizes = cssGridSizes;
    }

    @Override
    @BeanTagAttribute
    public String getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(String align) {
        this.checkMutable(true);
        this.align = align;
    }

    @Override
    @BeanTagAttribute
    public String getValign() {
        return this.valign;
    }

    @Override
    public void setValign(String valign) {
        this.checkMutable(true);
        this.valign = valign;
    }

    @Override
    @BeanTagAttribute
    public String getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(String width) {
        this.checkMutable(true);
        this.width = width;
    }

    @Override
    @BeanTagAttribute
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.checkMutable(true);
        this.style = style;
    }

    @Override
    public List<String> getLibraryCssClasses() {
        if (this.libraryCssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.libraryCssClasses = new ArrayList<String>();
        }
        return this.libraryCssClasses;
    }

    @Override
    public void setLibraryCssClasses(List<String> libraryCssClasses) {
        this.checkMutable(true);
        this.libraryCssClasses = libraryCssClasses == null ? Collections.emptyList() : libraryCssClasses;
    }

    @Override
    @BeanTagAttribute
    public List<String> getCssClasses() {
        if (this.cssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.cssClasses = new ArrayList<String>();
        }
        return this.cssClasses;
    }

    @Override
    public void setCssClasses(List<String> cssClasses) {
        this.checkMutable(true);
        this.cssClasses = cssClasses == null ? Collections.emptyList() : cssClasses;
    }

    @Override
    @BeanTagAttribute
    public List<String> getAdditionalCssClasses() {
        if (this.additionalCssClasses == Collections.EMPTY_LIST && this.isMutable(true)) {
            this.additionalCssClasses = new ArrayList<String>();
        }
        return this.additionalCssClasses;
    }

    @Override
    public void setAdditionalCssClasses(List<String> additionalCssClasses) {
        this.checkMutable(true);
        this.additionalCssClasses = additionalCssClasses == null ? Collections.emptyList() : additionalCssClasses;
    }

    @Override
    public String getStyleClassesAsString() {
        if (this.cssClasses != null) {
            return StringUtils.join(this.cssClasses, (String)" ").trim();
        }
        return "";
    }

    @Override
    public void addStyleClass(String styleClass) {
        this.checkMutable(false);
        if (StringUtils.isEmpty((String)styleClass)) {
            return;
        }
        if (this.cssClasses.isEmpty()) {
            this.setCssClasses(new ArrayList<String>());
        }
        if (!this.cssClasses.contains(styleClass)) {
            this.cssClasses.add(styleClass);
        }
    }

    @Override
    public void appendToStyle(String styleRules) {
        this.checkMutable(false);
        if (this.style == null) {
            this.style = "";
        }
        this.style = this.style + styleRules;
    }

    @Override
    @BeanTagAttribute
    public String getFinalizeMethodToCall() {
        return this.finalizeMethodToCall;
    }

    public void setFinalizeMethodToCall(String finalizeMethodToCall) {
        this.checkMutable(true);
        this.finalizeMethodToCall = finalizeMethodToCall;
    }

    @Override
    @BeanTagAttribute
    public List<Object> getFinalizeMethodAdditionalArguments() {
        return this.finalizeMethodAdditionalArguments;
    }

    public void setFinalizeMethodAdditionalArguments(List<Object> finalizeMethodAdditionalArguments) {
        this.checkMutable(true);
        this.finalizeMethodAdditionalArguments = finalizeMethodAdditionalArguments;
    }

    @Override
    @BeanTagAttribute
    public MethodInvokerConfig getFinalizeMethodInvoker() {
        return this.finalizeMethodInvoker;
    }

    public void setFinalizeMethodInvoker(MethodInvokerConfig finalizeMethodInvoker) {
        this.checkMutable(true);
        this.finalizeMethodInvoker = finalizeMethodInvoker;
    }

    @Override
    @BeanTagAttribute
    public boolean isSelfRendered() {
        return this.selfRendered;
    }

    @Override
    public void setSelfRendered(boolean selfRendered) {
        this.selfRendered = selfRendered;
    }

    @Override
    @BeanTagAttribute
    public String getRenderedHtmlOutput() {
        return this.renderedHtmlOutput;
    }

    @Override
    public void setRenderedHtmlOutput(String renderedHtmlOutput) {
        this.renderedHtmlOutput = renderedHtmlOutput;
    }

    @Override
    @BeanTagAttribute
    public boolean isDisableSessionPersistence() {
        return this.disableSessionPersistence;
    }

    @Override
    public void setDisableSessionPersistence(boolean disableSessionPersistence) {
        this.checkMutable(true);
        this.disableSessionPersistence = disableSessionPersistence;
    }

    @Override
    @BeanTagAttribute
    public boolean isForceSessionPersistence() {
        return this.forceSessionPersistence;
    }

    @Override
    public void setForceSessionPersistence(boolean forceSessionPersistence) {
        this.checkMutable(true);
        this.forceSessionPersistence = forceSessionPersistence;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public ComponentSecurity getComponentSecurity() {
        return this.componentSecurity;
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        this.checkMutable(true);
        this.componentSecurity = componentSecurity;
    }

    protected void initializeComponentSecurity() {
        if (this.componentSecurity == null) {
            this.componentSecurity = KRADUtils.createNewObjectFromClass(ComponentSecurity.class);
        }
    }

    @BeanTagAttribute
    public Boolean isEditAuthz() {
        this.initializeComponentSecurity();
        return this.componentSecurity.isEditAuthz();
    }

    public void setEditAuthz(Boolean editAuthz) {
        this.checkMutable(true);
        this.initializeComponentSecurity();
        this.componentSecurity.setEditAuthz(editAuthz);
    }

    @BeanTagAttribute
    public Boolean isViewAuthz() {
        this.initializeComponentSecurity();
        return this.componentSecurity.isViewAuthz();
    }

    public void setViewAuthz(Boolean viewAuthz) {
        this.checkMutable(true);
        this.initializeComponentSecurity();
        this.componentSecurity.setViewAuthz(viewAuthz);
    }

    @Override
    @BeanTagAttribute
    public List<ComponentModifier> getComponentModifiers() {
        return this.componentModifiers;
    }

    @Override
    public void setComponentModifiers(List<ComponentModifier> componentModifiers) {
        this.checkMutable(true);
        this.componentModifiers = componentModifiers == null ? Collections.emptyList() : componentModifiers;
    }

    @Override
    @BeanTagAttribute
    public Map<String, Object> getContext() {
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new HashMap<String, Object>();
        }
        return this.context;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.checkMutable(true);
        this.context = context == null ? Collections.emptyMap() : context;
    }

    @Override
    public void pushObjectToContext(String objectName, Object object) {
        this.checkMutable(true);
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new HashMap<String, Object>();
        }
        this.pushToPropertyReplacerContext(objectName, object);
        this.context.put(objectName, object);
    }

    protected void pushToPropertyReplacerContext(String objectName, Object object) {
        this.checkMutable(true);
        List<Component> propertyReplacerComponents = this.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component replacerComponent : propertyReplacerComponents) {
                replacerComponent.pushObjectToContext(objectName, object);
            }
        }
    }

    @Override
    public void pushAllToContext(Map<String, Object> objects) {
        this.checkMutable(true);
        if (objects == null || objects.isEmpty()) {
            return;
        }
        if (this.context == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.context = new HashMap<String, Object>();
        }
        this.context.putAll(objects);
        List<Component> propertyReplacerComponents = this.getPropertyReplacerComponents();
        if (propertyReplacerComponents != null) {
            for (Component replacerComponent : propertyReplacerComponents) {
                replacerComponent.pushAllToContext(objects);
            }
        }
    }

    @Override
    @BeanTagAttribute
    public List<PropertyReplacer> getPropertyReplacers() {
        return this.propertyReplacers;
    }

    @Override
    public void setPropertyReplacers(List<PropertyReplacer> propertyReplacers) {
        this.checkMutable(true);
        this.propertyReplacers = propertyReplacers == null ? Collections.emptyList() : propertyReplacers;
    }

    @Override
    @BeanTagAttribute
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.checkMutable(true);
        this.order = order;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Tooltip getToolTip() {
        return this.toolTip;
    }

    @Override
    public void setToolTip(Tooltip toolTip) {
        this.checkMutable(true);
        this.toolTip = toolTip;
    }

    @Override
    public String getEventHandlerScript() {
        StringBuilder sb = new StringBuilder();
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "load", this.getOnLoadScript()));
        if (StringUtils.isNotBlank((String)this.getOnDocumentReadyScript())) {
            sb.append("jQuery(document).ready(function(e) {");
            sb.append(this.getOnDocumentReadyScript());
            sb.append("});");
        }
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "unload", this.getOnUnloadScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "blur", this.getOnBlurScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "change", this.getOnChangeScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "click", this.getOnClickScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "dblclick", this.getOnDblClickScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "focus", this.getOnFocusScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "input", this.getOnInputScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keypress", this.getOnKeyPressScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keyup", this.getOnKeyUpScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "keydown", this.getOnKeyDownScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseover", this.getOnMouseOverScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseout", this.getOnMouseOutScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mouseup", this.getOnMouseUpScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mousedown", this.getOnMouseDownScript()));
        sb.append(ScriptUtils.buildEventHandlerScript(this.getId(), "mousemove", this.getOnMouseMoveScript()));
        return sb.toString();
    }

    @Override
    @BeanTagAttribute
    public String getOnLoadScript() {
        return this.onLoadScript;
    }

    @Override
    public void setOnLoadScript(String onLoadScript) {
        this.checkMutable(true);
        this.onLoadScript = onLoadScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnDocumentReadyScript() {
        return this.onDocumentReadyScript;
    }

    @Override
    public void setOnDocumentReadyScript(String onDocumentReadyScript) {
        this.checkMutable(true);
        this.onDocumentReadyScript = onDocumentReadyScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnUnloadScript() {
        return this.onUnloadScript;
    }

    @Override
    public void setOnUnloadScript(String onUnloadScript) {
        this.checkMutable(true);
        this.onUnloadScript = onUnloadScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnCloseScript() {
        return this.onCloseScript;
    }

    @Override
    public void setOnCloseScript(String onCloseScript) {
        this.checkMutable(true);
        this.onCloseScript = onCloseScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnBlurScript() {
        return this.onBlurScript;
    }

    @Override
    public void setOnBlurScript(String onBlurScript) {
        this.checkMutable(true);
        this.onBlurScript = onBlurScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnChangeScript() {
        return this.onChangeScript;
    }

    @Override
    public void setOnChangeScript(String onChangeScript) {
        this.checkMutable(true);
        this.onChangeScript = onChangeScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnClickScript() {
        return this.onClickScript;
    }

    @Override
    public void setOnClickScript(String onClickScript) {
        this.checkMutable(true);
        this.onClickScript = onClickScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnDblClickScript() {
        return this.onDblClickScript;
    }

    @Override
    public void setOnDblClickScript(String onDblClickScript) {
        this.checkMutable(true);
        this.onDblClickScript = onDblClickScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnFocusScript() {
        return this.onFocusScript;
    }

    @Override
    public void setOnFocusScript(String onFocusScript) {
        this.checkMutable(true);
        this.onFocusScript = onFocusScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnSubmitScript() {
        return this.onSubmitScript;
    }

    @Override
    public void setOnSubmitScript(String onSubmitScript) {
        this.checkMutable(true);
        this.onSubmitScript = onSubmitScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnInputScript() {
        return this.onInputScript;
    }

    @Override
    public void setOnInputScript(String onInputScript) {
        this.checkMutable(true);
        this.onInputScript = onInputScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnKeyPressScript() {
        return this.onKeyPressScript;
    }

    @Override
    public void setOnKeyPressScript(String onKeyPressScript) {
        this.checkMutable(true);
        this.onKeyPressScript = onKeyPressScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnKeyUpScript() {
        return this.onKeyUpScript;
    }

    @Override
    public void setOnKeyUpScript(String onKeyUpScript) {
        this.checkMutable(true);
        this.onKeyUpScript = onKeyUpScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnKeyDownScript() {
        return this.onKeyDownScript;
    }

    @Override
    public void setOnKeyDownScript(String onKeyDownScript) {
        this.checkMutable(true);
        this.onKeyDownScript = onKeyDownScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnMouseOverScript() {
        return this.onMouseOverScript;
    }

    @Override
    public void setOnMouseOverScript(String onMouseOverScript) {
        this.checkMutable(true);
        this.onMouseOverScript = onMouseOverScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnMouseOutScript() {
        return this.onMouseOutScript;
    }

    @Override
    public void setOnMouseOutScript(String onMouseOutScript) {
        this.checkMutable(true);
        this.onMouseOutScript = onMouseOutScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnMouseUpScript() {
        return this.onMouseUpScript;
    }

    @Override
    public void setOnMouseUpScript(String onMouseUpScript) {
        this.checkMutable(true);
        this.onMouseUpScript = onMouseUpScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnMouseDownScript() {
        return this.onMouseDownScript;
    }

    @Override
    public void setOnMouseDownScript(String onMouseDownScript) {
        this.checkMutable(true);
        this.onMouseDownScript = onMouseDownScript;
    }

    @Override
    @BeanTagAttribute
    public String getOnMouseMoveScript() {
        return this.onMouseMoveScript;
    }

    @Override
    public void setOnMouseMoveScript(String onMouseMoveScript) {
        this.checkMutable(true);
        this.onMouseMoveScript = onMouseMoveScript;
    }

    @Override
    @BeanTagAttribute
    public Map<String, String> getTemplateOptions() {
        if (this.templateOptions == Collections.EMPTY_MAP && this.isMutable(true)) {
            this.templateOptions = new HashMap<String, String>();
        }
        return this.templateOptions;
    }

    @Override
    public void setTemplateOptions(Map<String, String> templateOptions) {
        this.checkMutable(true);
        this.templateOptions = templateOptions == null ? Collections.emptyMap() : templateOptions;
    }

    @Override
    @BeanTagAttribute
    public String getTemplateOptionsJSString() {
        if (this.templateOptionsJSString != null) {
            return this.templateOptionsJSString;
        }
        if (this.templateOptions == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> option : this.templateOptions.entrySet()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(option.getKey());
            sb.append(":");
            sb.append(ScriptUtils.convertToJsValue(option.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setTemplateOptionsJSString(String templateOptionsJSString) {
        this.checkMutable(true);
        this.templateOptionsJSString = templateOptionsJSString;
    }

    @Override
    @BeanTagAttribute
    public String getProgressiveRender() {
        return this.progressiveRender;
    }

    @Override
    public void setProgressiveRender(String progressiveRender) {
        this.checkMutable(true);
        this.progressiveRender = progressiveRender;
    }

    @Override
    @BeanTagAttribute
    public String getConditionalRefresh() {
        return this.conditionalRefresh;
    }

    @Override
    public void setConditionalRefresh(String conditionalRefresh) {
        this.checkMutable(true);
        this.conditionalRefresh = conditionalRefresh;
    }

    @Override
    public List<String> getProgressiveDisclosureControlNames() {
        return this.progressiveDisclosureControlNames;
    }

    @Override
    public String getProgressiveDisclosureConditionJs() {
        return this.progressiveDisclosureConditionJs;
    }

    @Override
    public String getConditionalRefreshConditionJs() {
        return this.conditionalRefreshConditionJs;
    }

    @Override
    public List<String> getConditionalRefreshControlNames() {
        return this.conditionalRefreshControlNames;
    }

    @Override
    @BeanTagAttribute
    public boolean isProgressiveRenderViaAJAX() {
        return this.progressiveRenderViaAJAX;
    }

    @Override
    public void setProgressiveRenderViaAJAX(boolean progressiveRenderViaAJAX) {
        this.checkMutable(true);
        this.progressiveRenderViaAJAX = progressiveRenderViaAJAX;
    }

    @Override
    @BeanTagAttribute
    public boolean isProgressiveRenderAndRefresh() {
        return this.progressiveRenderAndRefresh;
    }

    @Override
    public void setProgressiveRenderAndRefresh(boolean progressiveRenderAndRefresh) {
        this.checkMutable(true);
        this.progressiveRenderAndRefresh = progressiveRenderAndRefresh;
    }

    @Override
    @BeanTagAttribute
    public List<String> getRefreshWhenChangedPropertyNames() {
        return this.refreshWhenChangedPropertyNames;
    }

    @Override
    public void setRefreshWhenChangedPropertyNames(List<String> refreshWhenChangedPropertyNames) {
        this.checkMutable(true);
        this.refreshWhenChangedPropertyNames = refreshWhenChangedPropertyNames == null ? Collections.emptyList() : Collections.unmodifiableList(refreshWhenChangedPropertyNames);
    }

    @Override
    @BeanTagAttribute(name="additionalComponentsToRefresh", type=BeanTagAttribute.AttributeType.LISTVALUE)
    public List<String> getAdditionalComponentsToRefresh() {
        return this.additionalComponentsToRefresh;
    }

    @Override
    public void setAdditionalComponentsToRefresh(List<String> additionalComponentsToRefresh) {
        this.checkMutable(true);
        this.additionalComponentsToRefresh = additionalComponentsToRefresh == null ? Collections.emptyList() : Collections.unmodifiableList(additionalComponentsToRefresh);
        this.additionalComponentsToRefreshJs = null;
    }

    @Override
    public String getAdditionalComponentsToRefreshJs() {
        if (this.additionalComponentsToRefreshJs == null && this.additionalComponentsToRefresh != null && !this.additionalComponentsToRefresh.isEmpty()) {
            this.additionalComponentsToRefreshJs = ScriptUtils.convertStringListToJsArray(this.getAdditionalComponentsToRefresh());
        }
        return this.additionalComponentsToRefreshJs;
    }

    @Override
    public boolean isRefreshedByAction() {
        return this.refreshedByAction;
    }

    @Override
    public void setRefreshedByAction(boolean refreshedByAction) {
        this.checkMutable(true);
        this.refreshedByAction = refreshedByAction;
    }

    @Override
    public boolean isDisclosedByAction() {
        return this.disclosedByAction;
    }

    @Override
    public void setDisclosedByAction(boolean disclosedByAction) {
        this.checkMutable(true);
        this.disclosedByAction = disclosedByAction;
    }

    @Override
    @BeanTagAttribute
    public int getRefreshTimer() {
        return this.refreshTimer;
    }

    @Override
    public void setRefreshTimer(int refreshTimer) {
        this.checkMutable(true);
        this.refreshTimer = refreshTimer;
    }

    @Override
    @BeanTagAttribute
    public boolean isResetDataOnRefresh() {
        return this.resetDataOnRefresh;
    }

    @Override
    public void setResetDataOnRefresh(boolean resetDataOnRefresh) {
        this.checkMutable(true);
        this.resetDataOnRefresh = resetDataOnRefresh;
    }

    @Override
    @BeanTagAttribute
    public String getMethodToCallOnRefresh() {
        return this.methodToCallOnRefresh;
    }

    public void setMethodToCallOnRefresh(String methodToCallOnRefresh) {
        this.checkMutable(true);
        this.methodToCallOnRefresh = methodToCallOnRefresh;
    }

    @Override
    @BeanTagAttribute
    public List<String> getFieldsToSendOnRefresh() {
        return this.fieldsToSendOnRefresh;
    }

    @Override
    public void setFieldsToSendOnRefresh(List<String> fieldsToSendOnRefresh) {
        this.fieldsToSendOnRefresh = fieldsToSendOnRefresh;
    }

    @BeanTagAttribute
    public boolean isSkipInTabOrder() {
        return this.skipInTabOrder;
    }

    public void setSkipInTabOrder(boolean skipInTabOrder) {
        this.checkMutable(true);
        this.skipInTabOrder = skipInTabOrder;
    }

    @Override
    @BeanTagAttribute
    public Map<String, String> getDataAttributes() {
        if (this.dataAttributes == Collections.EMPTY_MAP) {
            this.dataAttributes = new HashMap<String, String>();
        }
        return this.dataAttributes;
    }

    @Override
    public void setDataAttributes(Map<String, String> dataAttributes) {
        this.checkMutable(true);
        this.dataAttributes = dataAttributes == null ? Collections.emptyMap() : dataAttributes;
    }

    @Override
    @BeanTagAttribute
    public Map<String, String> getScriptDataAttributes() {
        if (this.scriptDataAttributes == Collections.EMPTY_MAP) {
            this.scriptDataAttributes = new HashMap<String, String>();
        }
        return this.scriptDataAttributes;
    }

    @Override
    public void setScriptDataAttributes(Map<String, String> scriptDataAttributes) {
        this.scriptDataAttributes = scriptDataAttributes;
    }

    @Override
    public void addDataAttribute(String key, String value) {
        this.checkMutable(true);
        if (this.dataAttributes == Collections.EMPTY_MAP) {
            this.dataAttributes = new HashMap<String, String>();
        }
        this.dataAttributes.put(key, value);
    }

    @Override
    public void addScriptDataAttribute(String key, String value) {
        this.checkMutable(true);
        if (this.scriptDataAttributes == Collections.EMPTY_MAP) {
            this.scriptDataAttributes = new HashMap<String, String>();
        }
        this.scriptDataAttributes.put(key, value);
    }

    @Override
    public String getSimpleDataAttributes() {
        Object attributes = "";
        if (this.getDataAttributes() == null) {
            return attributes;
        }
        for (Map.Entry<String, String> data : this.getDataAttributes().entrySet()) {
            if (data == null || data.getValue() == null) continue;
            attributes = (String)attributes + " data-" + data.getKey() + "=\"" + KRADUtils.convertToHTMLAttributeSafeString(data.getValue()) + "\"";
        }
        return attributes;
    }

    @Override
    public String getScriptDataAttributesJs() {
        String script = "";
        if (this.getScriptDataAttributes() == null || this.getScriptDataAttributes().isEmpty()) {
            return script;
        }
        String id = this.getId().replace(".", "\\\\.");
        String selector = "var dataComponent = jQuery('#" + id + "');";
        script = ScriptUtils.appendScript(script, selector);
        for (Map.Entry<String, String> data : this.getScriptDataAttributes().entrySet()) {
            if (data == null || data.getValue() == null) continue;
            script = ScriptUtils.appendScript(script, "dataComponent.data('" + data.getKey() + "'," + ScriptUtils.convertToJsValue(data.getValue()) + ");");
        }
        return StringUtils.replaceChars((String)StringUtils.replaceChars((String)script, (String)"\n", (String)""), (String)"\r", (String)"");
    }

    @Override
    @BeanTagAttribute
    public String getRole() {
        return this.role;
    }

    @Override
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    @BeanTagAttribute
    public Map<String, String> getAriaAttributes() {
        if (this.ariaAttributes == Collections.EMPTY_MAP) {
            this.ariaAttributes = new LifecycleAwareMap<String, String>(this);
        }
        return this.ariaAttributes;
    }

    @Override
    public void setAriaAttributes(Map<String, String> ariaAttributes) {
        this.checkMutable(true);
        this.ariaAttributes = ariaAttributes == null ? Collections.emptyMap() : new LifecycleAwareMap<String, String>(this, ariaAttributes);
    }

    @Override
    public void addAriaAttribute(String key, String value) {
        this.checkMutable(true);
        if (this.ariaAttributes == Collections.EMPTY_MAP) {
            this.ariaAttributes = new LifecycleAwareMap<String, String>(this);
        }
        this.ariaAttributes.put(key, value);
    }

    @Override
    public String getAriaAttributesAsString() {
        Object attributes = "";
        if (this.getAriaAttributes() == null) {
            return attributes;
        }
        for (Map.Entry<String, String> aria : this.getAriaAttributes().entrySet()) {
            if (aria == null || aria.getValue() == null) continue;
            attributes = (String)attributes + " aria-" + aria.getKey() + "=\"" + KRADUtils.convertToHTMLAttributeSafeString(aria.getValue()) + "\"";
        }
        return attributes;
    }

    @Override
    @BeanTagAttribute(name="preContent", type=BeanTagAttribute.AttributeType.ANY)
    public String getPreRenderContent() {
        return this.preRenderContent;
    }

    @Override
    public void setPreRenderContent(String preRenderContent) {
        this.checkMutable(true);
        this.preRenderContent = preRenderContent;
    }

    @Override
    @BeanTagAttribute(name="postContent", type=BeanTagAttribute.AttributeType.ANY)
    public String getPostRenderContent() {
        return this.postRenderContent;
    }

    @Override
    public void setPostRenderContent(String postRenderContent) {
        this.checkMutable(true);
        this.postRenderContent = postRenderContent;
    }

    @Override
    public String getExcludeIf() {
        return this.excludeIf;
    }

    public void setExcludeIf(String excludeIf) {
        this.excludeIf = excludeIf;
    }

    @Override
    public String getExcludeUnless() {
        return this.excludeUnless;
    }

    public void setExcludeUnless(String excludeUnless) {
        this.excludeUnless = excludeUnless;
    }

    @Override
    public ComponentBase clone() throws CloneNotSupportedException {
        ComponentBase copy = (ComponentBase)super.clone();
        copy.viewStatus = "I".equals(this.viewStatus) ? "I" : "C";
        return copy;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getId() != null && (this.getId().contains("'") || this.getId().contains("\"") || this.getId().contains("[]") || this.getId().contains(".") || this.getId().contains("#"))) {
            currentValues = new String[]{"id = " + this.getId()};
            tracer.createError("Id contains invalid characters", currentValues);
        }
        if (tracer.getValidationStage() == 1 && (this.isProgressiveRenderViaAJAX() || this.isProgressiveRenderAndRefresh()) && this.getProgressiveRender() == null) {
            currentValues = new String[]{"progressiveRenderViaAJAX = " + this.isProgressiveRenderViaAJAX(), "progressiveRenderAndRefresh = " + this.isProgressiveRenderAndRefresh(), "progressiveRender = " + this.getProgressiveRender()};
            tracer.createError("ProgressiveRender must be set if progressiveRenderViaAJAX or progressiveRenderAndRefresh are true", currentValues);
        }
        if (this.isSelfRendered() && this.getRenderedHtmlOutput() == null) {
            currentValues = new String[]{"selfRendered = " + this.isSelfRendered(), "renderedHtmlOutput = " + this.getRenderedHtmlOutput()};
            tracer.createError("RenderedHtmlOutput must be set if selfRendered is true", currentValues);
        }
        if (this.isDisableSessionPersistence() && this.isForceSessionPersistence()) {
            currentValues = new String[]{"disableSessionPersistence = " + this.isDisableSessionPersistence(), "forceSessionPersistence = " + this.isForceSessionPersistence()};
            tracer.createWarning("DisableSessionPersistence and forceSessionPersistence cannot be both true", currentValues);
        }
        if (!(this.getMethodToCallOnRefresh() == null && !this.isResetDataOnRefresh() || this.isProgressiveRenderAndRefresh() || this.isRefreshedByAction() || this.isProgressiveRenderViaAJAX() || StringUtils.isNotEmpty((String)this.conditionalRefresh) || this.refreshTimer > 0)) {
            currentValues = new String[]{"methodToCallONRefresh = " + this.getMethodToCallOnRefresh(), "resetDataONRefresh = " + this.isResetDataOnRefresh(), "progressiveRenderAndRefresh = " + this.isProgressiveRenderAndRefresh(), "refreshedByAction = " + this.isRefreshedByAction(), "progressiveRenderViaAJAX = " + this.isProgressiveRenderViaAJAX(), "conditionalRefresh = " + this.getConditionalRefresh(), "refreshTimer = " + this.getRefreshTimer()};
            tracer.createWarning("MethodToCallONRefresh and resetDataONRefresh should only be set when a trigger event is set", currentValues);
        }
        if (StringUtils.isNotEmpty((String)this.getProgressiveRender()) && StringUtils.isNotEmpty((String)this.conditionalRefresh)) {
            currentValues = new String[]{"progressiveRender = " + this.getProgressiveRender(), "conditionalRefresh = " + this.getConditionalRefresh()};
            tracer.createWarning("DO NOT use progressiveRender and conditionalRefresh on the same component unless it is known that the component will always be visible in all cases when a conditionalRefresh happens (ie conditionalRefresh has progressiveRender's condition anded with its own condition). If a component should be refreshed every time it is shown, use the progressiveRenderAndRefresh option with this property instead.", currentValues);
        }
        if (!Validator.validateSpringEL(this.getProgressiveRender())) {
            currentValues = new String[]{"progressiveRender =" + this.getProgressiveRender()};
            tracer.createError("ProgressiveRender must follow the Spring EL @{} format", currentValues);
        }
        if (!Validator.validateSpringEL(this.getConditionalRefresh())) {
            currentValues = new String[]{"conditionalRefresh =" + this.getConditionalRefresh()};
            tracer.createError("conditionalRefresh must follow the Spring EL @{} format", currentValues);
        }
    }

    @Override
    public boolean isOmitFromFormPost() {
        return this.omitFromFormPost;
    }

    @Override
    public void setOmitFromFormPost(boolean omitFromFormPost) {
        this.omitFromFormPost = omitFromFormPost;
    }
}

