/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.component.ReferenceCopy;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.DelayedCopyableHandler;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.RecycleUtils;

public final class CopyUtils {
    private static Boolean delay;
    private static final Map<Class<?>, ClassMetadata> CLASS_META_CACHE;

    public static boolean isDelay() {
        if (delay == null) {
            boolean defaultDelay = false;
            Config config = ConfigContext.getCurrentContextConfig();
            delay = config == null ? defaultDelay : config.getBooleanProperty("rice.krad.copyable.delay", defaultDelay);
        }
        return delay;
    }

    public static <T> T copy(Copyable obj) {
        if (obj == null) {
            return null;
        }
        String cid = null;
        if (ViewLifecycle.isTrace()) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            int i = 3;
            while (ComponentUtils.class.getName().equals(trace[i].getClassName())) {
                ++i;
            }
            StackTraceElement caller = trace[i];
            cid = obj.getClass().getSimpleName() + ":" + caller.getClassName() + ":" + caller.getMethodName() + ":" + caller.getLineNumber();
            ProcessLogger.ntrace("deep-copy:", ":" + cid, 1000L, 500L);
        }
        return (T)CopyUtils.getDeepCopy(obj);
    }

    public static boolean isCopyAvailable(Class<?> type) {
        return type != null && (Copyable.class.isAssignableFrom(type) || ArrayList.class.isAssignableFrom(type) || LinkedList.class.isAssignableFrom(type) || HashMap.class.isAssignableFrom(type) || HashSet.class.isAssignableFrom(type) || type.isArray());
    }

    public static <T> T getShallowCopy(T obj) throws CloneNotSupportedException {
        if (obj == null) {
            return null;
        }
        if (ViewLifecycle.isTrace()) {
            ProcessLogger.ntrace("clone:", ":" + obj.getClass().getSimpleName(), 1000L);
        }
        T t = obj;
        synchronized (t) {
            if (obj instanceof Copyable) {
                return (T)((Copyable)obj).clone();
            }
            if (obj instanceof Object[]) {
                return (T)((Object[])obj).clone();
            }
            if (obj instanceof ArrayList) {
                return (T)((ArrayList)obj).clone();
            }
            if (obj instanceof LinkedList) {
                return (T)((LinkedList)obj).clone();
            }
            if (obj instanceof HashSet) {
                return (T)((HashSet)obj).clone();
            }
            if (obj instanceof HashMap) {
                return (T)((HashMap)obj).clone();
            }
            throw new CloneNotSupportedException("Not a supported copyable type.  This condition should not be reached. " + obj.getClass() + " " + obj);
        }
    }

    private static boolean isDeep(CopyReference<?> ref, Object source) {
        Class<?> collectionType;
        if (!(ref instanceof FieldReference)) {
            return true;
        }
        FieldReference fieldRef = (FieldReference)ref;
        Field field = fieldRef.field;
        if (field.isAnnotationPresent(ReferenceCopy.class)) {
            return false;
        }
        return source instanceof Copyable || !(source instanceof Map) && !(source instanceof List) || Object.class.equals(collectionType = CopyUtils.getMetadata(fieldRef.source.getClass()).collectionTypeByField.get(field)) || CopyUtils.isCopyAvailable(collectionType);
    }

    private static boolean isCopy(CopyReference<?> ref) {
        if (!(ref instanceof FieldReference)) {
            return true;
        }
        FieldReference fieldRef = (FieldReference)ref;
        Field field = fieldRef.field;
        ReferenceCopy refCopy = field.getAnnotation(ReferenceCopy.class);
        return refCopy == null || refCopy.newCollectionInstance();
    }

    public static <T> T unwrap(T obj) {
        return DelayedCopyableHandler.unwrap(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getDeepCopy(T obj) {
        CopyState copyState = RecycleUtils.getRecycledInstance(CopyState.class);
        if (copyState == null) {
            copyState = new CopyState();
        }
        obj = CopyUtils.unwrap(obj);
        SimpleReference<?> topReference = CopyUtils.getSimpleReference(obj);
        try {
            copyState.queue.offer(topReference);
            while (!copyState.queue.isEmpty()) {
                CopyReference<?> toCopy = copyState.queue.poll();
                Object source = toCopy.get();
                if (source == null || !CopyUtils.isCopyAvailable(source.getClass()) || !CopyUtils.isCopy(toCopy)) continue;
                if (source instanceof Copyable) {
                    source = CopyUtils.unwrap(source);
                }
                if (ViewLifecycle.isTrace()) {
                    ProcessLogger.ntrace("deep-copy:", ":" + toCopy.getPath(), 10000L, 1000L);
                }
                toCopy.set(copyState.getTarget(source, CopyUtils.isDeep(toCopy, source), toCopy));
                if (toCopy == topReference) continue;
                CopyUtils.recycle(toCopy);
            }
            Object obj2 = topReference.get();
            return (T)obj2;
        }
        finally {
            CopyUtils.recycle(topReference);
            copyState.recycle();
        }
    }

    public static Map<String, Annotation> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        if (clazz == null) {
            return Collections.emptyMap();
        }
        Map<String, Annotation> rv = CopyUtils.getMetadata(clazz).annotatedFieldsByAnnotationType.get(annotationClass);
        return rv == null ? Collections.emptyMap() : rv;
    }

    public static boolean fieldHasAnnotation(Class<?> clazz, String fieldName, Class<? extends Annotation> annotationClass) {
        return CopyUtils.getFieldAnnotation(clazz, fieldName, annotationClass) != null;
    }

    public static Annotation getFieldAnnotation(Class<?> clazz, String fieldName, Class<? extends Annotation> annotationClass) {
        Map<String, Annotation> annotationsByField = CopyUtils.getFieldsWithAnnotation(clazz, annotationClass);
        return annotationsByField == null ? null : annotationsByField.get(fieldName);
    }

    private static <T> void recycle(CopyReference<T> ref) {
        ref.clean();
        RecycleUtils.recycle(ref);
    }

    private static SimpleReference<?> getSimpleReference(Object value) {
        SimpleReference ref = RecycleUtils.getRecycledInstance(SimpleReference.class);
        if (ref == null) {
            ref = new SimpleReference();
        }
        ref.targetClass = value.getClass();
        ref.value = value;
        return ref;
    }

    private static <T> FieldReference<T> getFieldReference(Object source, Object target, Field field, CopyReference<T> pref) {
        Type[] params;
        Class<T> targetClass;
        Class<?> sourceType;
        Type targetType;
        FieldReference ref = RecycleUtils.getRecycledInstance(FieldReference.class);
        if (ref == null) {
            ref = new FieldReference();
        }
        ref.source = source;
        ref.target = target;
        ref.field = field;
        DelayedCopy delayedCopy = field.getAnnotation(DelayedCopy.class);
        ref.delayAvailable = delayedCopy != null && (!delayedCopy.inherit() || pref.isDelayAvailable());
        Map<String, Type> pTypeVars = pref.getTypeVariables();
        if (pTypeVars != null && source != null && (targetType = ObjectPropertyUtils.findGenericType(sourceType = source.getClass(), targetClass = pref.getTargetClass())) instanceof ParameterizedType) {
            ParameterizedType parameterizedTargetType = (ParameterizedType)targetType;
            params = parameterizedTargetType.getActualTypeArguments();
            for (int j = 0; j < params.length; ++j) {
                if (!(params[j] instanceof TypeVariable)) continue;
                Type pType = pTypeVars.get(targetClass.getTypeParameters()[j].getName());
                ref.typeVariables.put(((TypeVariable)params[j]).getName(), pType);
            }
        }
        Class<?> rawType = field.getType();
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            TypeVariable<Class<?>>[] typeParams = rawType.getTypeParameters();
            params = parameterizedType.getActualTypeArguments();
            assert (params.length == typeParams.length);
            for (int i = 0; i < params.length; ++i) {
                Type fType;
                Type paramType = params[i];
                if (paramType instanceof TypeVariable && (fType = ref.typeVariables.get(((TypeVariable)paramType).getName())) != null) {
                    paramType = fType;
                }
                ref.typeVariables.put(typeParams[i].getName(), paramType);
            }
        }
        return ref;
    }

    private static <T> ArrayReference<T> getArrayReference(Object source, Object target, int index, CopyReference<?> pref) {
        ArrayReference ref = RecycleUtils.getRecycledInstance(ArrayReference.class);
        if (ref == null) {
            ref = new ArrayReference();
        }
        ref.source = source;
        ref.target = target;
        ref.index = index;
        ref.delayAvailable = pref.isDelayAvailable();
        ref.typeVariables.putAll(pref.getTypeVariables());
        return ref;
    }

    private static ListReference<?> getListReference(List<?> source, List<?> target, int index, Class<?> targetClass, Type type, CopyReference<?> pref) {
        ListReference ref = RecycleUtils.getRecycledInstance(ListReference.class);
        if (ref == null) {
            ref = new ListReference();
        }
        ref.source = source;
        ref.target = target;
        ref.index = index;
        ref.targetClass = targetClass;
        ref.type = type;
        ref.delayAvailable = pref.isDelayAvailable();
        ref.typeVariables.putAll(pref.getTypeVariables());
        ref.path = pref == null || pref.getPath() == null ? "[" + index + "]" : pref.getPath() + "[" + index + "]";
        return ref;
    }

    private static MapReference<?> getMapReference(Map.Entry<?, ?> sourceEntry, Map<?, ?> target, Class<?> targetClass, Type type, CopyReference<?> pref) {
        MapReference ref = RecycleUtils.getRecycledInstance(MapReference.class);
        if (ref == null) {
            ref = new MapReference();
        }
        ref.sourceEntry = sourceEntry;
        ref.target = target;
        ref.targetClass = targetClass;
        ref.type = type;
        ref.delayAvailable = pref.isDelayAvailable();
        ref.typeVariables.putAll(pref.getTypeVariables());
        ref.path = pref == null || pref.getPath() == null ? "[" + sourceEntry.getKey() + "]" : pref.getPath() + "[" + sourceEntry.getKey() + "]";
        return ref;
    }

    private static final ClassMetadata getMetadata(Class<?> targetClass) {
        ClassMetadata metadata = CLASS_META_CACHE.get(targetClass);
        if (metadata == null) {
            metadata = new ClassMetadata(targetClass);
            CLASS_META_CACHE.put(targetClass, metadata);
        }
        return metadata;
    }

    static {
        CLASS_META_CACHE = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class ClassMetadata {
        private final List<Field> cloneFields;
        private final Map<Field, Class<?>> collectionTypeByField;
        private final Map<Class<?>, Map<String, Annotation>> annotatedFieldsByAnnotationType;

        private ClassMetadata(Class<?> targetClass) {
            ArrayList<Object> cloneList = new ArrayList<Object>();
            HashMap collectionTypeMap = new HashMap();
            HashMap<Class<? extends Annotation>, HashMap<String, Annotation>> annotationMap = new HashMap<Class<? extends Annotation>, HashMap<String, Annotation>>();
            for (Class<?> currentClass = targetClass; currentClass != Object.class && currentClass != null; currentClass = currentClass.getSuperclass()) {
                for (Field currentField : currentClass.getDeclaredFields()) {
                    Class<?> collectionType;
                    if ((currentField.getModifiers() & 8) == 8) continue;
                    Annotation[] annotations = currentField.getAnnotations();
                    if (annotations != null) {
                        for (Annotation annotation : annotations) {
                            Class<? extends Annotation> annotationType = annotation.annotationType();
                            HashMap<String, Annotation> amap = (HashMap<String, Annotation>)annotationMap.get(annotationType);
                            if (amap == null) {
                                amap = new HashMap<String, Annotation>();
                                annotationMap.put(annotationType, amap);
                            }
                            amap.put(currentField.getName(), annotation);
                        }
                    }
                    Class<?> type = currentField.getType();
                    boolean isList = List.class.isAssignableFrom(type);
                    boolean isMap = Map.class.isAssignableFrom(type);
                    if (isList || isMap || CopyUtils.isCopyAvailable(type)) {
                        currentField.setAccessible(true);
                        cloneList.add(currentField);
                    }
                    if (!isList && !isMap || !(collectionType = ObjectPropertyUtils.getUpperBound(ObjectPropertyUtils.getComponentType(currentField.getGenericType()))).equals(Object.class) && !CopyUtils.isCopyAvailable(collectionType)) continue;
                    collectionTypeMap.put(currentField, collectionType);
                }
            }
            this.cloneFields = Collections.unmodifiableList(cloneList);
            this.collectionTypeByField = Collections.unmodifiableMap(collectionTypeMap);
            for (Map.Entry entry : annotationMap.entrySet()) {
                entry.setValue(Collections.unmodifiableMap((Map)entry.getValue()));
            }
            this.annotatedFieldsByAnnotationType = Collections.unmodifiableMap(annotationMap);
        }
    }

    private static class MapReference<T>
    implements CopyReference<T> {
        private Class<T> targetClass;
        private Type type;
        private Map.Entry<Object, T> sourceEntry;
        private Map<Object, T> target;
        private boolean delayAvailable;
        private String path;
        private Map<String, Type> typeVariables = new HashMap<String, Type>();

        private MapReference() {
        }

        @Override
        public Class<T> getTargetClass() {
            return this.targetClass;
        }

        @Override
        public boolean isDelayAvailable() {
            return this.delayAvailable;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Map<String, Type> getTypeVariables() {
            return this.typeVariables;
        }

        @Override
        public T get() {
            return this.sourceEntry.getValue();
        }

        @Override
        public void set(Object value) {
            this.target.put(this.sourceEntry.getKey(), this.targetClass.cast(value));
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void clean() {
            this.targetClass = null;
            this.type = null;
            this.sourceEntry = null;
            this.target = null;
            this.delayAvailable = false;
            this.typeVariables.clear();
        }
    }

    private static class ListReference<T>
    implements CopyReference<T> {
        private Class<T> targetClass;
        private Type type;
        private List<T> source;
        private List<T> target;
        private int index = -1;
        private boolean delayAvailable;
        private String path;
        private Map<String, Type> typeVariables = new HashMap<String, Type>();

        private ListReference() {
        }

        @Override
        public Class<T> getTargetClass() {
            return this.targetClass;
        }

        @Override
        public boolean isDelayAvailable() {
            return this.delayAvailable;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Map<String, Type> getTypeVariables() {
            return this.typeVariables;
        }

        @Override
        public T get() {
            return this.targetClass.cast(this.source.get(this.index));
        }

        @Override
        public void set(Object value) {
            this.target.set(this.index, this.targetClass.cast(value));
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void clean() {
            this.targetClass = null;
            this.type = null;
            this.source = null;
            this.target = null;
            this.index = -1;
            this.delayAvailable = false;
            this.typeVariables.clear();
        }
    }

    private static class ArrayReference<T>
    implements CopyReference<T> {
        private Object source;
        private Object target;
        private int index = -1;
        private boolean delayAvailable;
        private String path;
        private Map<String, Type> typeVariables = new HashMap<String, Type>();

        private ArrayReference() {
        }

        @Override
        public Class<T> getTargetClass() {
            return this.source.getClass().getComponentType();
        }

        @Override
        public boolean isDelayAvailable() {
            return this.delayAvailable;
        }

        @Override
        public Type getType() {
            return this.source.getClass().getComponentType();
        }

        @Override
        public Map<String, Type> getTypeVariables() {
            return this.typeVariables;
        }

        @Override
        public T get() {
            return (T)Array.get(this.source, this.index);
        }

        @Override
        public void set(Object value) {
            Array.set(this.target, this.index, value);
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void clean() {
            this.source = null;
            this.target = null;
            this.index = -1;
            this.delayAvailable = false;
            this.path = null;
            this.typeVariables.clear();
        }
    }

    private static class FieldReference<T>
    implements CopyReference<T> {
        private Object source;
        private Object target;
        private Field field;
        private boolean delayAvailable;
        private Map<String, Type> typeVariables = new HashMap<String, Type>();
        private String path;

        private FieldReference() {
        }

        @Override
        public Class<T> getTargetClass() {
            return this.field.getType();
        }

        @Override
        public boolean isDelayAvailable() {
            return this.delayAvailable;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public Map<String, Type> getTypeVariables() {
            return this.typeVariables;
        }

        @Override
        public T get() {
            try {
                ReferenceCopy ref = this.field.getAnnotation(ReferenceCopy.class);
                if (ref != null && ref.referenceTransient()) {
                    return null;
                }
                return (T)this.field.get(this.source);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Access error attempting to get from " + this.field, e);
            }
        }

        @Override
        public void set(Object value) {
            try {
                this.field.set(this.target, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Access error attempting to set " + this.field, e);
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void clean() {
            this.source = null;
            this.target = null;
            this.field = null;
            this.delayAvailable = false;
            this.path = null;
            this.typeVariables.clear();
        }
    }

    private static class SimpleReference<T>
    implements CopyReference<T> {
        private T value;
        private Class<T> targetClass;

        private SimpleReference() {
        }

        @Override
        public Class<T> getTargetClass() {
            return this.targetClass;
        }

        @Override
        public boolean isDelayAvailable() {
            return false;
        }

        @Override
        public Type getType() {
            return this.targetClass;
        }

        @Override
        public Map<String, Type> getTypeVariables() {
            return Collections.emptyMap();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(Object value) {
            this.value = this.targetClass.cast(value);
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public void clean() {
            this.value = null;
            this.targetClass = null;
        }
    }

    private static interface CopyReference<T> {
        public Class<T> getTargetClass();

        public String getPath();

        public boolean isDelayAvailable();

        public Type getType();

        public Map<String, Type> getTypeVariables();

        public T get();

        public void set(Object var1);

        public void clean();
    }

    private static class CopyState {
        private final Queue<CopyReference<?>> queue = new LinkedList();
        private final Map<Object, Object> cache = new IdentityHashMap<Object, Object>();

        private CopyState() {
        }

        private Object getTarget(Object source, boolean queueDeepReferences, CopyReference<?> ref) {
            Object target;
            boolean useCache = source != Collections.EMPTY_LIST && source != Collections.EMPTY_MAP;
            Object object = target = useCache ? this.cache.get(source) : null;
            if (target == null) {
                Class<?> targetClass = ref.getTargetClass();
                if (Copyable.class.isAssignableFrom(targetClass) && targetClass.isInterface() && ref.isDelayAvailable() && CopyUtils.isDelay()) {
                    target = DelayedCopyableHandler.getDelayedCopy((Copyable)source);
                } else {
                    try {
                        target = CopyUtils.getShallowCopy(source);
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IllegalStateException("Unexpected cloning error during shallow copy", e);
                    }
                    if (queueDeepReferences) {
                        this.queueDeepCopyReferences(source, target, ref);
                    }
                }
                if (useCache) {
                    this.cache.put(source, target);
                }
            }
            return target;
        }

        private void queueDeepCopyReferences(Object source, Object target, CopyReference<?> ref) {
            Class<?> componentClass;
            Type componentType;
            Class<?> type = source.getClass();
            Class<?> targetClass = ref.getTargetClass();
            if (!CopyUtils.isCopyAvailable(type)) {
                return;
            }
            if (this.cache.containsKey(source)) {
                return;
            }
            if (target == null) {
                this.cache.put(source, source);
            }
            if (Copyable.class.isAssignableFrom(type)) {
                for (Field field : CopyUtils.getMetadata(type).cloneFields) {
                    this.queue.offer(CopyUtils.getFieldReference(source, target, field, ref));
                }
                return;
            }
            if (List.class.isAssignableFrom(targetClass)) {
                List sourceList = (List)source;
                List targetList = (List)target;
                componentType = ObjectPropertyUtils.getComponentType(ref.getType());
                if (componentType instanceof TypeVariable) {
                    TypeVariable tvar = (TypeVariable)componentType;
                    if (ref.getTypeVariables().containsKey(tvar.getName())) {
                        componentType = ref.getTypeVariables().get(tvar.getName());
                    }
                }
                componentClass = ObjectPropertyUtils.getUpperBound(componentType);
                for (int i = 0; i < sourceList.size(); ++i) {
                    this.queue.offer(CopyUtils.getListReference(sourceList, targetList, i, componentClass, componentType, ref));
                }
            }
            if (Map.class.isAssignableFrom(targetClass)) {
                Map sourceMap = (Map)source;
                Map targetMap = (Map)target;
                componentType = ObjectPropertyUtils.getComponentType(ref.getType());
                componentClass = ObjectPropertyUtils.getUpperBound(componentType);
                for (Map.Entry sourceEntry : sourceMap.entrySet()) {
                    this.queue.offer(CopyUtils.getMapReference(sourceEntry, targetMap, componentClass, componentType, ref));
                }
            }
            if (targetClass.isArray()) {
                for (int i = 0; i < Array.getLength(source); ++i) {
                    this.queue.offer(CopyUtils.getArrayReference(source, target, i, ref));
                }
            }
        }

        private void recycle() {
            this.queue.clear();
            this.cache.clear();
            RecycleUtils.recycle(this);
        }
    }
}

