/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util;

import java.lang.reflect.Field;
import java.util.Calendar;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class EqualsAndHashCodeUtils {
    private EqualsAndHashCodeUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static <T> boolean equalsUsingCompareToOnFields(T o1, T o2, String ... fieldNames) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        boolean isEqual = true;
        Class<?> targetClass = o1.getClass();
        try {
            for (String fieldName : fieldNames) {
                Field field = targetClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                Class<?> fieldClass = field.getType();
                if (ArrayUtils.contains((Object[])fieldClass.getInterfaces(), Comparable.class)) {
                    Comparable c2;
                    Comparable c1 = (Comparable)field.get(o1);
                    if (c1 == (c2 = (Comparable)field.get(o2))) continue;
                    isEqual = c1 == null || c2 == null ? false : c1.compareTo(c2) == 0;
                } else {
                    isEqual = false;
                }
                if (!isEqual) break;
            }
            return isEqual;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int hashCodeForCalendars(Calendar ... calendars) {
        HashCodeBuilder hcb = new HashCodeBuilder();
        for (Calendar calendar : calendars) {
            if (calendar == null) continue;
            hcb.append(calendar.getTimeInMillis());
        }
        return hcb.toHashCode();
    }
}

