/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.org;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.org.FederalApprovingAgency;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.OrganizationIndirectcost;
import org.kuali.coeus.common.framework.org.OrganizationYnq;
import org.kuali.coeus.common.framework.org.audit.OrganizationAudit;
import org.kuali.coeus.common.framework.org.audit.OrganizationAuditAcceptedType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class OrganizationMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final String FEDERAL_APPROVING_AGENCY_NAME = "organizationIdcs[%s].federalApprovingAgencyName";
    private transient ErrorReporter errorReporter;
    private transient RolodexService rolodexService;

    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        result &= this.checkYNQ(document);
        result &= this.checkRolodexEntries(document);
        result &= this.checkAudits(document);
        return result &= this.checkIdcs(document);
    }

    private boolean checkYNQ(MaintenanceDocument maintenanceDocument) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass());
        }
        Organization newOrganization = (Organization)maintenanceDocument.getNewMaintainableObject().getDataObject();
        int i = 0;
        for (OrganizationYnq organizationYnq : newOrganization.getOrganizationYnqs()) {
            organizationYnq.refreshReferenceObject("ynq");
            if (StringUtils.isBlank((CharSequence)organizationYnq.getAnswer())) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].answer", i), "error.organization.questionYnq.answerRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)organizationYnq.getAnswer()) && organizationYnq.getAnswer().equalsIgnoreCase(organizationYnq.getYnq().getExplanationRequiredFor()) && StringUtils.isBlank((CharSequence)organizationYnq.getExplanation())) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].explanation", i), "error.organization.questionYnq.explanationRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)organizationYnq.getAnswer()) && organizationYnq.getAnswer().equalsIgnoreCase(organizationYnq.getYnq().getDateRequiredFor()) && organizationYnq.getReviewDate() == null) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].reviewDate", i), "error.organization.questionYnq.reviewDateRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private boolean checkRolodexEntries(MaintenanceDocument maintenanceDocument) {
        Organization newOrganization = (Organization)maintenanceDocument.getNewMaintainableObject().getDataObject();
        boolean valid = this.isValidRolodex(newOrganization.getOnrResidentRep(), "document.newMaintainableObject.onrResidentRep");
        valid &= this.isValidRolodex(newOrganization.getContactAddressId(), "document.newMaintainableObject.contactAddressId");
        valid &= this.isValidRolodex(newOrganization.getCognizantAuditor(), "document.newMaintainableObject.cognizantAuditor");
        valid &= this.isValidRolodex(newOrganization.getLobbyingRegistrant(), "document.newMaintainableObject.lobbyingRegistrant");
        return valid &= this.isValidRolodex(newOrganization.getLobbyingIndividual(), "document.newMaintainableObject.lobbyingIndividual");
    }

    private boolean isValidRolodex(Integer key, String field) {
        if (key != null && this.getRolodexService().getRolodex(key) == null) {
            this.getErrorReporter().reportError(field, "error.organization.rolodexEntry.invalid", new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkAudits(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        Organization newOrganization = (Organization)maintenanceDocument.getNewMaintainableObject().getDataObject();
        int i = 0;
        for (OrganizationAudit organizationAudit : newOrganization.getOrganizationAudits()) {
            valid &= this.checkExistenceFromTable(OrganizationAuditAcceptedType.class, Collections.singletonMap("code", organizationAudit.getAuditAcceptedCode()), String.format("organizationAudits[%s].auditAcceptedCode", i), "Accepted Type");
            ++i;
        }
        return valid;
    }

    private boolean checkIdcs(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        Organization newOrganization = (Organization)maintenanceDocument.getNewMaintainableObject().getDataObject();
        int i = 0;
        for (OrganizationIndirectcost organizationIndirectcost : newOrganization.getOrganizationIdcs()) {
            if (FederalApprovingAgency.OTHER.getCode().equals(organizationIndirectcost.getFederalApprovingAgency()) && StringUtils.isBlank((CharSequence)organizationIndirectcost.getFederalApprovingAgencyName())) {
                this.getErrorReporter().reportError(String.format("document.newMaintainableObject.organizationIdcs[%s].federalApprovingAgencyName", i), "error.organization.idc.agency.name.required", FederalApprovingAgency.OTHER.getDescription());
                valid = false;
            } else if (!FederalApprovingAgency.OTHER.getCode().equals(organizationIndirectcost.getFederalApprovingAgency()) && StringUtils.isNotBlank((CharSequence)organizationIndirectcost.getFederalApprovingAgencyName())) {
                this.getErrorReporter().reportError(String.format("document.newMaintainableObject.organizationIdcs[%s].federalApprovingAgencyName", i), "error.organization.idc.agency.name.not.allowed", FederalApprovingAgency.OTHER.getDescription());
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public RolodexService getRolodexService() {
        if (this.rolodexService == null) {
            this.rolodexService = KcServiceLocator.getService(RolodexService.class);
        }
        return this.rolodexService;
    }
}

