/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ProposalBaseStream<T extends XmlObject>
implements XmlStream<T> {
    @Autowired
    @Qualifier(value="dateTimeService")
    private DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService proposalBudgetService;

    protected Budget getBudget(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return this.proposalBudgetService.getFinalBudgetVersion(proposalDevelopmentDocument);
    }

    public ScaleTwoDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        ScaleTwoDecimal monthCount = ScaleTwoDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return ScaleTwoDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BigDecimal startMonthFraction = BigDecimal.valueOf(++startMonthDays).setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(startMonthMaxDays).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP);
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BigDecimal endMonthFraction = BigDecimal.valueOf(endMonthDays).setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(endMonthMaxDays).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP);
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)monthCount.add((AbstractDecimal)new ScaleTwoDecimal(--fullMonthCount))).add((AbstractDecimal)new ScaleTwoDecimal(startMonthFraction))).add((AbstractDecimal)new ScaleTwoDecimal(endMonthFraction));
        return monthCount;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ProposalBudgetService getProposalBudgetService() {
        return this.proposalBudgetService;
    }

    public void setProposalBudgetService(ProposalBudgetService proposalBudgetService) {
        this.proposalBudgetService = proposalBudgetService;
    }
}

